/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.editor.plugins;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import oracle.hcs.HCSArb;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.MetadataUpdateListener;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.syntaxbuilder.editor.plugins.InsertionHandlerEditorPlugin;
import oracle.hcs.syntaxbuilder.shuttle.TemplateHandlerPopup;
import oracle.hcs.syntaxbuilder.specification.Spec;
import oracle.hcs.syntaxbuilder.specification.SpecTreeNode;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.syntaxparser.SyntaxParser;
import oracle.hcs.templates.templatedialog.TemplateHelper;
import oracle.hcs.templates.templatedialog.TemplateHelperListener;
import oracle.hcs.templates.templateview.SyntaxListener;
import oracle.hcs.templates.templateview.TemplateData;
import oracle.hcs.templates.templateview.TemplateGUI;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;

public class TemplateHandlerEmbedEditorPlugin
extends TemplateHandlerPopup
implements EditorPlugin,
MetadataUpdateListener {
    private boolean ignoreTokenSelection = false;
    private static final Logger LOG = Logger.getLogger(TemplateHandlerEmbedEditorPlugin.class.getName());
    private static final TemplateData.Mode[] EMBEDINSERT = new TemplateData.Mode[]{TemplateData.Mode.WRAP};
    private CodeEditor editor;
    private Container bottomMargin;
    private JPanel templatePanel;
    private JPanel defaultPanel;
    private TemplateGUI gui;
    private TemplateHelper helper;
    private String schemaName;
    private String connectionName;
    private final SyntaxListener listener = new SyntaxListener(){

        @Override
        public void syntaxChanged(Object object, String string) {
            TemplateHandlerEmbedEditorPlugin.this.ignoreTokenSelection = true;
            TemplateData templateData = new TemplateData(string, TemplateData.Mode.OK);
            templateData = TemplateHandlerEmbedEditorPlugin.this.formatTemplateData(templateData);
            LOG.finest(String.format("insert [%s] on change of [%s]", templateData.getSyntax(), object));
            TemplateHandlerEmbedEditorPlugin.this.ihandler.insertSyntax(templateData, null, false);
            TemplateHandlerEmbedEditorPlugin.this.ignoreTokenSelection = false;
        }
    };
    private final TemplateHelperListener reinitListener = new TemplateHelperListener(){

        @Override
        public void helperReinitialized() {
            if (TemplateHandlerEmbedEditorPlugin.this.helper != null) {
                TemplateHandlerEmbedEditorPlugin.this.remove();
                TemplateHandlerEmbedEditorPlugin.this.helper.removeTemplateHelperListener(TemplateHandlerEmbedEditorPlugin.this.reinitListener);
                TemplateHandlerEmbedEditorPlugin.this.helper = null;
            }
            if (TemplateHandlerEmbedEditorPlugin.this.gui != null) {
                TemplateHandlerEmbedEditorPlugin.this.gui.removeSyntaxListener(TemplateHandlerEmbedEditorPlugin.this.listener);
                TemplateHandlerEmbedEditorPlugin.this.gui.dispose();
                TemplateHandlerEmbedEditorPlugin.this.gui = null;
            }
        }
    };

    public TemplateHandlerEmbedEditorPlugin(InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, Spec spec, String string, String string2) {
        super(insertionHandlerEditorPlugin, spec, (Component)Ide.getMainWindow());
        this.init(string2, string);
    }

    public TemplateHandlerEmbedEditorPlugin(InsertionHandlerEditorPlugin insertionHandlerEditorPlugin, Spec spec, Container container, String string, String string2) {
        this(insertionHandlerEditorPlugin, spec, string, string2);
        this.bottomMargin = container;
    }

    public void init(String string, String string2) {
        this.schemaName = string2;
        this.connectionName = string;
        if (string != null && string2 != null) {
            HCSMetadataCache.addUpdateListener(string, string2, this);
        }
    }

    @Override
    public void insertNode(SpecTreeNode specTreeNode, TemplateData.Mode[] modeArray) {
        if (modeArray.length == 1 && modeArray[0] != TemplateData.Mode.OK) {
            super.insertNode(specTreeNode, modeArray);
        }
    }

    @Override
    public void callDefaultTemplate() {
        JPanel jPanel = this.templatePanel;
        this.templatePanel = this.createDefaultPanel();
        this.displayPanel(jPanel, this.templatePanel);
    }

    @Override
    public TemplateData callTemplate(SpecTreeNode specTreeNode, TemplateData.Mode[] modeArray) throws SQLException, IOException {
        return this.callTemplate(specTreeNode, modeArray, true);
    }

    private TemplateData callTemplate(SpecTreeNode specTreeNode, TemplateData.Mode[] modeArray, boolean bl) throws SQLException, IOException {
        if (specTreeNode == null || !specTreeNode.isInsertable()) {
            return null;
        }
        TemplateHelper templateHelper = specTreeNode.getTemplateHelper();
        if (templateHelper == null) {
            LOG.finest(String.format("Inserting node %s", specTreeNode));
            TemplateData templateData = new TemplateData(specTreeNode.getTemplate());
            return templateData;
        }
        LOG.finest(String.format("Inserting template node %s", specTreeNode));
        TemplateGUI templateGUI = this.getGui(templateHelper, bl);
        templateGUI.setValueMap(this.createValueMap());
        JPanel jPanel = this.templatePanel;
        this.templatePanel = this.buildPanel(templateGUI, templateHelper.getTitle(), modeArray);
        this.displayPanel(jPanel, this.templatePanel);
        TemplateData.Mode[] modeArray2 = templateHelper.availableModes(modeArray);
        TemplateData templateData = modeArray2.length > 0 ? templateGUI.getSyntax(modeArray[0]) : templateGUI.getSyntax(TemplateData.Mode.REPLACE);
        templateData = this.formatTemplateData(templateData);
        if (templateData != null) {
            LOG.finest(String.format("Inserting syntax %s", templateData.getSyntax()));
        }
        return templateData;
    }

    private void displayPanel(JPanel jPanel, final JPanel jPanel2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TemplateHandlerEmbedEditorPlugin.this.bottomMargin.removeAll();
                if (TemplateHandlerEmbedEditorPlugin.this.editor != null) {
                    TemplateHandlerEmbedEditorPlugin.this.editor.addComponentToMargin((JComponent)jPanel2, CodeEditor.MarginLocation.BOTTOM);
                } else {
                    TemplateHandlerEmbedEditorPlugin.this.bottomMargin.add((Component)jPanel2, "South");
                }
                boolean bl = TemplateHandlerEmbedEditorPlugin.this.bottomMargin.isEnabled();
                TemplateHandlerEmbedEditorPlugin.this.bottomMargin.setEnabled(bl);
                TemplateHandlerEmbedEditorPlugin.this.bottomMargin.getParent().validate();
                jPanel2.setVisible(false);
                jPanel2.setVisible(true);
            }
        });
    }

    @Override
    public void syntaxClicked(MouseEvent mouseEvent, ParseNode parseNode) {
    }

    @Override
    public void tokenSelected(String string, int n, ParseNode parseNode, SpecTreeNode specTreeNode) {
        if (parseNode != null && !this.ignoreTokenSelection) {
            SpecTreeNode specTreeNode2;
            SpecTreeNode specTreeNode3 = specTreeNode2 = specTreeNode == null ? this.spec.findMatchingNode(parseNode) : specTreeNode;
            if (specTreeNode2 != null) {
                TemplateHelper templateHelper = specTreeNode2.getTemplateHelper();
                if (templateHelper != null) {
                    TemplateGUI templateGUI = this.getGui(templateHelper, false);
                    try {
                        String string2 = this.ihandler.getSyntax();
                        if (parseNode.getReplaceOffset() == n) {
                            templateGUI.loadParseNode(parseNode, string2);
                        } else if (parseNode.getReplaceOffset() > 0 && parseNode.getReplaceEnd() <= string2.length()) {
                            templateGUI.loadParseNode(parseNode, string2.substring(parseNode.getReplaceOffset(), parseNode.getReplaceEnd()));
                        }
                        this.callTemplate(specTreeNode2, EDITBUTTONS, false);
                    }
                    catch (Throwable throwable) {
                        LOG.log(Level.SEVERE, "loadParseNode failed!", throwable);
                    }
                }
            } else if (parseNode != null) {
                JPanel jPanel = this.templatePanel;
                this.templatePanel = this.buildTemplateNotFoundPanel();
                this.displayPanel(jPanel, this.templatePanel);
            }
        } else {
            String string3 = this.ihandler.getSyntax();
            if (string3 != null && !string3.equalsIgnoreCase("")) {
                JPanel jPanel = this.templatePanel;
                this.templatePanel = this.createDefaultPanel();
                this.displayPanel(jPanel, this.templatePanel);
            } else {
                this.remove();
            }
        }
    }

    private void remove() {
        if (this.templatePanel != null) {
            this.bottomMargin.remove(this.templatePanel);
            if (this.bottomMargin.getParent() != null) {
                this.bottomMargin.getParent().validate();
            }
            this.templatePanel = null;
        }
    }

    public JPanel getTemplatePanel() {
        return this.templatePanel;
    }

    @Override
    public void insertNode(SpecTreeNode specTreeNode) {
        this.insertNode(specTreeNode, EMBEDINSERT);
    }

    public void install(BasicEditorPane basicEditorPane) {
        this.editor = CodeEditor.getCodeEditor((BasicEditorPane)basicEditorPane);
        this.bottomMargin = (Container)this.editor.getFixedBottomMargin();
    }

    public void deinstall(BasicEditorPane basicEditorPane) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public void updateSchema() {
        try {
            if (this.connectionName != null && this.schemaName != null) {
                HCSMetadataCache.getUpdatedSchema(this.connectionName, this.schemaName);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private TemplateGUI getGui(TemplateHelper templateHelper, boolean bl) {
        boolean bl2;
        block8: {
            this.updateSchema();
            bl2 = false;
            if (this.gui != null && bl) {
                try {
                    String string = this.gui.getSyntax();
                    SyntaxParser syntaxParser = this.spec.getSyntaxParser();
                    ParseNode parseNode = new ParseNode();
                    parseNode = syntaxParser.parseSyntax(string, parseNode) && parseNode.getChildCount() > 0 ? parseNode.getChildren().get(0) : null;
                    if (parseNode == null) break block8;
                    Enumeration<TreeNode> enumeration = parseNode.breadthFirstEnumeration();
                    if (enumeration.hasMoreElements()) {
                        enumeration.nextElement();
                    }
                    while (enumeration.hasMoreElements()) {
                        ParseNode parseNode2 = (ParseNode)enumeration.nextElement();
                        String string2 = parseNode2.getType();
                        if (!HCSSyntaxType.FUNCTION.toString().equals(string2)) continue;
                        bl2 = true;
                        break;
                    }
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, "getGui failed!", exception);
                }
            }
        }
        if (templateHelper != this.helper || bl2) {
            if (this.helper != null) {
                this.helper.removeTemplateHelperListener(this.reinitListener);
            }
            this.helper = templateHelper;
            this.helper.addTemplateHelperListener(this.reinitListener);
            if (this.gui != null) {
                this.gui.removeSyntaxListener(this.listener);
                this.gui.dispose();
            }
            this.gui = templateHelper.getGUI(false);
            this.gui.addSyntaxListener(this.listener);
        }
        return this.gui;
    }

    private TemplateData formatTemplateData(TemplateData templateData) {
        if (templateData == null || templateData.getSyntax() == null) {
            return null;
        }
        String string = templateData.getSyntax();
        String string2 = this.spec.getSyntaxParser().formatSyntax(string);
        if (this.spec.getSyntaxParser().parseSyntax(string2, null)) {
            return new TemplateData(string2, templateData);
        }
        return templateData;
    }

    private JPanel buildPanel(final TemplateGUI templateGUI, String string, TemplateData.Mode[] modeArray) {
        String string2 = this.ihandler.getSelection();
        String string3 = this.ihandler.getSyntax();
        if (string3 != null && string3.equals(string2)) {
            string3 = null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("selection", string2);
        hashMap.put("contents", string3);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        JLabel jLabel = new JLabel(string);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont(1, (float)((double)font.getSize() * 1.2));
        jLabel.setFont(font2);
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
        jPanel2.add(jLabel);
        jPanel.add((Component)jPanel2, "North");
        Component component = templateGUI.getComponent();
        jPanel.add(component, "Center");
        if (modeArray.length > 1) {
            JPanel jPanel3 = new JPanel(new FlowLayout(2));
            jPanel.add((Component)jPanel3, "South");
            for (final TemplateData.Mode mode : modeArray) {
                jPanel3.add(new JButton(new AbstractAction(mode.toString()){
                    {
                        super(string);
                        this.putValue("mode", (Object)mode);
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            TemplateData.Mode mode2 = (TemplateData.Mode)((Object)this.getValue("mode"));
                            TemplateData templateData = templateGUI.getSyntax(mode2);
                            TemplateHandlerEmbedEditorPlugin.this.ihandler.insertSyntax(TemplateHandlerEmbedEditorPlugin.this.formatTemplateData(templateData));
                            TemplateHandlerEmbedEditorPlugin.this.remove();
                        }
                        catch (Throwable throwable) {
                            LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                        }
                    }
                }));
            }
        }
        return jPanel;
    }

    private JPanel buildTemplateNotFoundPanel() {
        JPanel jPanel = null;
        SpecTreeNode specTreeNode = this.spec.findByTemplateType("notfound");
        if (specTreeNode != null) {
            TemplateHelper templateHelper = specTreeNode.getTemplateHelper();
            TemplateGUI templateGUI = this.getGui(templateHelper, false);
            jPanel = new JPanel(new BorderLayout(0, 0));
            jPanel.add(templateGUI.getComponent(), "Center");
        } else {
            JLabel jLabel = new JLabel(HCSArb.getString("TEMPLATE_NOT_FOUND"));
            Font font = jLabel.getFont();
            Font font2 = font.deriveFont(1, (float)((double)font.getSize() * 1.2));
            jLabel.setFont(font2);
            jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jLabel, "Center");
        }
        return jPanel;
    }

    private JPanel createDefaultPanel() {
        if (this.defaultPanel == null) {
            SpecTreeNode specTreeNode = this.spec.findByTemplateType("default");
            if (specTreeNode != null) {
                TemplateHelper templateHelper = specTreeNode.getTemplateHelper();
                TemplateGUI templateGUI = this.getGui(templateHelper, false);
                this.defaultPanel = new JPanel(new BorderLayout(0, 0));
                this.defaultPanel.add(templateGUI.getComponent(), "Center");
            } else {
                this.defaultPanel = new JPanel(new BorderLayout());
                JLabel jLabel = new JLabel(HCSArb.getString("SELECT_TEMPLATE_INSTRUCTIONS"));
                Font font = jLabel.getFont();
                Font font2 = font.deriveFont(1, (float)((double)font.getSize() * 1.2));
                jLabel.setFont(font2);
                this.defaultPanel.add((Component)jLabel, "Center");
            }
        }
        return this.defaultPanel;
    }

    @Override
    public void metadataUpdated(HCSSchema hCSSchema) {
        this.gui = null;
        this.helper = null;
    }

    @Override
    public void metadataCleared() {
    }
}

