/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder.details;

import java.util.Collections;
import java.util.List;
import oracle.hcs.av.calcs.ReferencesTableModel;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.CalcReferences;
import oracle.hcs.syntaxbuilder.details.AbstractCalculatedMeasureTable;
import oracle.hcs.syntaxbuilder.details.CalculatedMeasureTablePanel;

public class CalculatedMeasureReferences
extends AbstractCalculatedMeasureTable {
    private CalculatedMeasureTablePanel referencesTable;

    @Override
    protected CalculatedMeasureTablePanel getCalculatedMeasureTable() {
        List<AVBaseMeasure> list = null;
        try {
            list = this.getReferences();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.referencesTable == null) {
            this.referencesTable = new CalculatedMeasureTablePanel(list, new ReferencesTableModel());
        }
        return this.referencesTable;
    }

    private List<AVBaseMeasure> getReferences() throws Exception {
        AVCalculatedMeasure aVCalculatedMeasure;
        List<AVBaseMeasure> list = Collections.emptyList();
        AnalyticView analyticView = this.getSchema().findAV(this.getAVName());
        if (analyticView != null && (aVCalculatedMeasure = analyticView.findCalculatedMeasure(this.getMeasureName())) != null) {
            list = CalcReferences.getReferences(aVCalculatedMeasure, this.getParser());
        }
        return list;
    }

    protected List<AVBaseMeasure> getMeasuresList() throws Exception {
        return this.getReferences();
    }
}

