/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.Database;
import oracle.hcs.db.DatabaseImpl;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.metadata.HCSMetadataReader;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSpec;
import oracle.hcs.syntaxbuilder.HCSSyntaxParser;
import oracle.hcs.syntaxbuilder.SyntaxBuilderPanel;
import oracle.hcs.syntaxbuilder.editor.plugins.InsertionHandlerHelper;
import oracle.hcs.syntaxbuilder.spec.Category;
import oracle.hcs.syntaxbuilder.spec.File;
import oracle.hcs.syntaxbuilder.spec.Insertable;
import oracle.hcs.syntaxbuilder.specification.Spec;
import oracle.hcs.templates.syntaxparser.SyntaxParser;
import oracle.hcs.templates.templatedialog.TemplateHelperFactory;
import oracle.hcs.templates.templatedialog.TemplateHelperFactoryImpl;
import oracle.hcs.util.HCSErrorDisplay;
import oracle.hcs.util.HCSResources;
import oracle.hcs.util.NonLazyFetchIcon;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;

public class SyntaxBuilderLauncher {
    private static final Logger LOG = Logger.getLogger(SyntaxBuilderLauncher.class.getName());
    public static final String WINDOW_SIZE = "WINDOW_SIZE";
    private static final String ANALYTIC_VIEWS = "CUBES";
    private static final String DIMENSIONS = "DIMENSIONS";

    public static String generateDimensionsXmlProperty(AnalyticView analyticView) {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        oracle.hcs.syntaxbuilder.spec.Spec spec = new oracle.hcs.syntaxbuilder.spec.Spec();
        for (int i = 0; i < analyticView.getDimensions().length; ++i) {
            Insertable insertable = new Insertable();
            spec.addInsertable(insertable);
            insertable.setName(analyticView.getDimensions()[i].getName());
            insertable.setIcon("HCSDIMENSION_ICON");
            File file = new File();
            file.setPackage(file.getClass().getPackage().getName());
            file.setPath("/oracle/hcs/measureexpression/dimensions.xml");
            insertable.addFile(file);
        }
        spec.toXml(stringBuilder);
        return stringBuilder.toString();
    }

    public static String generateAVXmlProperty(HCSSchema hCSSchema) {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        oracle.hcs.syntaxbuilder.spec.Spec spec = new oracle.hcs.syntaxbuilder.spec.Spec();
        for (AnalyticView analyticView : hCSSchema.getAnalyticViews()) {
            Insertable insertable = new Insertable();
            spec.addInsertable(insertable);
            insertable.setName(analyticView.getName());
            insertable.setIcon("HCSCUBE_ICON");
            Category category = new Category();
            insertable.addCategory(category);
            category.setName(HCSArb.getString("EXPRESSION_EDITOR_MEASURES"));
            category.setIcon("HCSMEASURE_FOLDER_ICON");
            Category category2 = new Category();
            insertable.addCategory(category2);
            category2.setName(HCSArb.getString("EXPRESSION_EDITOR_CALC_MEASURES"));
            category2.setIcon("HCSCALCMEASURE_FOLDER_ICON");
            List<AVBaseMeasure> list = analyticView.getStoredAndCalculatedMeasures();
            for (AVBaseMeasure aVBaseMeasure : list) {
                Insertable insertable2;
                if (!aVBaseMeasure.isDerived()) {
                    insertable2 = new Insertable();
                    category.addInsertable(insertable2);
                    insertable2.setName(aVBaseMeasure.getName());
                    insertable2.setIcon("HCSMEASURE_ICON");
                    continue;
                }
                insertable2 = new Insertable();
                category2.addInsertable(insertable2);
                insertable2.setName(aVBaseMeasure.getName());
                category2.setIcon("HCSCALCMEASURE_ICON");
                Category category3 = new Category();
                insertable2.addCategory(category3);
                category3.setName(HCSArb.getString("EXPRESSION_EDITOR_EXPRESSION"));
                Insertable insertable3 = new Insertable();
                category3.addInsertable(insertable3);
                insertable3.setText(aVBaseMeasure.getExpression());
            }
        }
        spec.toXml(stringBuilder);
        return stringBuilder.toString();
    }

    public static HCSSchema populateSchema(HCSSchema hCSSchema, Properties properties, AnalyticView analyticView, Database database) {
        if (hCSSchema == null) {
            hCSSchema = new HCSSchema(properties.getProperty("SCHEMA"));
        }
        HCSMetadataReader hCSMetadataReader = new HCSMetadataReader(database, hCSSchema);
        boolean bl = Boolean.parseBoolean(properties.getProperty("SKIP_CUBE_VIEW_COLUMNS", Boolean.FALSE.toString()));
        hCSMetadataReader.setSkipAVViewColumns(bl);
        try {
            hCSMetadataReader.loadMetadata();
            if (analyticView != null) {
                SyntaxBuilderLauncher.updateSchemaWithAV(hCSSchema, properties, analyticView);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(SyntaxBuilderLauncher.class.getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        return hCSSchema;
    }

    public static HCSSchema populateAV(HCSSchema hCSSchema, Properties properties, AnalyticView analyticView, Object object) {
        if (hCSSchema == null) {
            hCSSchema = new HCSSchema(properties.getProperty("SCHEMA"));
        }
        try {
            SyntaxBuilderLauncher.updateSchemaWithAV(hCSSchema, properties, analyticView);
        }
        catch (Exception exception) {
            Logger.getLogger(SyntaxBuilderLauncher.class.getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        return hCSSchema;
    }

    public static HCSSchema updateSchemaWithAV(HCSSchema hCSSchema, Properties properties, AnalyticView analyticView) {
        block8: {
            try {
                if (analyticView != null) {
                    int n;
                    AnalyticView analyticView2 = new AnalyticView(hCSSchema, analyticView.getName());
                    for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
                        AttributeDimension attributeDimension = hCSSchema.findDimension(aVDimensionality.getName());
                        if (attributeDimension == null) continue;
                        analyticView2.addDimensionality(aVDimensionality);
                        if (!attributeDimension.isTime()) continue;
                        properties.setProperty("IS_TIME_CUBE", "true");
                    }
                    for (n = 0; n < analyticView.getMeasures().length; ++n) {
                        AVMeasure aVMeasure = analyticView.getMeasures()[n];
                        analyticView2.addMeasure(aVMeasure);
                    }
                    for (n = 0; n < analyticView.getCalculatedMeasures().length; ++n) {
                        AVCalculatedMeasure aVCalculatedMeasure = analyticView.getCalculatedMeasures()[n];
                        analyticView2.addCalculatedMeasure(aVCalculatedMeasure);
                    }
                    analyticView2.setDefaultMeasure(analyticView.getDefaultMeasure());
                    AnalyticView analyticView3 = hCSSchema.findAV(analyticView2.getName());
                    if (analyticView3 != null) {
                        hCSSchema.getAnalyticViews().remove(analyticView3);
                    }
                    hCSSchema.addAV(analyticView2);
                    break block8;
                }
                String string = properties.getProperty("CUBE");
                if (string == null) break block8;
                for (AVDimensionality aVDimensionality : ((AnalyticView)hCSSchema.getNamedObject(string)).getDimensions()) {
                    AttributeDimension attributeDimension = aVDimensionality.getDimension();
                    if (!attributeDimension.isTime()) continue;
                    properties.setProperty("IS_TIME_CUBE", "true");
                    break;
                }
            }
            catch (Exception exception) {
                Logger.getLogger(SyntaxBuilderLauncher.class.getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return hCSSchema;
    }

    public static SyntaxBuilderPanel createPanelForAV(Properties properties, AnalyticView analyticView, Connection connection) throws SQLException, IOException {
        return SyntaxBuilderLauncher.createPanelForAV(properties, analyticView, connection, null);
    }

    public static SyntaxBuilderPanel createPanelForAV(Properties properties, AnalyticView analyticView, Connection connection, Reader reader) throws SQLException, IOException {
        return SyntaxBuilderLauncher.createPanelForAV(properties, analyticView, connection, null, null, null, null, null, reader);
    }

    public static SyntaxBuilderPanel createPanelForAV(Properties properties, AnalyticView analyticView, Connection connection, Database database, HCSSchema hCSSchema, SyntaxParser syntaxParser, TemplateHelperFactory templateHelperFactory, Spec spec, Reader reader) throws SQLException, IOException {
        return SyntaxBuilderLauncher.createPanelForAV(properties, analyticView, connection, database, hCSSchema, syntaxParser, templateHelperFactory, spec, reader, null);
    }

    public static SyntaxBuilderPanel createPanelForAV(Properties properties, AnalyticView analyticView, Connection connection, Database database, HCSSchema hCSSchema, SyntaxParser syntaxParser, TemplateHelperFactory templateHelperFactory, Spec spec, Reader reader, InsertionHandlerHelper insertionHandlerHelper) throws SQLException, IOException {
        HCSErrorDisplay hCSErrorDisplay = new HCSErrorDisplay();
        NonLazyFetchIcon nonLazyFetchIcon = new NonLazyFetchIcon();
        HCSResources hCSResources = new HCSResources("/oracle/hcs/av/calcs/calcfactory/calcs.xml");
        String string = null;
        String string2 = null;
        if (database == null && connection != null) {
            database = new DatabaseImpl();
            database.setConnection(connection);
            string2 = Connections.getInstance().getConnectionName(database.getConnection());
        }
        if (hCSSchema == null && database != null) {
            hCSSchema = SyntaxBuilderLauncher.populateSchema(null, properties, analyticView, database);
            string = hCSSchema.getName();
        }
        if (analyticView != null) {
            properties.setProperty(DIMENSIONS, SyntaxBuilderLauncher.generateDimensionsXmlProperty(analyticView));
            properties.setProperty(ANALYTIC_VIEWS, SyntaxBuilderLauncher.generateAVXmlProperty(hCSSchema));
        }
        if (syntaxParser == null) {
            syntaxParser = spec.getSyntaxParser() != null ? spec.getSyntaxParser() : new HCSSyntaxParser(hCSSchema, properties);
        }
        if (templateHelperFactory == null) {
            templateHelperFactory = new TemplateHelperFactoryImpl(properties, hCSSchema, syntaxParser, hCSResources, nonLazyFetchIcon);
        }
        if (spec == null) {
            try {
                if (reader == null) {
                    reader = new InputStreamReader(SyntaxBuilderPanel.class.getResourceAsStream("/oracle/hcs/measureexpression/HCSExpressionSpec.xml"), "UTF-8");
                }
                hCSResources.addXLIFFTranslationResource("HCSExpressionSpec.xml", "/oracle/hcs/measureexpression/HCSExpressionSpec.xml");
                spec = new HCSSpec(properties, reader, "HCSExpressionSpec.xml", syntaxParser, templateHelperFactory, hCSErrorDisplay, hCSResources, nonLazyFetchIcon, connection);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                hCSErrorDisplay.show(unsupportedEncodingException, HCSArb.getString("EXPRESSION_EDITOR_SPEC_ERROR_TITLE"), HCSArb.getString("EXPRESSIONBUILDER_SPEC_ERROR_MESSAGE"), (Component)Ide.getMainWindow());
                return null;
            }
        }
        SyntaxBuilderPanel syntaxBuilderPanel = new SyntaxBuilderPanel(properties, spec, syntaxParser, nonLazyFetchIcon, hCSErrorDisplay, insertionHandlerHelper);
        return syntaxBuilderPanel;
    }

    public static String spawnDialog(final SyntaxBuilderPanel syntaxBuilderPanel) {
        Dimension dimension = new Dimension(900, 500);
        syntaxBuilderPanel.setPreferredSize(dimension);
        syntaxBuilderPanel.setMinimumSize(dimension);
        HelpSystem.getHelpSystem().registerTopic((JComponent)syntaxBuilderPanel, "av_expression_editor");
        final JEWTDialog jEWTDialog = UIUtils.createPanelDialog((JPanel)syntaxBuilderPanel, (String)HCSArb.getString("EXPRESSION_EDITOR.TITLE"), null, (int)6);
        jEWTDialog.addCustomButton((Component)new JButton(new AbstractAction(HCSArb.getString("EXPRESSION_EDITOR.OK")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (syntaxBuilderPanel.isSyntaxValid()) {
                        jEWTDialog.closeDialog(false);
                    } else {
                        JOptionPane.showMessageDialog(syntaxBuilderPanel, syntaxBuilderPanel.getInvalidSyntaxMessage(), HCSArb.getString("EXPRESSION_EDITOR.RESULT.INVALID"), 0);
                    }
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
                }
            }
        }));
        jEWTDialog.setMinimumSize(dimension);
        boolean bl = jEWTDialog.runDialog();
        if (bl) {
            return syntaxBuilderPanel.getSyntax();
        }
        return null;
    }
}

