/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.hcs.syntaxbuilder.SyntaxBuilderPanel;
import oracle.hcs.syntaxbuilder.editor.SQLFormatter;
import oracle.hcs.syntaxbuilder.editor.SnippetCodeEditor;
import oracle.hcs.syntaxbuilder.editor.SnippetValidator;
import oracle.hcs.syntaxbuilder.specification.Spec;
import oracle.hcs.syntaxbuilder.specification.SpecTreeNode;
import oracle.hcs.syntaxbuilder.spectree.SpecJTree;
import oracle.hcs.util.ErrorDisplay;
import oracle.hcs.util.FetchIcon;

public class SnippetBuilderPanel
extends SyntaxBuilderPanel {
    private static final String DEFAULT_SNIPPET = "All Languages";
    DataFlavor nodeFlavor = DataFlavor.stringFlavor;
    private static final Logger LOG = Logger.getLogger(SnippetBuilderPanel.class.getName());

    public SnippetBuilderPanel(Spec spec, ErrorDisplay errorDisplay, String string) {
        super(spec, errorDisplay);
        SpecJTree specJTree = this.getSpecJTree();
        specJTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    SnippetBuilderPanel.this.setSyntaxToEditorFromSelectedNode((SpecJTree)mouseEvent.getSource());
                }
            }
        });
        specJTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 && !keyEvent.isConsumed()) {
                    SnippetBuilderPanel.this.setSyntaxToEditorFromSelectedNode((SpecJTree)keyEvent.getSource());
                    keyEvent.consume();
                }
            }
        });
        specJTree.setDragEnabled(true);
        SnippetCodeEditor snippetCodeEditor = (SnippetCodeEditor)this.getEditor();
        snippetCodeEditor.setSpecJTree(specJTree);
        if (string == null || string.isEmpty()) {
            this.loadDefaultSnippet(specJTree, spec.getRootNode());
        } else {
            this.setText(string);
        }
        specJTree.expandRow(0);
        this.setLayout(new GridBagLayout());
        JSplitPane jSplitPane = new JSplitPane(1, new JScrollPane(specJTree), this.getEditor());
        jSplitPane.setDividerSize(8);
        jSplitPane.setDividerLocation(250);
        this.add((Component)jSplitPane, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 0, 0, 5), 0, 0));
    }

    private void setSyntaxToEditorFromSelectedNode(SpecJTree specJTree) {
        SpecTreeNode specTreeNode = (SpecTreeNode)specJTree.getSelectionModel().getSelectionPath().getLastPathComponent();
        if (specTreeNode.getChildCount() == 0) {
            if (specTreeNode.getTemplateHelper() != null) {
                try {
                    String string = specTreeNode.getTemplateHelper().getGUI(true).getSyntax();
                    this.setText(string);
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, exception.getMessage(), exception);
                }
            } else {
                this.setText(specTreeNode.getTemplate());
            }
        }
    }

    @Override
    protected void initEditor(FetchIcon fetchIcon) {
        this.setSyntaxCodeEditor(new SnippetCodeEditor(fetchIcon, new SQLFormatter()));
    }

    @Override
    public void setText(String string) {
        SnippetCodeEditor snippetCodeEditor = (SnippetCodeEditor)this.getEditor();
        snippetCodeEditor.setText(string);
    }

    public void clearEditorText() {
        SnippetCodeEditor snippetCodeEditor = (SnippetCodeEditor)this.getEditor();
        snippetCodeEditor.clearEditorText();
    }

    @Override
    public String getSyntax() {
        SnippetCodeEditor snippetCodeEditor = (SnippetCodeEditor)this.getEditor();
        return snippetCodeEditor.getText();
    }

    @Override
    public String getInvalidSyntaxMessage() {
        SnippetCodeEditor snippetCodeEditor = (SnippetCodeEditor)this.getEditor();
        SnippetValidator snippetValidator = snippetCodeEditor.getSnippetValidator();
        if (snippetValidator != null) {
            return snippetValidator.getInvalidSyntaxMessage();
        }
        return super.getInvalidSyntaxMessage();
    }

    public void setSnippetValidator(SnippetValidator snippetValidator) {
        SnippetCodeEditor snippetCodeEditor = (SnippetCodeEditor)this.getEditor();
        snippetCodeEditor.setSnippetValidator(snippetValidator);
    }

    public void setEditorUsage(String string) {
        SnippetCodeEditor snippetCodeEditor = (SnippetCodeEditor)this.getEditor();
        snippetCodeEditor.setEditorUsageText(string);
    }

    private void loadDefaultSnippet(SpecJTree specJTree, SpecTreeNode specTreeNode) {
        Enumeration<TreeNode> enumeration = specTreeNode.breadthFirstEnumeration();
        SpecTreeNode specTreeNode2 = null;
        while (enumeration.hasMoreElements()) {
            SpecTreeNode specTreeNode3 = (SpecTreeNode)enumeration.nextElement();
            if (specTreeNode3.getChildCount() != 0 || specTreeNode3.getUserObject() == null || !String.valueOf(specTreeNode3.getUserObject()).equalsIgnoreCase(DEFAULT_SNIPPET)) continue;
            specTreeNode2 = specTreeNode3;
        }
        if (specTreeNode2 != null) {
            specJTree.expandPath(new TreePath(specTreeNode2));
            this.setText(specTreeNode2.getTemplate());
        }
    }
}

