/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntaxbuilder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.model.NamedObject;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntax.AggregateOverClause;
import oracle.hcs.syntax.AggregateOverMembersClause;
import oracle.hcs.syntax.AggregationCase;
import oracle.hcs.syntax.AggregationCommand;
import oracle.hcs.syntax.AggregationFunctionExpression;
import oracle.hcs.syntax.BinaryOperatorCondition;
import oracle.hcs.syntax.BinaryOperatorExpression;
import oracle.hcs.syntax.CaseExpression;
import oracle.hcs.syntax.ColumnExpression;
import oracle.hcs.syntax.Condition;
import oracle.hcs.syntax.ConsistentSolveCommand;
import oracle.hcs.syntax.ConsistentSolveSpecification;
import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.DimensionArgument;
import oracle.hcs.syntax.FunctionArgument;
import oracle.hcs.syntax.HierarchyQualifier;
import oracle.hcs.syntax.HierarchyQualifierArgument;
import oracle.hcs.syntax.IsCondition;
import oracle.hcs.syntax.KeywordArgument;
import oracle.hcs.syntax.ListComparisonCondition;
import oracle.hcs.syntax.LiteralExpression;
import oracle.hcs.syntax.NullExpression;
import oracle.hcs.syntax.NumberExpression;
import oracle.hcs.syntax.OLAPFunctionExpression;
import oracle.hcs.syntax.QDRExpression;
import oracle.hcs.syntax.Qualifier;
import oracle.hcs.syntax.QualifyExpression;
import oracle.hcs.syntax.RowFunctionExpression;
import oracle.hcs.syntax.SQLDataType;
import oracle.hcs.syntax.SearchedCase;
import oracle.hcs.syntax.SearchedCaseExpression;
import oracle.hcs.syntax.SimpleCase;
import oracle.hcs.syntax.SimpleCaseExpression;
import oracle.hcs.syntax.SolveStepCommand;
import oracle.hcs.syntax.StringExpression;
import oracle.hcs.syntax.SymmetricCondition;
import oracle.hcs.syntax.SymmetricConditionElement;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValueComparisonCondition;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseException;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.syntaxparser.SyntaxTokenListener;
import oracle.hcs.util.NameProvider;
import oracle.javatools.db.AbstractDBObject;

public class HCSSyntaxVisitor
extends SyntaxObjectVisitor
implements SyntaxTokenListener {
    private static final Logger LOG = Logger.getLogger(HCSSyntaxVisitor.class.getName());
    private static final String RESERVED_WORD_ELSE = "ELSE";
    private static final String RESERVED_WORD_WHEN = "WHEN";
    private static final String RESERVED_WORD_THEN = "THEN";
    private static final String RESERVED_WORD_CASE = "CASE";
    private static final String RESERVED_WORD_NULL = "NULL";
    private static final String RESERVED_WORD_LEVELS = "LEVELS";
    private static final String RESERVED_WORD_WHERE = "WHERE";
    private static final String RESERVED_WORD_NOT = "NOT";
    private static final String RESERVED_WORD_NOT_IN = "NOT IN";
    private static final String RESERVED_WORD_IN = "IN";
    private static final String RESERVED_WORD_IS = "IS";
    private static final String RESERVED_WORD_IS_NOT = "IS NOT";
    private static final String RESERVED_WORD_ALL = "ALL";
    private static final String RESERVED_WORD_DIVISION = "DIVISION";
    private static final String RESERVED_WORD_NULLS = "NULLS";
    private static final String RESERVED_WORD_ALLOW = "ALLOW";
    private static final String RESERVED_WORD_DISALLOW = "DISALLOW";
    private static final String RESERVED_WORD_BY = "BY";
    private static final String RESERVED_WORD_ZERO = "ZERO";
    private static final String RESERVED_WORD_CONSIDER = "CONSIDER";
    private static final String RESERVED_WORD_IGNORE = "IGNORE";
    private static final String RESERVED_WORD_OVERFLOW = "OVERFLOW";
    private static final String RESERVED_WORD_NO = "NO";
    private static final String RESERVED_WORD_OVER = "OVER";
    private static final String RESERVED_WORD_COUNT = "COUNT";
    private static final String RESERVED_WORD_MAINTAIN = "MAINTAIN";
    private static final String RESERVED_WORD_AGGREGATE = "AGGREGATE";
    private static final String RESERVED_WORD_HIERARCHIES = "HIERARCHIES";
    private static final String FUNCTION_NAME_AVG = "AVG";
    private static final String FUNCTION_NAME_MIN = "MIN";
    private static final String FUNCTION_NAME_MAX = "MAX";
    private static final String FUNCTION_NAME_SUM = "SUM";
    private static final String FUNCTION_NAME_RANK = "RANK";
    private static final String FUNCTION_NAME_DENSE_RANK = "DENSE_RANK";
    private static final String FUNCTION_NAME_AVERAGE_RANK = "AVERAGE_RANK";
    private String syntax;
    private int offset;
    private final HashSet reserved = new HashSet();
    private HCSSchema schema;
    private List<Throwable> badNames = new LinkedList<Throwable>();
    private Set<AVHierarchy> avHierarchiesFound;
    private List<Token> tokenList = new ArrayList<Token>();
    private Properties props;

    public HCSSyntaxVisitor(HCSSchema hCSSchema, Properties properties) {
        this.schema = hCSSchema;
        this.props = properties;
        this.init();
    }

    private void init() {
        this.offset = 0;
        this.badNames.clear();
        this.avHierarchiesFound = new HashSet<AVHierarchy>();
        this.tokenList = new LinkedList<Token>();
    }

    private int findOffset(List<Token> list, int n) {
        int n2 = Collections.binarySearch(list, new Token(null, n, null));
        return n2;
    }

    private ParseNode fixBounds(ParseNode parseNode, int n, int n2) {
        parseNode.setReplaceBounds(n, n2, this.syntax);
        this.extendOnParenthesis(parseNode);
        return parseNode;
    }

    public String getAV() {
        String string = this.props.getProperty("CUBE");
        return string;
    }

    public void setSyntax(String string) {
        this.init();
        this.syntax = string;
    }

    public List<Throwable> getBadNames() {
        return this.badNames;
    }

    public Set<AVHierarchy> getAVHierarchiesInExpression() {
        return this.avHierarchiesFound;
    }

    public void setSchema(HCSSchema hCSSchema) {
        this.schema = hCSSchema;
    }

    public HCSSchema getSchema() {
        return this.schema;
    }

    public void addReservedWord(String string) {
        this.reserved.add(string);
    }

    HCSSyntaxType calculateType(String string) {
        if (string.equalsIgnoreCase(HCSSyntaxType.MEASURE.toString())) {
            return HCSSyntaxType.MEASURE;
        }
        if (string.equalsIgnoreCase("dimension.hierarchy")) {
            return HCSSyntaxType.HIERARCHY;
        }
        if (string.equalsIgnoreCase("dimension.level")) {
            return HCSSyntaxType.LEVEL;
        }
        if (this.schema != null) {
            IdentifierElement identifierElement = new IdentifierElement(string);
            string = string.replaceAll("\"", "");
            boolean bl = false;
            int n = string.indexOf(46);
            String string2 = string;
            if (identifierElement.getCount() > 0 && identifierElement.get(0).equalsIgnoreCase(this.schema.getName())) {
                string2 = string.substring(n + 1);
                bl = true;
            }
            NamedObject namedObject = this.schema.findAV(string2);
            String string3 = this.getAV();
            AnalyticView analyticView = this.schema.findAV(string3);
            if (namedObject == null) {
                String string4;
                Object object;
                int n2 = 0;
                if (identifierElement.getCount() == 3 && bl) {
                    n2 = 1;
                }
                String string5 = identifierElement.get(n2);
                AVDimensionality aVDimensionality = null;
                if (analyticView != null) {
                    aVDimensionality = analyticView.findDimensionalityForAlias(string5);
                }
                if (aVDimensionality != null && (object = aVDimensionality.getDimension()) != null && identifierElement.getCount() > n2 + 1 && (namedObject = aVDimensionality.findHierarchyByAlias(string4 = identifierElement.get(n2 + 1))) == null) {
                    namedObject = ((AttributeDimension)object).findAttribute(string4);
                }
                if (analyticView != null && namedObject == null) {
                    namedObject = this.findHierarchyObject(analyticView, string);
                    if (namedObject == null) {
                        if (n > 0) {
                            object = identifierElement.get(n2 + 1);
                            namedObject = analyticView.findBaseMeasure((String)object);
                        } else {
                            namedObject = analyticView.findBaseMeasure(string);
                        }
                    }
                    if (namedObject == null) {
                        namedObject = this.findLevelObject(analyticView, string);
                    }
                }
                if (namedObject == null && string.equalsIgnoreCase(RESERVED_WORD_ALL)) {
                    return HCSSyntaxType.LEVEL;
                }
            }
            if (namedObject != null) {
                if (namedObject instanceof AVBaseMeasure) {
                    return HCSSyntaxType.MEASURE;
                }
                if (namedObject instanceof AttributeDimension) {
                    return HCSSyntaxType.DIMENSION;
                }
                if (namedObject instanceof DimensionLevel) {
                    return HCSSyntaxType.LEVEL;
                }
                if (namedObject instanceof Hierarchy) {
                    return HCSSyntaxType.HIERARCHY;
                }
                if (namedObject instanceof AVHierarchy) {
                    AVHierarchy aVHierarchy = (AVHierarchy)namedObject;
                    this.addAVHierarchy(aVHierarchy);
                    return HCSSyntaxType.HIERARCHY;
                }
                if (namedObject instanceof DimensionAttribute) {
                    return HCSSyntaxType.ATTRIBUTE;
                }
                if (namedObject instanceof AnalyticView) {
                    return HCSSyntaxType.ANALYTIC_VIEW;
                }
            }
        }
        if (this.reserved.contains(string)) {
            return HCSSyntaxType.RESERVED;
        }
        return HCSSyntaxType.BAD_NAME;
    }

    private void addAVHierarchy(AVHierarchy aVHierarchy) {
        if (this.avHierarchiesFound == null) {
            this.avHierarchiesFound = new HashSet<AVHierarchy>();
        }
        this.avHierarchiesFound.add(aVHierarchy);
    }

    private AbstractDBObject findHierarchyObject(AnalyticView analyticView, String string) {
        for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
            AVHierarchy aVHierarchy = aVDimensionality.findHierarchyByAlias(string);
            if (aVHierarchy == null) continue;
            return aVHierarchy;
        }
        return null;
    }

    private AbstractDBObject findLevelObject(AnalyticView analyticView, String string) {
        for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
            DimensionLevel dimensionLevel;
            AttributeDimension attributeDimension = aVDimensionality.getDimension();
            if (attributeDimension == null || (dimensionLevel = attributeDimension.findLevel(string)) == null) continue;
            return dimensionLevel;
        }
        return null;
    }

    protected ParseNode processLiteral(String string, Object object) {
        HCSSyntaxType hCSSyntaxType = this.calculateType(string);
        return this.processLiteral(string, hCSSyntaxType, object, false);
    }

    protected ParseNode processLiteral(String string, HCSSyntaxType hCSSyntaxType, Object object) {
        return this.processLiteral(string, hCSSyntaxType, object, false);
    }

    protected ParseNode processLiteral(String string, HCSSyntaxType hCSSyntaxType, Object object, boolean bl) {
        return this.processLiteral(string, hCSSyntaxType, object, bl, true, 0);
    }

    protected ParseNode processLiteral(String string, HCSSyntaxType hCSSyntaxType, Object object, boolean bl, boolean bl2, int n) {
        int n2 = 0;
        Token token = this.insensitiveIndexOf(this.syntax, string, this.offset, 1, n);
        if (token == null) {
            n2 = -1;
        } else {
            n2 = token.offset;
            string = token.token;
        }
        if (n2 == -1) {
            if (bl2) {
                LOG.finest(String.format("Creating BAD ParseNode for %s of type %s on offset %d", string, hCSSyntaxType.toString(), this.offset));
            }
        } else {
            this.offset = n2 + string.length();
        }
        ParseNode parseNode = new ParseNode(string, hCSSyntaxType.toString(), bl, n2, this.offset);
        if (hCSSyntaxType == HCSSyntaxType.BAD_NAME) {
            this.badNames.add(new ParseException(HCSArb.format("EXPRESSION_EDITOR_RESULT_INVALID_NAME", string), parseNode.getOffset(), string));
        }
        if (object != null) {
            ((ParseNode)object).add(parseNode);
        }
        return parseNode;
    }

    private int insensitiveIndexOf(String string, String string2, int n) {
        return this.insensitiveIndexOf(string, string2, n, 1);
    }

    private int insensitiveIndexOf(String string, String string2, int n, int n2) {
        Token token = this.insensitiveIndexOf(string, string2, n, n2, 0);
        if (token != null) {
            return token.offset;
        }
        return -1;
    }

    private Token insensitiveIndexOf(String string, String string2, int n, int n2, int n3) {
        try {
            if (n >= string.length()) {
                return null;
            }
            Token token = null;
            int n4 = this.findOffset(this.tokenList, n);
            n4 = n4 < 0 ? (n4 + 1) * -1 : n4;
            List<Token> list = this.tokenList;
            token = list.get(n4);
            while (n3 == 0 || n2 == 1 && token.offset < n3 || n2 == -1 && token.offset > n3) {
                if (HCSSyntaxVisitor.tokensMatch(string2, token.token)) {
                    return token;
                }
                if ((n4 += n2) < list.size() && n4 > 0) {
                    token = list.get(n4);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, String.format("Issue finding token %s starting at index %d in direction %d", string2, n, n2));
        }
        return null;
    }

    public static boolean tokensMatch(String string, String string2) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        while (n < string.length() && n2 < string2.length()) {
            char c = Character.toUpperCase(string.charAt(n));
            if (HCSSyntaxVisitor.shouldSkip(c)) {
                ++n;
                continue;
            }
            char c2 = Character.toUpperCase(string2.charAt(n2));
            if (HCSSyntaxVisitor.shouldSkip(c2)) {
                ++n2;
                continue;
            }
            if (c != c2) {
                bl = false;
                break;
            }
            ++n2;
            ++n;
        }
        while (bl && n < string.length()) {
            bl = HCSSyntaxVisitor.shouldSkip(string.charAt(n++));
        }
        while (bl && n2 < string2.length()) {
            bl = HCSSyntaxVisitor.shouldSkip(string2.charAt(n2++));
        }
        return bl;
    }

    private static boolean shouldSkip(char c) {
        return c == '\'' || c == '\"';
    }

    private ParseNode extendOnParenthesis(ParseNode parseNode) {
        return this.extendOnGroupingChars(parseNode);
    }

    private ParseNode extendOnGroupingChars(ParseNode parseNode) {
        String string;
        String string2;
        int n;
        int n2;
        int n3;
        String[] stringArray = new String[]{"(", ")", "[", "]"};
        int[] nArray = new int[]{0, 0, 0, 0};
        HCSSyntaxType hCSSyntaxType = HCSSyntaxType.valueFrom(parseNode.getType());
        int n4 = parseNode.getReplaceOffset();
        int n5 = parseNode.getReplaceEnd();
        if (n4 == -1 && n5 == -1) {
            return parseNode;
        }
        List<Token> list = this.tokenList;
        int n6 = this.findOffset(list, n4);
        n6 = n6 < 0 ? n6 * -1 : n6;
        Token token = list.get(n6);
        int n7 = n6;
        while (token.offset >= n4 && token.offset < parseNode.getReplaceEnd()) {
            for (n3 = 0; n3 < nArray.length; n3 += 2) {
                String string3 = stringArray[n3];
                String string4 = stringArray[n3 + 1];
                if (token.token.equals(string3)) {
                    int n8 = n3;
                    nArray[n8] = nArray[n8] + 1;
                    continue;
                }
                if (!token.token.equals(string4)) continue;
                if (nArray[n3] > 0) {
                    int n9 = n3;
                    nArray[n9] = nArray[n9] - 1;
                    continue;
                }
                int n10 = n3 + 1;
                nArray[n10] = nArray[n10] + 1;
            }
            if (++n6 >= list.size()) break;
            token = list.get(n6);
        }
        n3 = 0;
        boolean bl = false;
        for (n2 = 0; n2 < nArray.length; n2 += 2) {
            if (n3 == 0) {
                int n11 = n3 = nArray[n2] > 0 ? 1 : 0;
            }
            if (bl) continue;
            bl = nArray[n2 + 1] > 0;
        }
        for (n6 = n2 = n6; n3 != 0 && n6 < list.size() && n6 >= 0; ++n6) {
            token = list.get(n6);
            n3 = 0;
            for (n = 0; n < nArray.length; n += 2) {
                string2 = stringArray[n + 1];
                string = stringArray[n];
                if (token.token.equals(string2)) {
                    int n12 = n;
                    nArray[n12] = nArray[n12] - 1;
                    n5 = token.offset + 1;
                } else if (token.token.equals(string)) {
                    int n13 = n;
                    nArray[n13] = nArray[n13] + 1;
                }
                if (n3 != 0) continue;
                n3 = nArray[n] > 0 ? 1 : 0;
            }
        }
        for (n6 = n7 - 1; bl && n6 < list.size() && n6 >= 0; --n6) {
            token = list.get(n6);
            bl = false;
            for (n = 0; n < nArray.length; n += 2) {
                string2 = stringArray[n];
                string = stringArray[n + 1];
                if (token.token.equals(string2)) {
                    int n14 = n + 1;
                    nArray[n14] = nArray[n14] - 1;
                    n4 = token.offset;
                } else if (token.token.equals(string)) {
                    int n15 = n;
                    nArray[n15] = nArray[n15] + 1;
                }
                if (bl) continue;
                bl = nArray[n + 1] > 0;
            }
        }
        parseNode.setReplaceBounds(n4, n5, this.syntax);
        return parseNode;
    }

    private void loopArgs(FunctionArgument[] functionArgumentArray, Object object) {
        for (int i = 0; i < functionArgumentArray.length; ++i) {
            ((SyntaxObject)((Object)functionArgumentArray[i])).visit(this, object);
        }
    }

    @Override
    public Object visitSyntaxObject(SyntaxObject syntaxObject, Object object) {
        if (object != null) {
            String string = syntaxObject.toSyntax();
            return this.processLiteral(string, object);
        }
        return null;
    }

    @Override
    public Object visitBinaryOperatorCondition(BinaryOperatorCondition binaryOperatorCondition, Object object) {
        ParseNode parseNode = new ParseNode(binaryOperatorCondition.getOperator(), HCSSyntaxType.OPERATOR.toString());
        Condition[] conditionArray = binaryOperatorCondition.getArguments();
        conditionArray[0].visit(this, parseNode);
        ParseNode parseNode2 = this.processLiteral(binaryOperatorCondition.getOperator(), HCSSyntaxType.OPERATOR, object, true);
        conditionArray[1].visit(this, parseNode);
        ParseNode parseNode3 = (ParseNode)parseNode.getFirstChild();
        ParseNode parseNode4 = (ParseNode)parseNode.getLastChild();
        parseNode2.add(parseNode3);
        parseNode2.add(parseNode4);
        this.fixBounds(parseNode2, parseNode3.getReplaceOffset(), parseNode4.getReplaceEnd());
        return parseNode2;
    }

    @Override
    public Object visitBinaryOperatorExpression(BinaryOperatorExpression binaryOperatorExpression, Object object) {
        ParseNode parseNode = new ParseNode(binaryOperatorExpression.getOperator(), HCSSyntaxType.OPERATOR.toString());
        TypedExpression[] typedExpressionArray = binaryOperatorExpression.getArguments();
        typedExpressionArray[0].visit(this, parseNode);
        ParseNode parseNode2 = this.processLiteral(binaryOperatorExpression.getOperator(), HCSSyntaxType.OPERATOR, object, true);
        typedExpressionArray[1].visit(this, parseNode);
        ParseNode parseNode3 = (ParseNode)parseNode.getFirstChild();
        ParseNode parseNode4 = (ParseNode)parseNode.getLastChild();
        parseNode2.add(parseNode3);
        parseNode2.add(parseNode4);
        this.fixBounds(parseNode2, parseNode3.getReplaceOffset(), parseNode4.getReplaceEnd());
        return parseNode2;
    }

    @Override
    public Object visitValueComparisonCondition(ValueComparisonCondition valueComparisonCondition, Object object) {
        ParseNode parseNode = new ParseNode(valueComparisonCondition.getOperator(), HCSSyntaxType.OPERATOR.toString());
        valueComparisonCondition.getLhsArgument().visit(this, parseNode);
        ParseNode parseNode2 = this.processLiteral(valueComparisonCondition.getOperator(), HCSSyntaxType.OPERATOR, object, true);
        valueComparisonCondition.getRhsArgument().visit(this, parseNode);
        ParseNode parseNode3 = (ParseNode)parseNode.getFirstChild();
        ParseNode parseNode4 = (ParseNode)parseNode.getLastChild();
        parseNode2.add(parseNode3);
        parseNode2.add(parseNode4);
        this.fixBounds(parseNode2, parseNode3.getReplaceOffset(), parseNode4.getReplaceEnd());
        return parseNode2;
    }

    @Override
    public Object visitRowFunctionExpression(RowFunctionExpression rowFunctionExpression, Object object) {
        ParseNode parseNode = new ParseNode(rowFunctionExpression.getFunctionName(), HCSSyntaxType.FUNCTION.toString());
        ((ParseNode)object).add(parseNode);
        this.loopArgs(rowFunctionExpression.getArguments(), parseNode);
        if (parseNode.getChildren().size() > 0) {
            ParseNode parseNode2 = (ParseNode)parseNode.getFirstChild();
            parseNode.setOffset(parseNode2.getOffset());
            ParseNode parseNode3 = (ParseNode)parseNode.getLastChild();
            return this.fixBounds(parseNode, parseNode.getOffset(), parseNode3.getReplaceEnd());
        }
        return this.fixBounds(parseNode, parseNode.getOffset(), parseNode.getReplaceEnd());
    }

    @Override
    public Object visitOLAPFunctionExpression(OLAPFunctionExpression oLAPFunctionExpression, Object object) {
        HCSSyntaxType hCSSyntaxType = HCSSyntaxType.FUNCTION;
        ParseNode parseNode = this.processLiteral(oLAPFunctionExpression.getFunctionName(), hCSSyntaxType, object, true);
        this.loopArgs(oLAPFunctionExpression.getArguments(), parseNode);
        if (oLAPFunctionExpression.hasHierarchyClause()) {
            this.loopArgs(oLAPFunctionExpression.getHierarchyClauseArguments(), parseNode);
        }
        ParseNode parseNode2 = (ParseNode)parseNode.getLastChild();
        this.fixBounds(parseNode, parseNode.getOffset(), parseNode2.getReplaceEnd());
        return parseNode;
    }

    @Override
    public Object visitKeywordArgument(KeywordArgument keywordArgument, Object object) {
        return this.processLiteral(keywordArgument.getName(), HCSSyntaxType.KEYWORD, object, true);
    }

    @Override
    public Object visitDimensionArgument(DimensionArgument dimensionArgument, Object object) {
        NameProvider nameProvider = NameProvider.getInstance();
        String string = dimensionArgument.getDimensionID();
        string = nameProvider.getExternalName(string);
        return this.processLiteral(string, this.calculateType(string), object);
    }

    @Override
    public Object visitQualifyExpression(QualifyExpression qualifyExpression, Object object) {
        ParseNode parseNode = (ParseNode)object;
        HCSSyntaxType hCSSyntaxType = HCSSyntaxType.FUNCTION;
        ParseNode parseNode2 = this.processLiteral("QUALIFY", hCSSyntaxType, object, true);
        parseNode.add(parseNode2);
        TypedExpression typedExpression = qualifyExpression.getBaseExpression();
        typedExpression.visit(this, parseNode2);
        for (HierarchyQualifier hierarchyQualifier : qualifyExpression.getQualifiers()) {
            hierarchyQualifier.visit(this, parseNode2);
        }
        ParseNode parseNode3 = (ParseNode)parseNode2.getLastChild();
        if (parseNode3.getChildren().size() > 0) {
            ParseNode parseNode4 = (ParseNode)parseNode3.getLastChild();
            parseNode4.addParamName("member_key");
        }
        this.fixBounds(parseNode2, parseNode2.getOffset(), parseNode3.getReplaceEnd());
        return parseNode;
    }

    @Override
    public Object visitHierarchyQualifier(HierarchyQualifier hierarchyQualifier, Object object) {
        List<HierarchyQualifierArgument> list;
        NameProvider nameProvider = NameProvider.getInstance();
        String string = hierarchyQualifier.getHierarchyID();
        string = nameProvider.getExternalName(string);
        ParseNode parseNode = this.processLiteral(string, this.calculateType(string), object);
        parseNode.addParamName("av_hierarchy");
        ParseNode parseNode2 = this.processLiteral("=", HCSSyntaxType.OPERATOR, object, true);
        parseNode.add(parseNode2);
        HierarchyQualifierArgument hierarchyQualifierArgument = hierarchyQualifier.getHierarchyQualifierArgument();
        if (hierarchyQualifierArgument != null) {
            this.visitHierarchyQualifierArgument(hierarchyQualifierArgument, parseNode2);
        }
        if ((list = hierarchyQualifier.getHierarchyQualifierArguments()) != null) {
            for (HierarchyQualifierArgument hierarchyQualifierArgument2 : list) {
                this.visitHierarchyQualifierArgument(hierarchyQualifierArgument2, parseNode2);
            }
        }
        return parseNode2;
    }

    @Override
    public Object visitHierarchyQualifierArgument(HierarchyQualifierArgument hierarchyQualifierArgument, Object object) {
        ParseNode parseNode = (ParseNode)object;
        NameProvider nameProvider = NameProvider.getInstance();
        String string = hierarchyQualifierArgument.getLevelID();
        string = nameProvider.getExternalName(string);
        ParseNode parseNode2 = this.processLiteral(string, this.calculateType(string), object);
        parseNode.add(parseNode2);
        for (LiteralExpression literalExpression : hierarchyQualifierArgument.getLiteralExpressions()) {
            literalExpression.visit(this, parseNode2);
        }
        return parseNode2;
    }

    @Override
    public Object visitQDRExpression(QDRExpression qDRExpression, Object object) {
        ParseNode parseNode = (ParseNode)object;
        ParseNode parseNode2 = new ParseNode("QDR", HCSSyntaxType.QDR.toString());
        parseNode.add(parseNode2);
        qDRExpression.getBaseExpression().visit(this, parseNode2);
        for (Qualifier qualifier : qDRExpression.getQualifiers()) {
            qualifier.visit(this, parseNode2);
        }
        if (parseNode2.getChildCount() > 0) {
            ParseNode parseNode3 = (ParseNode)parseNode2.getFirstChild();
            ParseNode parseNode4 = (ParseNode)parseNode2.getLastChild();
            this.fixBounds(parseNode2, parseNode3.getReplaceOffset(), parseNode4.getReplaceEnd());
            parseNode2.setOffset(parseNode3.getOffset());
            parseNode2.setEnd(parseNode3.getReplaceEnd());
        }
        return parseNode;
    }

    @Override
    public Object visitQualifier(Qualifier qualifier, Object object) {
        String string = qualifier.getDimensionID();
        ParseNode parseNode = this.processLiteral(string, this.calculateType(string), object);
        TypedExpression typedExpression = qualifier.getExpression();
        typedExpression.visit(this, object);
        return parseNode;
    }

    @Override
    public Object visitStringExpression(StringExpression stringExpression, Object object) {
        return this.processLiteral(stringExpression.getValue().toString(), HCSSyntaxType.STRING, object);
    }

    @Override
    public Object visitNumberExpression(NumberExpression numberExpression, Object object) {
        boolean bl = false;
        return this.processLiteral(numberExpression.getValue().toString(), HCSSyntaxType.NUMBER, object, bl);
    }

    @Override
    public Object visitCaseExpression(CaseExpression caseExpression, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_ELSE, HCSSyntaxType.RESERVED, object);
        caseExpression.getElseExpression().visit(this, parseNode);
        return parseNode;
    }

    @Override
    public Object visitSimpleCase(SimpleCase simpleCase, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_WHEN, HCSSyntaxType.RESERVED, object);
        simpleCase.getWhenExpression().visit(this, parseNode);
        ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_THEN, HCSSyntaxType.RESERVED, object);
        simpleCase.getThenExpression().visit(this, parseNode2);
        return parseNode;
    }

    @Override
    public Object visitSimpleCaseExpression(SimpleCaseExpression simpleCaseExpression, Object object) {
        SimpleCase[] simpleCaseArray;
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_CASE, HCSSyntaxType.RESERVED, object);
        simpleCaseExpression.getSwitchExpression().visit(this, parseNode);
        for (SimpleCase simpleCase : simpleCaseArray = simpleCaseExpression.getCases()) {
            simpleCase.visit(this, parseNode);
        }
        super.visitSimpleCaseExpression(simpleCaseExpression, parseNode);
        return parseNode;
    }

    @Override
    public Object visitSearchedCase(SearchedCase searchedCase, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_WHEN, HCSSyntaxType.RESERVED, object);
        searchedCase.getWhenCondition().visit(this, parseNode);
        ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_THEN, HCSSyntaxType.RESERVED, parseNode);
        searchedCase.getThenExpression().visit(this, parseNode2);
        return parseNode;
    }

    @Override
    public Object visitSearchedCaseExpression(SearchedCaseExpression searchedCaseExpression, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_CASE, HCSSyntaxType.RESERVED, object);
        SearchedCase[] searchedCaseArray = searchedCaseExpression.getCases();
        for (int i = 0; i < searchedCaseArray.length; ++i) {
            searchedCaseArray[i].visit(this, parseNode);
        }
        super.visitSearchedCaseExpression(searchedCaseExpression, parseNode);
        return parseNode;
    }

    @Override
    public Object visitColumnExpression(ColumnExpression columnExpression, Object object) {
        return this.processLiteral(columnExpression.toSyntax(), this.calculateType(columnExpression.toSyntax()), object);
    }

    @Override
    public Object visitSymmetricCondition(SymmetricCondition symmetricCondition, Object object) {
        for (SymmetricConditionElement symmetricConditionElement : symmetricCondition.getElements()) {
            symmetricConditionElement.visit(this, object);
        }
        return object;
    }

    @Override
    public Object visitIsCondition(IsCondition isCondition, Object object) {
        ParseNode parseNode;
        ParseNode parseNode2;
        ParseNode parseNode3;
        int n = this.offset;
        if (isCondition.isNegated()) {
            parseNode3 = (ParseNode)object;
            parseNode2 = this.processLiteral(RESERVED_WORD_IS, HCSSyntaxType.OPERATOR, null, true);
            parseNode = this.processLiteral(RESERVED_WORD_NOT, HCSSyntaxType.OPERATOR, null, true);
            parseNode2 = new ParseNode(RESERVED_WORD_IS_NOT, HCSSyntaxType.OPERATOR.toString(), true, parseNode2.getOffset(), parseNode.getEnd());
            parseNode3.add(parseNode2);
        } else {
            parseNode2 = this.processLiteral(RESERVED_WORD_IS, HCSSyntaxType.OPERATOR, object, true);
        }
        this.offset = n;
        isCondition.getBaseExpression().visit(this, parseNode2);
        parseNode3 = this.processLiteral(isCondition.getComparison(), parseNode2);
        parseNode3.setCheckName(true);
        parseNode = (ParseNode)parseNode2.getFirstChild();
        ParseNode parseNode4 = (ParseNode)parseNode2.getLastChild();
        this.fixBounds(parseNode2, parseNode.getReplaceOffset(), parseNode4.getReplaceEnd());
        return parseNode2;
    }

    @Override
    public Object visitSymmetricConditionElement(SymmetricConditionElement symmetricConditionElement, Object object) {
        ParseNode parseNode = this.processLiteral(symmetricConditionElement.getDimensionID(), object);
        if (symmetricConditionElement.getCondition() != null) {
            ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_WHERE, HCSSyntaxType.KEYWORD, parseNode, true);
            symmetricConditionElement.getCondition().visit(this, parseNode2);
            ParseNode parseNode3 = (ParseNode)parseNode2.getLastChild();
            this.fixBounds(parseNode2, parseNode2.getOffset(), parseNode3.getReplaceEnd());
        } else if (symmetricConditionElement.getQualifier() != null) {
            this.processLiteral(symmetricConditionElement.getQualifier(), HCSSyntaxType.KEYWORD, parseNode, true);
        } else {
            ParseNode parseNode4 = this.processLiteral(RESERVED_WORD_LEVELS, HCSSyntaxType.KEYWORD, parseNode, true);
            for (String string : symmetricConditionElement.getLevelIDs()) {
                this.processLiteral(string, HCSSyntaxType.LEVEL, parseNode4);
            }
        }
        return parseNode;
    }

    @Override
    public Object visitListComparisonCondition(ListComparisonCondition listComparisonCondition, Object object) {
        ParseNode parseNode;
        Object object2;
        int n = this.offset;
        ParseNode parseNode2 = (ParseNode)object;
        ParseNode parseNode3 = (ParseNode)listComparisonCondition.getLhsArgument().visit(this, parseNode2);
        if (listComparisonCondition.getOperator().equals("!=")) {
            object2 = this.processLiteral(RESERVED_WORD_NOT, HCSSyntaxType.OPERATOR, null, true);
            parseNode = this.processLiteral(RESERVED_WORD_IN, HCSSyntaxType.OPERATOR, null, true);
            parseNode = new ParseNode(RESERVED_WORD_NOT_IN, HCSSyntaxType.OPERATOR.toString(), true, ((ParseNode)object2).getOffset(), parseNode.getEnd());
            parseNode2.add(parseNode);
        } else {
            parseNode = this.processLiteral(RESERVED_WORD_IN, HCSSyntaxType.OPERATOR, object, true);
        }
        this.offset = n;
        for (TypedExpression typedExpression : listComparisonCondition.getList()) {
            typedExpression.visit(this, parseNode);
        }
        object2 = (ParseNode)parseNode.getFirstChild();
        ParseNode parseNode4 = (ParseNode)parseNode.getLastChild();
        this.fixBounds(parseNode, ((ParseNode)object2).getOffset(), parseNode4.getReplaceEnd());
        return parseNode;
    }

    @Override
    public Object visitNullExpression(NullExpression nullExpression, Object object) {
        return this.processLiteral(RESERVED_WORD_NULL, HCSSyntaxType.RESERVED, object);
    }

    @Override
    public Object visitSQLDataType(SQLDataType sQLDataType, Object object) {
        DataType dataType = sQLDataType.getDataType();
        ParseNode parseNode = this.processLiteral(dataType.getName(), HCSSyntaxType.RESERVED, object);
        return parseNode;
    }

    @Override
    public Object visitConsistentSolveSpecification(ConsistentSolveSpecification consistentSolveSpecification, Object object) {
        ParseNode parseNode = this.processLiteral(RESERVED_WORD_AGGREGATE, HCSSyntaxType.AGGREGATE, object, true);
        ParseNode parseNode2 = this.processLiteral(RESERVED_WORD_BY, HCSSyntaxType.KEYWORD, object, true);
        for (ConsistentSolveCommand consistentSolveCommand : consistentSolveSpecification.getCommands()) {
            if (!(consistentSolveCommand instanceof SyntaxObject)) continue;
            ((SyntaxObject)((Object)consistentSolveCommand)).visit(this, parseNode);
        }
        ParseNode parseNode3 = (ParseNode)parseNode.getLastChild();
        this.fixBounds(parseNode, parseNode.getOffset(), parseNode3.getReplaceEnd());
        return parseNode;
    }

    @Override
    public Object visitAggregationCommand(AggregationCommand aggregationCommand, Object object) {
        ParseNode parseNode;
        int n;
        String string = aggregationCommand.getFunctionName();
        if (string.equals("NO AGGREGATE")) {
            n = this.insensitiveIndexOf(this.syntax, RESERVED_WORD_NO, this.offset);
            int n2 = this.insensitiveIndexOf(this.syntax, RESERVED_WORD_AGGREGATE, this.offset);
            parseNode = new ParseNode(string, HCSSyntaxType.FUNCTION.toString(), true, n, n2);
            ((ParseNode)object).add(parseNode);
        } else {
            parseNode = this.processLiteral(string, HCSSyntaxType.FUNCTION, object, true);
        }
        this.loopArgs(aggregationCommand.getArguments(), parseNode);
        if (parseNode.getChildCount() > 0) {
            ParseNode parseNode2 = (ParseNode)parseNode.getLastChild();
            this.fixBounds(parseNode, parseNode.getOffset(), parseNode2.getReplaceEnd());
        }
        n = this.offset;
        PriorityQueue<ParseNode> priorityQueue = new PriorityQueue<ParseNode>(11, new Comparator<ParseNode>(){

            @Override
            public int compare(ParseNode parseNode, ParseNode parseNode2) {
                if (parseNode.getOffset() < parseNode2.getOffset()) {
                    return -1;
                }
                if (parseNode.getOffset() > parseNode2.getOffset()) {
                    return 1;
                }
                return 0;
            }
        });
        this.offset = n;
        return parseNode;
    }

    private int enqueueCommandAttribute(PriorityQueue<ParseNode> priorityQueue, boolean bl, String[] stringArray, int n, int n2, int n3) {
        int n4 = this.offset = n;
        if (bl) {
            n4 = this.enqueueCommandFragment(priorityQueue, n2, stringArray[1]);
            if (n4 != -1) {
                for (int i = 2; i < stringArray.length; ++i) {
                    n4 = this.enqueueCommandFragment(priorityQueue, n2, stringArray[i]);
                }
            } else {
                n4 = n3;
                for (String string : stringArray) {
                    priorityQueue.add(new ParseNode(string, HCSSyntaxType.RESERVED.toString(), true, ++n4, n4));
                }
            }
        } else {
            for (int i = 1; i < stringArray.length; ++i) {
                n4 = this.enqueueCommandFragment(priorityQueue, n2, stringArray[i]);
            }
        }
        return n4;
    }

    private int enqueueCommandFragment(PriorityQueue<ParseNode> priorityQueue, int n, String string) {
        ParseNode parseNode = this.processLiteral(string, HCSSyntaxType.RESERVED, null, true, false, n);
        if (parseNode.getOffset() != -1 && parseNode.getOffset() < n) {
            priorityQueue.offer(parseNode);
            return parseNode.getEnd();
        }
        return -1;
    }

    @Override
    public Object visitSolveStepCommand(SolveStepCommand solveStepCommand, Object object) {
        return super.visitSolveStepCommand(solveStepCommand, object);
    }

    @Override
    public Object visitAggregateOverClause(AggregateOverClause aggregateOverClause, Object object) {
        return super.visitAggregateOverClause(aggregateOverClause, object);
    }

    @Override
    public Object visitAggregateOverMembersClause(AggregateOverMembersClause aggregateOverMembersClause, Object object) {
        return super.visitAggregateOverMembersClause(aggregateOverMembersClause, object);
    }

    @Override
    public Object visitAggregationCase(AggregationCase aggregationCase, Object object) {
        return super.visitAggregationCase(aggregationCase, object);
    }

    @Override
    public Object visitAggregationFunctionExpression(AggregationFunctionExpression aggregationFunctionExpression, Object object) {
        return super.visitAggregationFunctionExpression(aggregationFunctionExpression, object);
    }

    @Override
    public void processToken(String string, String string2, int n) {
        HCSSyntaxType hCSSyntaxType = HCSSyntaxType.valueFrom(string2);
        if (hCSSyntaxType != HCSSyntaxType.BLOCK_COMMENT && hCSSyntaxType != HCSSyntaxType.LINE_COMMENT && hCSSyntaxType != HCSSyntaxType.NEWLINE && hCSSyntaxType != HCSSyntaxType.WHITESPACE) {
            this.tokenList.add(new Token(string, n, hCSSyntaxType));
        }
    }

    private static class Token
    implements Comparable<Token> {
        final String token;
        final int offset;
        final HCSSyntaxType type;

        Token(String string, int n, HCSSyntaxType hCSSyntaxType) {
            this.token = string;
            this.offset = n;
            this.type = hCSSyntaxType;
        }

        @Override
        public int compareTo(Token token) {
            if (token.offset > this.offset) {
                return -1;
            }
            if (token.offset < this.offset) {
                return 1;
            }
            return 0;
        }
    }
}

