/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.RowExpression;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;

public final class TimeZoneExpression
extends RowExpression {
    private TypedExpression m_DateExpression;
    private TypedExpression m_TimeZoneExpression;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.print(this.getDateExpression());
        syntaxPrintingContext.append(" AT ");
        if (null == this.getTimeZoneExpression()) {
            syntaxPrintingContext.append(" LOCAL");
        } else {
            syntaxPrintingContext.append(" TIME ZONE ");
            syntaxPrintingContext.print(this.getTimeZoneExpression());
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_DateExpression = (TypedExpression)validationContext.validate(this.m_DateExpression);
        if (null != this.m_TimeZoneExpression) {
            this.m_TimeZoneExpression = (TypedExpression)validationContext.validate(this.m_TimeZoneExpression);
        }
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        boolean bl = this.getDateExpression().isDefinitionComplete();
        if (null != this.getTimeZoneExpression()) {
            bl &= this.getTimeZoneExpression().isDefinitionComplete();
        }
        return bl;
    }

    public TimeZoneExpression(TypedExpression typedExpression, TypedExpression typedExpression2) {
        TimeZoneExpression.validateValue(typedExpression);
        typedExpression.validateType(24);
        this.m_DateExpression = typedExpression;
        this.m_TimeZoneExpression = typedExpression2;
        if (null == typedExpression2) {
            this.setDataType(DataType.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
        } else {
            this.setDataType(DataType.TIMESTAMP_WITH_TIME_ZONE);
        }
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitTimeZoneExpression(this, object);
    }

    public TypedExpression getDateExpression() {
        return this.m_DateExpression;
    }

    public TypedExpression getTimeZoneExpression() {
        return this.m_TimeZoneExpression;
    }
}

