/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import java.util.List;
import oracle.hcs.syntax.Condition;
import oracle.hcs.syntax.SymmetricConditionElement;
import oracle.hcs.syntax.SyntaxException;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.ValidationContext;
import oracle.hcs.syntax.metadata.mdm.MdmPrimaryDimension;
import oracle.hcs.syntax.parser.Identifier;

public final class SymmetricCondition
extends SyntaxObject {
    private SymmetricConditionElement[] m_Elements;

    private SymmetricConditionElement[] getElementsInternal() {
        return this.m_Elements;
    }

    private void checkForDuplicateDimensions(SymmetricConditionElement[] symmetricConditionElementArray) {
        for (int i = 0; i < symmetricConditionElementArray.length; ++i) {
            Identifier identifier = symmetricConditionElementArray[i].getDimensionReference().getIdentifier();
            for (int j = i + 1; j < symmetricConditionElementArray.length; ++j) {
                if (!symmetricConditionElementArray[j].getDimensionReference().getIdentifier().equals(identifier)) continue;
                throw new SyntaxException("DuplicateDimension", identifier.getName());
            }
        }
    }

    private SymmetricCondition(SymmetricConditionElement[] symmetricConditionElementArray, boolean bl) {
        SymmetricCondition.validateValues(symmetricConditionElementArray, 1);
        this.m_Elements = bl ? (SymmetricConditionElement[])symmetricConditionElementArray.clone() : symmetricConditionElementArray;
        this.initialize();
    }

    private SymmetricCondition(MdmPrimaryDimension[] mdmPrimaryDimensionArray, Condition[] conditionArray, boolean bl) {
        SymmetricCondition.validateValues(mdmPrimaryDimensionArray, 1);
        SymmetricCondition.validateValues(conditionArray, 1);
        if (mdmPrimaryDimensionArray.length != conditionArray.length) {
            throw new SyntaxException("ArraySizeMismatch");
        }
        this.m_Elements = new SymmetricConditionElement[mdmPrimaryDimensionArray.length];
        for (int i = 0; i < mdmPrimaryDimensionArray.length; ++i) {
            this.m_Elements[i] = new SymmetricConditionElement(mdmPrimaryDimensionArray[i], conditionArray[i]);
        }
        this.initialize();
    }

    private static SymmetricConditionElement[] createSymmetricConditionElementArray(List<SymmetricConditionElement> list) {
        if (null == list) {
            return null;
        }
        SymmetricConditionElement[] symmetricConditionElementArray = new SymmetricConditionElement[list.size()];
        list.toArray(symmetricConditionElementArray);
        return symmetricConditionElementArray;
    }

    private static Condition[] createConditionArray(List<Condition> list) {
        if (null == list) {
            return null;
        }
        Condition[] conditionArray = new Condition[list.size()];
        list.toArray(conditionArray);
        return conditionArray;
    }

    private static MdmPrimaryDimension[] createMdmPrimaryDimensionArray(List<MdmPrimaryDimension> list) {
        if (null == list) {
            return null;
        }
        MdmPrimaryDimension[] mdmPrimaryDimensionArray = new MdmPrimaryDimension[list.size()];
        list.toArray(mdmPrimaryDimensionArray);
        return mdmPrimaryDimensionArray;
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        super.validate(validationContext);
        validationContext.pop();
        validationContext.validateComponents(this, this.getElementsInternal());
        this.checkForDuplicateDimensions(this.getElementsInternal());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.areComponentsComplete(this.getElementsInternal())) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        for (int i = 0; i < this.getElementsInternal().length; ++i) {
            if (0 != i) {
                syntaxPrintingContext.append(", ");
                syntaxPrintingContext.newLineAndIndent();
            }
            syntaxPrintingContext.print(this.getElementsInternal()[i]);
        }
    }

    public SymmetricCondition(MdmPrimaryDimension[] mdmPrimaryDimensionArray, Condition[] conditionArray) {
        this(mdmPrimaryDimensionArray, conditionArray, true);
    }

    public SymmetricCondition(List<MdmPrimaryDimension> list, List<Condition> list2) {
        this(SymmetricCondition.createMdmPrimaryDimensionArray(list), SymmetricCondition.createConditionArray(list2), false);
    }

    public SymmetricCondition(SymmetricConditionElement[] symmetricConditionElementArray) {
        this(symmetricConditionElementArray, true);
    }

    public SymmetricCondition(List<SymmetricConditionElement> list) {
        this(SymmetricCondition.createSymmetricConditionElementArray(list), false);
    }

    public MdmPrimaryDimension[] getDimensions() {
        MdmPrimaryDimension[] mdmPrimaryDimensionArray = new MdmPrimaryDimension[this.m_Elements.length];
        for (int i = 0; i < this.m_Elements.length; ++i) {
            mdmPrimaryDimensionArray[i] = this.m_Elements[i].getDimension();
        }
        return mdmPrimaryDimensionArray;
    }

    public Condition[] getConditions() {
        Condition[] conditionArray = new Condition[this.m_Elements.length];
        for (int i = 0; i < this.m_Elements.length; ++i) {
            conditionArray[i] = this.m_Elements[i].getCondition();
        }
        return conditionArray;
    }

    public SymmetricConditionElement[] getElements() {
        return (SymmetricConditionElement[])this.getElementsInternal().clone();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitSymmetricCondition(this, object);
    }
}

