/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import java.util.List;
import oracle.hcs.syntax.ColumnExpression;
import oracle.hcs.syntax.Expression;
import oracle.hcs.syntax.FunctionArgument;
import oracle.hcs.syntax.FunctionDescriptor;
import oracle.hcs.syntax.FunctionDescriptorArgument;
import oracle.hcs.syntax.FunctionDescriptorCatalog;
import oracle.hcs.syntax.FunctionDescriptorChoiceArgument;
import oracle.hcs.syntax.KeywordArgument;
import oracle.hcs.syntax.RowExpression;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.UnresolvedExpression;
import oracle.hcs.syntax.ValidationContext;

public final class RowFunctionExpression
extends RowExpression {
    private String m_FunctionName;
    private FunctionDescriptor m_FunctionDescriptor;
    private FunctionArgument[] m_Arguments;

    private FunctionArgument[] getArgumentsInternal() {
        return this.m_Arguments;
    }

    private RowFunctionExpression(String string, FunctionArgument[] functionArgumentArray, boolean bl) {
        RowFunctionExpression.validateValue(string);
        this.m_FunctionName = string;
        this.m_Arguments = bl ? RowFunctionExpression.getFunctionArgumentArrayClone(functionArgumentArray) : functionArgumentArray;
        this.initialize();
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append(this.getFunctionName());
        if (this.getArgumentsInternal().length == 0 && this.getFunctionDescriptor() != null && this.getFunctionDescriptor().isPseudoColumn()) {
            return;
        }
        Expression.printExpressions(this.getArgumentsInternal(), syntaxPrintingContext);
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        Object[] objectArray;
        validationContext.push(this);
        if (this.m_FunctionName.equals("EXTRACT") && (objectArray = FunctionDescriptorCatalog.getFunctionDescriptors("EXTRACT")) != null && objectArray.length > 0) {
            Object object = objectArray[0];
            FunctionDescriptorArgument[] functionDescriptorArgumentArray = ((FunctionDescriptor)object).getArguments();
            if (this.m_Arguments.length > 0 && this.m_Arguments[0] instanceof UnresolvedExpression) {
                FunctionDescriptorArgument functionDescriptorArgument;
                UnresolvedExpression unresolvedExpression = (UnresolvedExpression)this.m_Arguments[0];
                ColumnExpression columnExpression = unresolvedExpression.resolveToColumnExpression(validationContext);
                String string = columnExpression.getColumnName();
                if (functionDescriptorArgumentArray.length > 0 && (functionDescriptorArgument = functionDescriptorArgumentArray[0]) instanceof FunctionDescriptorChoiceArgument) {
                    FunctionDescriptorChoiceArgument functionDescriptorChoiceArgument = (FunctionDescriptorChoiceArgument)functionDescriptorArgument;
                    for (FunctionDescriptorArgument functionDescriptorArgument2 : functionDescriptorChoiceArgument.getChoices()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        functionDescriptorArgument2.toSyntax(stringBuffer);
                        if (!string.equals(stringBuffer.toString())) continue;
                        this.m_Arguments[0] = new KeywordArgument(string);
                        break;
                    }
                }
            }
        }
        objectArray = new FunctionArgument[this.getArgumentsInternal().length];
        this.m_FunctionDescriptor = FunctionDescriptorCatalog.getValidFunctionDescriptor(this.getFunctionName(), this.getArgumentsInternal(), (FunctionArgument[])objectArray, null, null, 3, "UnknownRowFunction", validationContext);
        this.m_Arguments = objectArray;
        validationContext.pop();
        this.setDataType(validationContext.getCurrentDataType());
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        return this.areComponentsComplete(this.getArgumentsInternal());
    }

    public RowFunctionExpression(String string, FunctionArgument[] functionArgumentArray) {
        this(string, functionArgumentArray, true);
    }

    public RowFunctionExpression(String string, List<FunctionArgument> list) {
        this(string, RowFunctionExpression.getFunctionArgumentArrayClone(list), false);
    }

    public RowFunctionExpression(String string) {
        this(string, new FunctionArgument[0], false);
    }

    public RowFunctionExpression(String string, FunctionArgument functionArgument) {
        this(string, new FunctionArgument[]{functionArgument}, false);
    }

    public RowFunctionExpression(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2}, false);
    }

    public RowFunctionExpression(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2, FunctionArgument functionArgument3) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2, functionArgument3}, false);
    }

    public RowFunctionExpression(String string, FunctionArgument functionArgument, FunctionArgument functionArgument2, FunctionArgument functionArgument3, FunctionArgument functionArgument4) {
        this(string, new FunctionArgument[]{functionArgument, functionArgument2, functionArgument3, functionArgument4}, false);
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitRowFunctionExpression(this, object);
    }

    public FunctionArgument[] getArguments() {
        return (FunctionArgument[])this.getArgumentsInternal().clone();
    }

    public FunctionDescriptor getFunctionDescriptor() {
        return this.m_FunctionDescriptor;
    }

    public String getFunctionName() {
        return this.m_FunctionName;
    }
}

