/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.BaseMetadataObjectReference;
import oracle.hcs.syntax.DataObject;
import oracle.hcs.syntax.MetadataObjectReference;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;
import oracle.hcs.syntax.metadata.mdm.MdmPrimaryDimension;
import oracle.hcs.syntax.parser.ExpParser;

public final class Qualifier
extends DataObject {
    private BaseMetadataObjectReference m_Dimension = null;
    private TypedExpression m_Expression = null;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        if (this.m_Dimension != null) {
            this.m_Dimension.toSyntax(syntaxPrintingContext);
            syntaxPrintingContext.append(" = ");
            syntaxPrintingContext.print(this.getExpression());
        } else {
            syntaxPrintingContext.print(this.getExpression());
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_Expression = validationContext.validateExp(this.m_Expression);
        if (this.m_Dimension != null) {
            this.m_Dimension = (BaseMetadataObjectReference)validationContext.validate(this.m_Dimension);
        }
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (this.m_Dimension != null && !this.m_Dimension.isDefinitionComplete()) {
            return false;
        }
        if (!this.getExpression().isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    public Qualifier(MdmPrimaryDimension mdmPrimaryDimension, TypedExpression typedExpression) {
        Qualifier.validateValue(mdmPrimaryDimension);
        Qualifier.validateValue(typedExpression);
        this.m_Dimension = new MetadataObjectReference(mdmPrimaryDimension, MdmPrimaryDimension.class);
        this.m_Expression = typedExpression;
        this.initialize();
    }

    public Qualifier(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference, TypedExpression typedExpression) {
        if (baseMetadataObjectReference != null) {
            Qualifier.validateValue(baseMetadataObjectReference);
        }
        Qualifier.validateValue(typedExpression);
        this.m_Dimension = baseMetadataObjectReference;
        this.m_Expression = typedExpression;
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitQualifier(this, object);
    }

    public MdmPrimaryDimension getDimension() {
        return (MdmPrimaryDimension)this.m_Dimension.getBaseMetadataObject();
    }

    public String getDimensionID() {
        if (this.m_Dimension != null) {
            return this.m_Dimension.getIdentifier().toString();
        }
        return "";
    }

    public TypedExpression getExpression() {
        return this.m_Expression;
    }

    @Override
    public boolean isCompositeObject() {
        return true;
    }
}

