/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.BinaryOperatorExpression;
import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.NumberExpression;
import oracle.hcs.syntax.RowExpression;
import oracle.hcs.syntax.SyntaxException;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;

public final class IntervalExpression
extends RowExpression {
    public static final String DAY_TO_SECOND = "DAY_TO_SECOND";
    public static final String YEAR_TO_MONTH = "YEAR_TO_MONTH";
    static final String[] ALL_OPERATORS = new String[]{"YEAR_TO_MONTH", "DAY_TO_SECOND"};
    private String m_Operator;
    private TypedExpression m_LeftExpression;
    private TypedExpression m_RightExpression;
    private TypedExpression m_FirstPrecisionExpression;
    private TypedExpression m_SecondPrecisionExpression;

    public void printPrecision(TypedExpression typedExpression, SyntaxPrintingContext syntaxPrintingContext) {
        if (null == typedExpression) {
            return;
        }
        syntaxPrintingContext.append("(");
        syntaxPrintingContext.print(typedExpression);
        syntaxPrintingContext.append(")");
    }

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        syntaxPrintingContext.append("(");
        syntaxPrintingContext.print(this.getLeftExpression());
        syntaxPrintingContext.append(" - ");
        syntaxPrintingContext.print(this.getRightExpression());
        syntaxPrintingContext.append(")");
        if (DAY_TO_SECOND == this.getOperator()) {
            syntaxPrintingContext.append(" DAY ");
            this.printPrecision(this.getFirstPrecisionExpression(), syntaxPrintingContext);
            syntaxPrintingContext.append(" TO SECOND ");
            this.printPrecision(this.getSecondPrecisionExpression(), syntaxPrintingContext);
        } else {
            syntaxPrintingContext.append(" YEAR ");
            this.printPrecision(this.getFirstPrecisionExpression(), syntaxPrintingContext);
            syntaxPrintingContext.append(" TO MONTH ");
        }
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        validationContext.push(this);
        this.m_LeftExpression = (TypedExpression)validationContext.validate(this.m_LeftExpression);
        this.m_RightExpression = (TypedExpression)validationContext.validate(this.m_RightExpression);
        if (null != this.m_FirstPrecisionExpression) {
            this.m_FirstPrecisionExpression = (TypedExpression)validationContext.validate(this.m_FirstPrecisionExpression);
        }
        if (null != this.m_SecondPrecisionExpression) {
            this.m_SecondPrecisionExpression = (TypedExpression)validationContext.validate(this.m_SecondPrecisionExpression);
        }
        validationContext.pop();
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        boolean bl = this.getLeftExpression().isDefinitionComplete();
        bl &= this.getRightExpression().isDefinitionComplete();
        if (null != this.getFirstPrecisionExpression()) {
            bl &= this.getFirstPrecisionExpression().isDefinitionComplete();
        }
        if (null != this.getSecondPrecisionExpression()) {
            bl &= this.getSecondPrecisionExpression().isDefinitionComplete();
        }
        return bl;
    }

    public TypedExpression getLeftExpression() {
        return this.m_LeftExpression;
    }

    public TypedExpression getRightExpression() {
        return this.m_RightExpression;
    }

    private void localInitialize(TypedExpression typedExpression, TypedExpression typedExpression2, String string, TypedExpression typedExpression3, TypedExpression typedExpression4) {
        this.m_Operator = IntervalExpression.validateEnum(string, ALL_OPERATORS);
        IntervalExpression.validateValue(typedExpression);
        IntervalExpression.validateValue(typedExpression2);
        if (this.m_Operator == DAY_TO_SECOND) {
            this.setDataType(DataType.DS_INTERVAL);
        } else {
            this.setDataType(DataType.YM_INTERVAL);
        }
        this.m_LeftExpression = typedExpression;
        this.m_RightExpression = typedExpression2;
        this.m_FirstPrecisionExpression = typedExpression3;
        if (null != typedExpression3) {
            if (!(typedExpression3 instanceof NumberExpression)) {
                throw new SyntaxException("SyntaxTypeMismatch", NumberExpression.class.getName(), typedExpression3.getClass().getName());
            }
            typedExpression3.validateType(2);
        }
        this.m_SecondPrecisionExpression = typedExpression4;
        if (null != typedExpression4) {
            if (!(typedExpression4 instanceof NumberExpression)) {
                throw new SyntaxException("SyntaxTypeMismatch", NumberExpression.class.getName(), typedExpression4.getClass().getName());
            }
            typedExpression4.validateType(2);
        }
    }

    public IntervalExpression(TypedExpression typedExpression, TypedExpression typedExpression2, String string, TypedExpression typedExpression3, TypedExpression typedExpression4) {
        this.localInitialize(typedExpression, typedExpression2, string, typedExpression3, typedExpression4);
        this.initialize();
    }

    public IntervalExpression(TypedExpression typedExpression, String string, TypedExpression typedExpression2, TypedExpression typedExpression3) {
        IntervalExpression.validateValue(typedExpression);
        if (!(typedExpression instanceof BinaryOperatorExpression) || "-" != ((BinaryOperatorExpression)typedExpression).getOperator() || ((BinaryOperatorExpression)typedExpression).getArguments().length != 2) {
            throw new SyntaxException("InvalidArguments", typedExpression.getClass().getName());
        }
        this.localInitialize(((BinaryOperatorExpression)typedExpression).getArguments()[0], ((BinaryOperatorExpression)typedExpression).getArguments()[1], string, typedExpression2, typedExpression3);
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitIntervalExpression(this, object);
    }

    @Override
    public String getOperator() {
        return this.m_Operator;
    }

    public TypedExpression getBaseExpression() {
        return new BinaryOperatorExpression(this.m_LeftExpression, "-", this.m_RightExpression);
    }

    public TypedExpression getFirstPrecisionExpression() {
        return this.m_FirstPrecisionExpression;
    }

    public TypedExpression getSecondPrecisionExpression() {
        return this.m_SecondPrecisionExpression;
    }
}

