/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.preferences;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import oracle.hcs.HCSArb;
import oracle.hcs.preferences.HCSPreferenceSettings;
import oracle.hcs.util.RestrictedTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;

public class HCSPreferencesPanel
extends DefaultTraversablePanel {
    private JLabel descriptionLabel;
    private JLabel templateDirLabel;
    private JFileChooser templateDirChooser;
    private JTextField templateDirField;
    private JButton templateDirButton;
    private JFileChooser templateFileChooser;
    private JLabel templateFileLabel;
    private JTextField templateFileField;
    private JButton templateFileButton;
    private JLabel templateNameFileLabel;
    private JTextField templateNameFileField;
    private JButton templateNameFileButton;
    private JLabel avViewerMaxHiersLabel;
    private RestrictedTextField avViewerMaxHiersField;
    private JLabel avViewerMaxRowsLabel;
    private RestrictedTextField avViewerMaxRowsField;
    private JLabel autoGenerateLevelsLabel;
    private JCheckBox autoGenerateLevelsCheckBox;

    public HCSPreferencesPanel() {
        this.initComponents();
        this.setHelpID("av_preferences");
    }

    private void initComponents() {
        this.templateDirChooser = new JFileChooser();
        this.templateDirChooser.setFileSelectionMode(1);
        this.templateFileChooser = new JFileChooser();
        this.templateFileChooser.setFileFilter(new FileNameExtensionFilter("Xml", "xml"));
        this.templateDirChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file != null && file.isDirectory();
            }

            @Override
            public String getDescription() {
                return HCSArb.get("HCS_PREFERENCES_TEMPLATE_DIR_FILTER_DESCRIPTION");
            }
        });
        this.descriptionLabel = new JLabel(HCSArb.get("HCS_PREFERENCES"));
        this.templateDirLabel = new JLabel(HCSArb.get("HCS_PREFERENCES_TEMPLATE_DIR"));
        this.templateDirField = new JTextField();
        this.templateDirButton = new JButton(new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                File file = new File(HCSPreferencesPanel.this.templateDirField.getText());
                if (file.exists()) {
                    HCSPreferencesPanel.this.templateDirChooser.setCurrentDirectory(file);
                }
                if ((n = HCSPreferencesPanel.this.templateDirChooser.showOpenDialog((Component)((Object)HCSPreferencesPanel.this))) == 0) {
                    HCSPreferencesPanel.this.templateDirField.setText(HCSPreferencesPanel.this.templateDirChooser.getSelectedFile().toString());
                }
            }
        });
        this.templateFileLabel = new JLabel(HCSArb.getString("HCS_PREFERENCES_TEMPLATE_FILE"));
        this.templateFileField = new JTextField();
        this.templateFileButton = new JButton(new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                File file = new File(HCSPreferencesPanel.this.templateFileField.getText());
                if (file.exists()) {
                    HCSPreferencesPanel.this.templateFileChooser.setSelectedFile(file);
                }
                if ((n = HCSPreferencesPanel.this.templateFileChooser.showOpenDialog((Component)((Object)HCSPreferencesPanel.this))) == 0) {
                    HCSPreferencesPanel.this.templateFileField.setText(HCSPreferencesPanel.this.templateFileChooser.getSelectedFile().toString());
                }
            }
        });
        this.templateNameFileLabel = new JLabel(HCSArb.get("HCS_PREFERENCES_TEMPLATE_NAME_FILE"));
        this.templateNameFileField = new JTextField();
        this.templateNameFileButton = new JButton(new AbstractAction("..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                File file = new File(HCSPreferencesPanel.this.templateNameFileField.getText());
                if (file.exists()) {
                    HCSPreferencesPanel.this.templateFileChooser.setSelectedFile(file);
                }
                if ((n = HCSPreferencesPanel.this.templateFileChooser.showOpenDialog((Component)((Object)HCSPreferencesPanel.this))) == 0) {
                    HCSPreferencesPanel.this.templateNameFileField.setText(HCSPreferencesPanel.this.templateFileChooser.getSelectedFile().toString());
                }
            }
        });
        this.avViewerMaxHiersLabel = new JLabel(HCSArb.get("HCS_PREFERENCES_MAX_HIERARCHIES_AV_DATA_VIEWER"));
        this.avViewerMaxHiersField = new RestrictedTextField();
        this.avViewerMaxHiersField.setFilterMode(2);
        this.avViewerMaxRowsLabel = new JLabel(HCSArb.getString("HCS_PREFERENCES_MAX_ROWS_AV_DATA_VIEWER"));
        this.avViewerMaxRowsField = new RestrictedTextField();
        this.avViewerMaxRowsField.setFilterMode(2);
        this.autoGenerateLevelsLabel = new JLabel(HCSArb.getString("HCS_PREFERENCES_AUTO_GENERATE_LEVELS"));
        this.autoGenerateLevelsCheckBox = new JCheckBox();
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setAutoCreateGaps(true);
        this.setLayout(groupLayout);
        GroupLayout.SequentialGroup sequentialGroup = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup = groupLayout.createParallelGroup();
        GroupLayout.ParallelGroup parallelGroup2 = groupLayout.createParallelGroup();
        GroupLayout.ParallelGroup parallelGroup3 = groupLayout.createParallelGroup();
        parallelGroup.addComponent(this.descriptionLabel);
        parallelGroup.addComponent(this.templateDirLabel);
        parallelGroup.addComponent(this.templateFileLabel);
        parallelGroup.addComponent(this.templateNameFileLabel);
        parallelGroup.addComponent(this.avViewerMaxHiersLabel);
        parallelGroup.addComponent(this.avViewerMaxRowsLabel);
        parallelGroup.addComponent(this.autoGenerateLevelsLabel);
        parallelGroup2.addComponent(this.templateDirField);
        parallelGroup2.addComponent(this.templateFileField);
        parallelGroup2.addComponent(this.templateNameFileField);
        parallelGroup2.addComponent(this.avViewerMaxHiersField);
        parallelGroup2.addComponent(this.avViewerMaxRowsField);
        parallelGroup2.addComponent(this.autoGenerateLevelsCheckBox);
        parallelGroup3.addComponent(this.templateDirButton);
        parallelGroup3.addComponent(this.templateFileButton);
        parallelGroup3.addComponent(this.templateNameFileButton);
        sequentialGroup.addGroup(parallelGroup);
        sequentialGroup.addGroup(parallelGroup2);
        sequentialGroup.addGroup(parallelGroup3);
        GroupLayout.SequentialGroup sequentialGroup2 = groupLayout.createSequentialGroup();
        GroupLayout.ParallelGroup parallelGroup4 = groupLayout.createParallelGroup();
        parallelGroup4.addComponent(this.descriptionLabel);
        GroupLayout.ParallelGroup parallelGroup5 = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        parallelGroup5.addComponent(this.templateDirLabel);
        parallelGroup5.addComponent(this.templateDirField, -2, -2, -2);
        parallelGroup5.addComponent(this.templateDirButton);
        GroupLayout.ParallelGroup parallelGroup6 = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        parallelGroup6.addComponent(this.templateFileLabel);
        parallelGroup6.addComponent(this.templateFileField, -2, -2, -2);
        parallelGroup6.addComponent(this.templateFileButton);
        GroupLayout.ParallelGroup parallelGroup7 = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        parallelGroup7.addComponent(this.templateNameFileLabel);
        parallelGroup7.addComponent(this.templateNameFileField, -2, -2, -2);
        parallelGroup7.addComponent(this.templateNameFileButton);
        GroupLayout.ParallelGroup parallelGroup8 = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        parallelGroup8.addComponent(this.avViewerMaxHiersLabel);
        parallelGroup8.addComponent(this.avViewerMaxHiersField, -2, -2, -2);
        GroupLayout.ParallelGroup parallelGroup9 = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        parallelGroup9.addComponent(this.avViewerMaxRowsLabel);
        parallelGroup9.addComponent(this.avViewerMaxRowsField, -2, -2, -2);
        GroupLayout.ParallelGroup parallelGroup10 = groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER);
        parallelGroup10.addComponent(this.autoGenerateLevelsLabel);
        parallelGroup10.addComponent(this.autoGenerateLevelsCheckBox, -2, -2, -2);
        sequentialGroup2.addGroup(parallelGroup4);
        sequentialGroup2.addGroup(parallelGroup5);
        sequentialGroup2.addGroup(parallelGroup6);
        sequentialGroup2.addGroup(parallelGroup7);
        sequentialGroup2.addGroup(parallelGroup9);
        sequentialGroup2.addGroup(parallelGroup8);
        sequentialGroup2.addGroup(parallelGroup10);
        groupLayout.setHorizontalGroup(sequentialGroup);
        groupLayout.setVerticalGroup(sequentialGroup2);
    }

    public void onEntry(TraversableContext traversableContext) {
        HCSPreferenceSettings hCSPreferenceSettings = HCSPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
        String string = hCSPreferenceSettings.getTemplateDirectory();
        this.templateDirField.setText(string);
        string = hCSPreferenceSettings.getTemplateFile();
        this.templateFileField.setText(string);
        string = hCSPreferenceSettings.getTemplateNameFile();
        this.templateNameFileField.setText(string);
        this.avViewerMaxHiersField.setText(String.valueOf(hCSPreferenceSettings.getAVDataViewerMaxHierarchies()));
        this.avViewerMaxRowsField.setText(String.valueOf(hCSPreferenceSettings.getAVDataViewerMaxRows()));
        this.autoGenerateLevelsCheckBox.setSelected(hCSPreferenceSettings.getAutoGenerateLevels());
    }

    public void onExit(TraversableContext traversableContext) {
        HCSPreferenceSettings hCSPreferenceSettings = HCSPreferenceSettings.getInstance(traversableContext.getPropertyStorage());
        String string = this.templateDirField.getText();
        hCSPreferenceSettings.setTemplateDirectory(string);
        string = this.templateFileField.getText();
        hCSPreferenceSettings.setTemplateFile(string);
        string = this.templateNameFileField.getText();
        hCSPreferenceSettings.setTemplateNameFile(string);
        hCSPreferenceSettings.setAVDataViewerMaxHierarchies(Integer.valueOf(this.avViewerMaxHiersField.getText()));
        hCSPreferenceSettings.setAVDataViewerMaxRows(Integer.valueOf(this.avViewerMaxRowsField.getText()));
        hCSPreferenceSettings.setAutoGenerateLevels(this.autoGenerateLevelsCheckBox.isSelected());
    }
}

