/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.hierarchyviewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.share.nls.StringUtils;
import oracle.hcs.HCSArb;
import oracle.hcs.db.LanguageDBSettings;
import oracle.hcs.hierarchyviewer.HierarchyET;
import oracle.hcs.hierarchyviewer.HierarchyLoader;
import oracle.hcs.navigator.HCSNavigatorResource;
import oracle.hcs.templates.templateview.Member;
import oracle.hcs.templates.templateview.QDRData;
import oracle.hcs.tree.loader.TreeLoader;
import oracle.hcs.tree.model.DefaultNode;
import oracle.hcs.tree.model.HierarchyNodeData;
import oracle.hcs.tree.model.Node;
import oracle.hcs.tree.model.VirtualTreeModel;
import oracle.hcs.tree.view.JTreeV;
import oracle.hcs.util.LanguageSelector;
import oracle.hcs.util.LanguageSelectorPanel;
import oracle.hcs.util.SearchOptions;
import oracle.hcs.util.actions.ActionCallback;
import oracle.ide.help.HelpSystem;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class HierarchyViewerDialog
extends JDialog {
    private JTreeV tree;
    private VirtualTreeModel treeModel;
    private JScrollPane sp;
    private TreeLoader treeLoader;
    private boolean nodeMultiSelect;
    private ActionCallback actionCallback;
    private SearchField searchField;
    private JComboBox hierarchySelector;
    private JComboBox<String> columnSelector;
    private JLabel hierarchyLabel;
    private JLabel columnLabel;
    private SearchOptions searchOptions;
    private DialogButtonBar bb;
    private List<Node> searchResults;
    private String previousSearch;
    private int searchIndex;
    private boolean flat;
    private boolean isOKSelected;
    private JButton okButton;
    private JButton closeButton;
    private JButton helpButton;
    private String mode;
    private LanguageSelectorPanel languagePanel;
    private List<HierarchyET> hierarchyETs;
    private String defaultLanguage;
    public static final String VIEW_DIMENSION_MEMBERS_MODE = "VIEW_DIMENSION_MEMBERS_MODE";
    public static final String SELECT_DIMENSION_MEMBERS_MODE = "SELECT_DIMENSION_MEMBERS_MODE";
    static final String MEMBER_CAPTION = "member_caption";
    static final String MEMBER_DESCRIPTION = "member_description";
    static final String MEMBER_UNIQUE_NAME = "member_unique_name";
    static final String PARENT_UNIQUE_NAME = "parent_unique_name";
    private Connection conn;
    private final int MEMBER_UNIQUE_NAME_INDEX = 2;
    private boolean showLanguages;
    private List<String> languagesList;
    private static Logger LOG = Logger.getLogger(HierarchyViewerDialog.class.getName());

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, String string3, List<String> list2, QDRData[] qDRDataArray, String string4, boolean bl, Connection connection, boolean bl2) throws Exception {
        super(window);
        if (list != null && list.size() > 0) {
            this.init(string, list, string2, string3, list2, qDRDataArray, string4, bl, connection, bl2);
        }
    }

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, String string3, List<String> list2, QDRData[] qDRDataArray, String string4, boolean bl, Connection connection) throws Exception {
        this(window, string, list, string2, string3, list2, qDRDataArray, string4, bl, connection, false);
    }

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, Connection connection) throws Exception {
        this(window, string, list, string2, null, Collections.EMPTY_LIST, null, null, true, connection);
    }

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, String string3, Connection connection) throws Exception {
        this(window, string, list, string2, string3, Collections.EMPTY_LIST, null, null, true, connection);
    }

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, String string3, QDRData[] qDRDataArray, String string4, boolean bl, Connection connection) throws Exception {
        this(window, string, list, string2, string3, null, qDRDataArray, string4, bl, connection);
    }

    public HierarchyViewerDialog(Window window, String string, List<HierarchyET> list, String string2, List<String> list2, Connection connection) throws Exception {
        this(window, string, list, string2, null, list2, null, null, true, connection);
    }

    private void init(String string, List<HierarchyET> list, String string2, String string3, List<String> list2, QDRData[] qDRDataArray, String string4, boolean bl, final Connection connection, boolean bl2) throws Exception {
        if (string3 == null) {
            string3 = VIEW_DIMENSION_MEMBERS_MODE;
        }
        this.showLanguages = bl;
        this.conn = connection;
        this.languagesList = list2;
        this.hierarchyETs = list;
        this.mode = string3;
        this.setTitle(string);
        HierarchyET hierarchyET = null;
        if (string2 != null) {
            for (HierarchyET hierarchyET2 : list) {
                if (!hierarchyET2.getHierarchyName().equalsIgnoreCase(string2)) continue;
                hierarchyET = hierarchyET2;
            }
        }
        if (hierarchyET == null) {
            hierarchyET = list.get(0);
        }
        HierarchyLoader hierarchyLoader = (HierarchyLoader)hierarchyET.getTreeLoader();
        hierarchyLoader.loadData(qDRDataArray);
        this.okButton = new JButton(StringUtils.stripMnemonic((String)HCSArb.getString("DIALOG_OK_BUTTON_TEXT")));
        this.closeButton = new JButton(StringUtils.stripMnemonic((String)HCSArb.getString("DIALOG_CLOSE_BUTTON_TEXT")));
        this.helpButton = new JButton(StringUtils.stripMnemonic((String)HCSArb.getString("DIALOG_HELP_BUTTON_TEXT")));
        this.treeModel = new VirtualTreeModel(hierarchyET.getTreeLoader().getTree());
        if (hierarchyET.getLevelNames() != null) {
            int n = hierarchyET.getLevelNames().size();
            this.treeModel.setNumberOfLevels(++n);
        }
        this.tree = new JTreeV(this.treeModel);
        this.tree.setContextProperty("DIALOG", this);
        this.tree.setShowsRootHandles(true);
        if (string3.equalsIgnoreCase(VIEW_DIMENSION_MEMBERS_MODE)) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.tree, "av_hier_data_viewer");
        } else {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.tree, "av_select_hier_members");
            this.okButton.setEnabled(false);
            this.closeButton = new JButton(StringUtils.stripMnemonic((String)HCSArb.getString("DIALOG_CANCEL_BUTTON_TEXT")));
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    if (treeSelectionEvent.getNewLeadSelectionPath() != null) {
                        HierarchyViewerDialog.this.okButton.setEnabled(true);
                    } else {
                        HierarchyViewerDialog.this.okButton.setEnabled(false);
                    }
                }
            });
            int n = 1;
            DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
            defaultTreeSelectionModel.setSelectionMode(n);
            this.tree.setSelectionModel(defaultTreeSelectionModel);
        }
        this.searchOptions = new SearchOptions();
        this.searchField = new SearchField();
        this.searchField.setStyle(SearchField.Style.FIND);
        this.searchResults = new ArrayList<Node>();
        Dimension dimension = new Dimension(300, this.searchField.getMinimumSize().height);
        this.searchField.setMinimumSize(dimension);
        this.searchField.setMaximumSize(dimension);
        this.previousSearch = "";
        this.searchIndex = 0;
        this.hierarchyLabel = new JLabel(HCSArb.getString("HIERARCHY_VIEWER_DIALOG_HIER"));
        this.columnLabel = new JLabel(HCSArb.getString("HIERARCHY_VIEWER_DIALOG_COLUMN"));
        this.hierarchySelector = new JComboBox();
        this.columnSelector = new JComboBox();
        this.columnSelector.addItem(HCSArb.getString("HIERARCHY_VIEWER_DIALOG_COLUMN_MEMBER_CAPTION"));
        this.columnSelector.addItem(HCSArb.getString("HIERARCHY_VIEWER_DIALOG_COLUMN_MEMBER_DESCRIPTION"));
        this.columnSelector.addItem(HCSArb.getString("HIERARCHY_VIEWER_DIALOG_COLUMN_MEMBER_UNIQUE_NAME"));
        if (hierarchyET.getHierarchyName() != null) {
            for (HierarchyET object2 : list) {
                this.hierarchySelector.addItem(object2.getHierarchyName());
            }
            this.hierarchySelector.setSelectedItem(hierarchyET.getHierarchyName());
            this.hierarchySelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HierarchyViewerDialog.this.loadHierarchyData();
                }
            });
            this.columnSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HierarchyViewerDialog.this.changeDisplayColumn(-1);
                }
            });
        } else {
            this.flat = true;
            this.treeModel = new VirtualTreeModel(hierarchyET.getTreeLoader().getTree());
            this.treeModel.setNumberOfLevels(1);
            this.tree.setModel(this.treeModel);
        }
        if (string4 != null) {
            int n = -1;
            if (string4.contains(MEMBER_CAPTION)) {
                n = 0;
            } else if (string4.contains(MEMBER_DESCRIPTION)) {
                n = 1;
            } else if (string4.contains(MEMBER_UNIQUE_NAME) || string4.contains(PARENT_UNIQUE_NAME)) {
                n = 2;
            }
            this.columnSelector.setSelectedIndex(n);
        }
        this.columnSelector.setEnabled(bl);
        this.defaultLanguage = LanguageDBSettings.getDefaultLanguage(connection);
        this.languagePanel = new LanguageSelectorPanel(new LanguageSelector(){

            @Override
            public void languageSelectionChanged(String string) {
                try {
                    LanguageDBSettings.setLanguage(string, connection);
                    HierarchyViewerDialog.this.columnSelector.setSelectedIndex(0);
                    HierarchyViewerDialog.this.reloadHierarchyData();
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, exception.getMessage());
                }
            }
        });
        this.languagePanel.setVisible(false);
        if (bl && this.languagesList != null && !this.languagesList.isEmpty()) {
            this.languagePanel.addLanguage(LanguageDBSettings.getDefaultLanguage(connection));
            for (String string5 : this.languagesList) {
                this.languagePanel.addLanguage(string5);
            }
            this.languagePanel.setVisible(true);
        }
        this.setSelection(qDRDataArray, bl2);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.findNode(HierarchyViewerDialog.this.searchField.getText(), SearchEvent.Direction.FORWARD);
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.searchField.requestFocus();
            }
        };
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.setVisible(false);
                HierarchyViewerDialog.this.dispose();
            }
        };
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.showHelp();
            }
        };
        this.getRootPane().getInputMap().put(KeyStroke.getKeyStroke("control F"), abstractAction2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("control F"), "findFocus");
        actionMap.put("findFocus", abstractAction2);
        inputMap.put(KeyStroke.getKeyStroke("F3"), "find");
        actionMap.put("find", abstractAction);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "close");
        actionMap.put("close", abstractAction3);
        inputMap.put(KeyStroke.getKeyStroke("F1"), "help");
        actionMap.put("help", abstractAction4);
        Icon icon = HCSNavigatorResource.getIcon("MEMBER");
        Icon icon2 = HCSNavigatorResource.getIcon("MEMBER_FOLDER");
        if (icon != null && icon2 != null) {
            this.tree.setFolderIcon(icon2);
            this.tree.setLeafIcon(icon);
        }
        this.layoutComponents();
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.isOKSelected = true;
                HierarchyViewerDialog.this.dispose();
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.dispose();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HierarchyViewerDialog.this.showHelp();
            }
        });
        this.searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                HierarchyViewerDialog.this.findNode(searchEvent.getSearchText(), searchEvent.getDirection());
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
        this.addWindowListener(new CleanUpTreeOnWindowClosed());
    }

    private void setSelection(QDRData[] qDRDataArray, boolean bl) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        SearchOptions searchOptions = new SearchOptions();
        searchOptions.setOption("MATCH_WHOLE_WORD", true);
        int n = 0;
        n = !bl ? 4 : 1;
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(n);
        this.tree.setSelectionModel(defaultTreeSelectionModel);
        boolean bl2 = false;
        if (qDRDataArray != null) {
            for (QDRData qDRData : qDRDataArray) {
                if (qDRData.additionalMembers != null) {
                    for (Member member : qDRData.additionalMembers) {
                        String string = member.getMemberKey();
                        this.tree.findNodes("KEY", string, searchOptions, arrayList);
                    }
                    continue;
                }
                String string = qDRData.getMemberKey();
                if (string == null) {
                    bl2 = true;
                    break;
                }
                this.tree.findNodes("KEY", string, searchOptions, arrayList);
            }
            if (bl2) {
                this.tree.setSelectionRow(0);
            } else {
                this.tree.selectNodes(arrayList);
            }
        }
    }

    private void loadHierarchyData() {
        String string = (String)this.hierarchySelector.getSelectedItem();
        HierarchyET hierarchyET = this.findHierarchyByName(string);
        if (hierarchyET != null) {
            if (hierarchyET.getTreeLoader().getFinishedLoadingAtDepth() < 0) {
                try {
                    hierarchyET.getTreeLoader().loadData();
                }
                catch (Exception exception) {
                    return;
                }
            }
            this.treeModel = new VirtualTreeModel(hierarchyET.getTreeLoader().getTree());
            if (hierarchyET.getLevelNames() != null) {
                this.treeModel.setNumberOfLevels(hierarchyET.getLevelNames().size() + 1);
            }
            this.tree.setModel(this.treeModel);
        }
    }

    private void changeDisplayColumn(int n) {
        HierarchyET hierarchyET;
        QDRData qDRData = null;
        int n2 = this.tree.getSelectionModel().getSelectionMode();
        TreePath[] treePathArray = this.tree.getSelectionPaths();
        if (treePathArray != null && treePathArray.length > 0) {
            qDRData = new QDRData();
            for (TreePath treePath : treePathArray) {
                Object object = treePath.getLastPathComponent();
                DefaultNode defaultNode = (DefaultNode)object;
                HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)defaultNode.getUserObject();
                String string = (String)hierarchyNodeData.getProperty(hierarchyNodeData.LEVEL_NAME);
                qDRData.addMember(hierarchyNodeData.dimKey, hierarchyNodeData.desc, string, (String)hierarchyNodeData.getProperty(hierarchyNodeData.LEVEL_KEY));
            }
        }
        if (n == -1) {
            n = this.columnSelector.getSelectedIndex();
        }
        TreePath[] treePathArray2 = (TreePath[])this.hierarchySelector.getSelectedItem();
        if (this.languagePanel != null) {
            if (n == 2) {
                this.languagePanel.setVisible(false);
            } else if (this.showLanguages && this.languagesList != null && !this.languagesList.isEmpty()) {
                this.languagePanel.setVisible(true);
            }
        }
        if ((hierarchyET = this.findHierarchyByName((String)treePathArray2)) != null) {
            if (hierarchyET.getTreeLoader().getFinishedLoadingAtDepth() < 0) {
                try {
                    hierarchyET.getTreeLoader().loadData();
                }
                catch (Exception exception) {
                    return;
                }
            }
            hierarchyET.getTreeLoader().changeDisplayColumn(n);
            this.treeModel = new VirtualTreeModel(hierarchyET.getTreeLoader().getTree());
            if (hierarchyET.getLevelNames() != null) {
                this.treeModel.setNumberOfLevels(hierarchyET.getLevelNames().size() + 1);
            }
            this.tree.setModel(this.treeModel);
        }
        if (qDRData != null) {
            this.setSelection(new QDRData[]{qDRData}, n2 == 1);
        }
    }

    private HierarchyET findHierarchyByName(String string) {
        HierarchyET hierarchyET = null;
        for (HierarchyET hierarchyET2 : this.hierarchyETs) {
            if (!hierarchyET2.getHierarchyName().equalsIgnoreCase(string)) continue;
            hierarchyET = hierarchyET2;
            break;
        }
        return hierarchyET;
    }

    private void reloadHierarchyData() {
        String string = (String)this.hierarchySelector.getSelectedItem();
        HierarchyET hierarchyET = this.findHierarchyByName(string);
        if (hierarchyET != null) {
            try {
                hierarchyET.reload();
                hierarchyET.getTreeLoader().loadData();
            }
            catch (Exception exception) {
                return;
            }
            this.treeModel = new VirtualTreeModel(hierarchyET.getTreeLoader().getTree());
            if (hierarchyET.getLevelNames() != null) {
                this.treeModel.setNumberOfLevels(hierarchyET.getLevelNames().size() + 1);
            }
            this.tree.setModel(this.treeModel);
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.searchField, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.languagePanel, new GridBagConstraints(1, n++, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.setBorder(BorderFactory.createCompoundBorder());
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (!this.flat) {
            this.add((Component)this.hierarchyLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
            this.add((Component)this.hierarchySelector, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        }
        this.add((Component)this.columnLabel, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.add(this.columnSelector, new GridBagConstraints(1, n, 1, 1, 0.5, 0.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree, 30, 20);
        this.add((Component)this.sp, new GridBagConstraints(0, ++n, 2, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.bb = new DialogButtonBar();
        this.bb.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        if (this.mode.equalsIgnoreCase(SELECT_DIMENSION_MEMBERS_MODE)) {
            this.getRootPane().setDefaultButton(this.okButton);
            this.bb.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_APPLY);
        }
        this.bb.add((Component)this.closeButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this.add((Component)this.bb, new GridBagConstraints(0, ++n, 2, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setNodeMultiSelect(boolean bl) {
        this.nodeMultiSelect = bl;
        int n = bl ? 4 : 1;
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(n);
        this.tree.setSelectionModel(defaultTreeSelectionModel);
    }

    public void addDialogSaveButton(JButton jButton) {
        this.bb.add((Component)jButton, DialogButtonBar.CONSTRAINT_APPLY);
    }

    public void setActionCallback(ActionCallback actionCallback) {
        this.actionCallback = actionCallback;
    }

    public void showHelp() {
        if (this.actionCallback != null) {
            this.actionCallback.action(this, "HELP");
        } else {
            HelpSystem.getHelpSystem().showHelp((JComponent)this.tree);
        }
    }

    public void cleanup() {
        if (this.treeLoader != null) {
            this.treeLoader.setStopLoadingData(true);
        }
        this.treeLoader = null;
        this.tree = null;
        this.treeModel = null;
        try {
            LanguageDBSettings.setLanguage(this.defaultLanguage, this.conn);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getMessage());
        }
    }

    private void findNode(String string, SearchEvent.Direction direction) {
        if (string.length() > 0) {
            if (this.searchResults.isEmpty()) {
                this.tree.findNodes("DESC", string, this.searchOptions, this.searchResults);
                if (!this.searchResults.isEmpty()) {
                    this.tree.selectNode(this.searchResults.get(0));
                }
                this.previousSearch = string;
            } else if (this.previousSearch.equals(string)) {
                this.searchIndex = direction.equals((Object)SearchEvent.Direction.FORWARD) ? (this.searchIndex + 1 < this.searchResults.size() ? ++this.searchIndex : 0) : (this.searchIndex - 1 >= 0 ? --this.searchIndex : this.searchResults.size() - 1);
                if (!this.searchResults.isEmpty()) {
                    this.tree.selectNode(this.searchResults.get(this.searchIndex));
                }
            } else {
                this.searchResults.clear();
                this.searchIndex = 0;
                this.tree.findNodes("DESC", string, this.searchOptions, this.searchResults);
                if (!this.searchResults.isEmpty()) {
                    this.tree.selectNode(this.searchResults.get(0));
                }
                this.previousSearch = string;
            }
        }
    }

    public JTreeV getTree() {
        return this.tree;
    }

    public boolean isOKSelected() {
        return this.isOKSelected;
    }

    private class CleanUpTreeOnWindowClosed
    extends WindowAdapter {
        private CleanUpTreeOnWindowClosed() {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            HierarchyViewerDialog.this.cleanup();
        }
    }
}

