/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.hierarchy.model;

import oracle.hcs.db.DBStringUtils;
import oracle.hcs.db.model.NamedObject;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Internal;

public class HierarchyLevel
extends AbstractChildDBObject
implements NamedObject {
    public static final String TYPE = "HIERARCHY_LEVEL2";

    public HierarchyLevel() {
    }

    public HierarchyLevel(Hierarchy hierarchy, DimensionLevel dimensionLevel) {
        super(hierarchy.getName() + "." + dimensionLevel.getName());
        this.setParent((DBObject)hierarchy);
        this.setHierarchyLevelName(dimensionLevel);
    }

    public HierarchyLevel(Hierarchy hierarchy, String string) {
        super(hierarchy.getName() + "." + string);
        this.setParent((DBObject)hierarchy);
        this.setProperty("hierarchyLevelName", string);
    }

    public String getType() {
        return TYPE;
    }

    public void setHierarchyLevelName(DimensionLevel dimensionLevel) {
        String string = dimensionLevel.getName();
        this.setProperty("hierarchyLevelName", string);
    }

    public String getHierarchyLevelName() {
        String string = (String)this.getProperty("hierarchyLevelName");
        return string;
    }

    public Hierarchy getHierarchy() {
        Hierarchy hierarchy = (Hierarchy)this.getParent();
        return hierarchy;
    }

    public String getHierarchyName() {
        Hierarchy hierarchy = (Hierarchy)this.getParent();
        return hierarchy.getName();
    }

    public DimensionLevel getLevel() {
        String string = this.getHierarchyLevelName();
        AttributeDimension attributeDimension = this.getHierarchyDimension();
        DimensionLevel dimensionLevel = null;
        if (attributeDimension != null) {
            dimensionLevel = attributeDimension.findLevel(string);
        }
        if (dimensionLevel == null && string.equals("\"ALL\"")) {
            dimensionLevel = new DimensionLevel(attributeDimension, string);
        }
        return dimensionLevel;
    }

    public Integer getHierLevelOrder() {
        Integer n = (Integer)this.getProperty("hierLevelOrder");
        return n;
    }

    public void setHierLevelOrder(int n) {
        this.setProperty("hierLevelOrder", n);
    }

    public int getLevelDepth() {
        int n = 0;
        Hierarchy hierarchy = (Hierarchy)this.getParent();
        HierarchyLevel[] hierarchyLevelArray = hierarchy.getHierarchyLevelsReverse();
        for (int i = 0; i < hierarchyLevelArray.length; ++i) {
            HierarchyLevel hierarchyLevel = hierarchyLevelArray[i];
            if (!hierarchyLevel.equals(this.getName())) continue;
            n = i + 1;
            break;
        }
        return n;
    }

    public String getLevelName() {
        String string = null;
        if (this.getLevel() != null) {
            string = this.getLevel().getName();
        } else {
            int n = this.getName().indexOf(".");
            string = this.getName().substring(n + 1);
        }
        return string;
    }

    public String getLevelKeyColumn() {
        String[] stringArray;
        String string = null;
        if (this.getLevel() != null && (string = this.getLevel().getLevelKey()).contains(",") && (stringArray = (string = string.replaceAll("[()]", "")).split(",")) != null & stringArray.length > 0) {
            string = stringArray[0];
        }
        return DBStringUtils.externalizeName(string);
    }

    @Internal
    public AttributeDimension getHierarchyDimension() {
        DBObject dBObject = this.getParent();
        if (dBObject instanceof Hierarchy) {
            Hierarchy hierarchy = (Hierarchy)dBObject;
            AttributeDimension attributeDimension = hierarchy.getDimension();
            return attributeDimension;
        }
        return null;
    }

    public String getQualifiedName() {
        String string = String.format("%s.%s", this.getHierarchy().getDimension(), this.getLevelName());
        return string;
    }

    @Override
    public String getExternalName() {
        return DBStringUtils.externalizeName(this.getName());
    }
}

