/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.hierarchy.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import oracle.hcs.db.model.AbstractMappableSchemaObjectWithDesc;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.hierarchy.model.HierarchyAttribute;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.Internal;

public class Hierarchy
extends AbstractMappableSchemaObjectWithDesc {
    public static final String TYPE = "HIERARCHY";

    public Hierarchy() {
    }

    public Hierarchy(Schema schema, String string, String string2) {
        this.setName(string);
        this.setDimensionName(string2);
        this.setSchema(schema);
    }

    public String getType() {
        return TYPE;
    }

    public void setDimensionName(String string) {
        this.setProperty("dimensionName", string);
    }

    public String getDimensionName() {
        return (String)this.getProperty("dimensionName");
    }

    @Internal
    public void setDimension(AttributeDimension attributeDimension) {
        this.setProperty("dimension", attributeDimension);
    }

    @Internal
    public AttributeDimension getDimension() {
        return (AttributeDimension)this.getProperty("dimension");
    }

    public void addHierarchyLevel(HierarchyLevel hierarchyLevel) {
        this.getChildSupport("hierarchyLevels").addChild((Object)hierarchyLevel);
    }

    public HierarchyLevel[] getHierarchyLevels() {
        return (HierarchyLevel[])this.getChildSupport("hierarchyLevels").getChildArray(HierarchyLevel.class);
    }

    public void setHierarchyLevels(HierarchyLevel[] hierarchyLevelArray) {
        this.getChildSupport("hierarchyLevels").setChildArray((Object[])hierarchyLevelArray);
    }

    public HierarchyLevel findHierarchyLevel(String string) {
        HierarchyLevel[] hierarchyLevelArray;
        for (HierarchyLevel hierarchyLevel : hierarchyLevelArray = (HierarchyLevel[])this.getChildSupport("hierarchyLevels").getChildArray(HierarchyLevel.class)) {
            if (!hierarchyLevel.getName().equals(string)) continue;
            return hierarchyLevel;
        }
        return null;
    }

    public HierarchyLevel findHierarchyLevelForLevel(String string) {
        HierarchyLevel[] hierarchyLevelArray;
        for (HierarchyLevel hierarchyLevel : hierarchyLevelArray = (HierarchyLevel[])this.getChildSupport("hierarchyLevels").getChildArray(HierarchyLevel.class)) {
            if (!hierarchyLevel.getLevelName().equals(string)) continue;
            return hierarchyLevel;
        }
        return null;
    }

    public DimensionLevel findLevel(String string) {
        HierarchyLevel[] hierarchyLevelArray;
        for (HierarchyLevel hierarchyLevel : hierarchyLevelArray = (HierarchyLevel[])this.getChildSupport("hierarchyLevels").getChildArray(HierarchyLevel.class)) {
            if (!hierarchyLevel.getLevelName().equals(string)) continue;
            return hierarchyLevel.getLevel();
        }
        return null;
    }

    public HierarchyLevel[] getHierarchyLevelsReverse() {
        HierarchyLevel[] hierarchyLevelArray = (HierarchyLevel[])this.getChildSupport("hierarchyLevels").getChildArray(HierarchyLevel.class);
        List<HierarchyLevel> list = Arrays.asList(hierarchyLevelArray);
        ArrayList<HierarchyLevel> arrayList = new ArrayList<HierarchyLevel>();
        arrayList.addAll(list);
        Collections.reverse(arrayList);
        hierarchyLevelArray = arrayList.toArray(new HierarchyLevel[arrayList.size()]);
        return hierarchyLevelArray;
    }

    public void removeAllHierarchyLevels() {
        this.getChildSupport("hierarchyLevels").clearChildren();
    }

    public void removeHierarchyLevel(HierarchyLevel hierarchyLevel) {
        this.getChildSupport("hierarchyLevels").removeChild((Object)hierarchyLevel);
    }

    @Internal
    public boolean isLevelBased() {
        return true;
    }

    @Override
    public int getNotMappableCause() {
        return 0;
    }

    public HierarchyAttribute[] getHierarchyAttributes() {
        return (HierarchyAttribute[])this.getChildSupport("hierarchyAttributes").getChildArray(HierarchyAttribute.class);
    }

    public void setHierarchyAttributes(HierarchyAttribute[] hierarchyAttributeArray) {
        this.getChildSupport("hierarchyAttributes").setChildArray((Object[])hierarchyAttributeArray);
    }

    public void addHierAttribute(HierarchyAttribute hierarchyAttribute) {
        this.getChildSupport("hierarchyAttributes").addChild((Object)hierarchyAttribute);
    }

    public HierarchyAttribute findHierAttribute(String string) {
        HierarchyAttribute[] hierarchyAttributeArray;
        for (HierarchyAttribute hierarchyAttribute : hierarchyAttributeArray = (HierarchyAttribute[])this.getChildSupport("hierarchyAttributes").getChildArray(HierarchyAttribute.class)) {
            if (!hierarchyAttribute.getName().equals(string)) continue;
            return hierarchyAttribute;
        }
        return null;
    }
}

