/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.panels;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.hcs.HCSArb;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.db.model.DescriptionGenerator;
import oracle.hcs.db.panels.BaseChildTableEditorPanel;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.db.source.CompletionColumnMatchProvider;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.MapExpressionCellRenderer;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.model.DimensionLevel;
import oracle.hcs.dimension.model.OrderByClause;
import oracle.hcs.util.CompletionCellEditor;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.Ide;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.javatools.ui.completion.CompletionTextField;
import oracle.javatools.ui.table.GenericTable;

public class DimensionAttributeTableEditorPanel<C extends DimensionAttribute, P extends AttributeDimension>
extends BaseChildTableEditorPanel<C, P> {
    private final int USE_AS_LEVEL_COLUMN = 0;
    private final int ATTRIBUTE_NAME_COLUMN = 1;
    private final int MAP_EXPRESSION_COLUMN = 2;
    protected final int CAPTION_COLUMN = 3;
    protected final int DESCRIPTION_COLUMN = 4;
    protected final int LAST_COLUMN = 5;
    private CompletionColumnMatchProvider sourceCompletionProvider;
    private List<ColumnIdentifier> sourceColumns;
    private MyCellEditor myCellEditor;
    private boolean setupHandler;
    private static final Object OBJ_LOCK = new Object();
    private static boolean isPanelActive;
    private List<DimensionAttribute> toGenerate;
    private Map<String, DimensionAttribute> selectedAttributes;
    private DatabaseSource[] sources;
    private final String TO_CHAR = "TO_CHAR(\"%s\")";

    public DimensionAttributeTableEditorPanel() {
        super("DimensionAttributeTablePanel");
        this.getWrapperTable().setPreferredVisibleRowCount(7);
        this.init();
    }

    public DimensionAttributeTableEditorPanel(String string) {
        super(string);
        this.getWrapperTable().setPreferredVisibleRowCount(7);
        this.init();
    }

    @Override
    protected void init() {
        PropertyDisplayRegistry propertyDisplayRegistry = PropertyDisplayRegistry.getInstance();
        propertyDisplayRegistry.registerDisplayName("attributes", HCSArb.getString("DIMENSION_ATTRIBUTES"));
        this.selectedAttributes = new HashMap<String, DimensionAttribute>();
    }

    @Override
    protected void initialisePanel() {
        isPanelActive = true;
        this.initImpl(this.getProvider());
        super.initialisePanel();
        if (!this.setupHandler) {
            this.setupDimensionTypeChangeHandler();
            this.setupHandler = true;
        }
        this.toGenerate = new ArrayList<DimensionAttribute>();
        if (this.sources == null) {
            this.sources = ((AttributeDimension)this.getUpdatedObject()).getSources();
        } else if (!Arrays.equals(this.sources, ((AttributeDimension)this.getUpdatedObject()).getSources())) {
            this.sources = ((AttributeDimension)this.getUpdatedObject()).getSources();
            this.selectedAttributes.clear();
        }
        this.syncFromLevels();
    }

    protected void commitPanel() {
        try {
            isPanelActive = false;
            super.commitPanel();
            this.generateLevels();
        }
        catch (TraversalException traversalException) {
            // empty catch block
        }
    }

    private void setupDimensionTypeChangeHandler() {
        ((AttributeDimension)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void objectUpdated(DBObjectChange dBObjectChange) {
                Object object = OBJ_LOCK;
                synchronized (object) {
                    if (!isPanelActive) {
                        return;
                    }
                    if (!AttributeDimension.isDimTypeChangeEventActive()) {
                        return;
                    }
                    for (String string : dBObjectChange.getAllChangedProperties()) {
                        if (!string.equals("dimensionType")) continue;
                        DimensionAttributeTableEditorPanel.this.commitPanel();
                        AttributeDimension attributeDimension = (AttributeDimension)DimensionAttributeTableEditorPanel.this.getUpdatedObject();
                        String string2 = attributeDimension.getDimensionType();
                        if (string2 == null) {
                            attributeDimension.removeTimeAttributes();
                        }
                        DimensionAttributeTableEditorPanel.this.initialisePanel();
                    }
                }
            }
        });
    }

    protected String getChildProperty() {
        return "attributes";
    }

    protected Class getChildClass() {
        return DimensionAttribute.class;
    }

    protected ChildObjectEditorPanel createChildPanel() {
        return null;
    }

    @Override
    protected void initialiseComponents() {
        super.initialiseComponents();
        this.myCellEditor = new MyCellEditor();
        GenericTable genericTable = this.getWrapperTable();
        TableColumnModel tableColumnModel = genericTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(this.myCellEditor);
        TableColumn tableColumn2 = tableColumnModel.getColumn(4);
        tableColumn2.setCellEditor(this.myCellEditor);
        TableColumn tableColumn3 = tableColumnModel.getColumn(3);
        tableColumn3.setCellEditor(this.myCellEditor);
        this.sourceColumns = ((AttributeDimension)this.getUpdatedObject()).getSourceColumns();
        TableColumn tableColumn4 = tableColumnModel.getColumn(2);
        CompletionTextField completionTextField = new CompletionTextField();
        this.sourceCompletionProvider = new CompletionColumnMatchProvider(completionTextField.getPopupHandler().getInsightList(), this.sourceColumns);
        completionTextField.getPopupHandler().registerInsightProvider((CompletionProvider)this.sourceCompletionProvider);
        tableColumn4.setCellRenderer(new MapExpressionCellRenderer(string -> {
            for (ColumnIdentifier columnIdentifier : this.sourceColumns) {
                if (!columnIdentifier.getColumn().getName().equals(string)) continue;
                return columnIdentifier.getColumn();
            }
            return null;
        }));
        tableColumn4.setCellEditor(new CompletionCellEditor(completionTextField, this.sourceCompletionProvider));
    }

    @Override
    protected void initialiseTableComponents() {
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                DimensionAttributeTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                boolean bl = DimensionAttributeTableEditorPanel.this.selectedAttributes.containsKey(c.getName());
                return bl;
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic2 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                DimensionAttributeTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return DimensionAttributeTableEditorPanel.this.prov.getExternalName(c.getName());
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic3 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                DimensionAttributeTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((AbstractChildObjectWithDesc)c).getDescription();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic4 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                DimensionAttributeTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((AbstractChildObjectWithDesc)c).getCaption();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        this.addColumn(0, HCSArb.get("DIMENSION_ATTRIBUTE_USE_AS_LEVEL"), Boolean.class, nonPropertyColumnLogic);
        this.addColumn(1, HCSArb.get("NAMESPACE_CONFLICT_PANEL_NAME_LABEL"), String.class, nonPropertyColumnLogic2);
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic5 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                DimensionAttributeTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return DimensionAttributeTableEditorPanel.this.prov.getExternalName(((DimensionAttribute)c).getMapExpression());
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        this.addColumn(2, HCSArb.get("DIMENSION_ATTRIBUTE_SOURCE_EXPRESSION_COLUMN"), String.class, nonPropertyColumnLogic5);
        this.addColumn(3, HCSArb.get("DESCRIPTION_PANEL_SHORT_LABEL"), String.class, nonPropertyColumnLogic4);
        this.addColumn(4, HCSArb.get("DESCRIPTION_PANEL_DESCRIPTION"), String.class, nonPropertyColumnLogic3);
        final GenericTable genericTable = this.getWrapperTable();
        genericTable.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                genericTable.scrollRectToVisible(genericTable.getCellRect(genericTable.getSelectedRow(), 0, true));
            }
        });
    }

    @Override
    protected void setRowPropertyValue(Object object, int n, int n2) {
        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
        ChildTableEditorPanel.RowInfo rowInfo = componentWrapperTableModel.getRow(n);
        DimensionAttribute dimensionAttribute = (DimensionAttribute)rowInfo.getRowObject();
        switch (n2) {
            case 0: {
                Boolean bl = (Boolean)object;
                if (bl.booleanValue()) {
                    this.addForGenerate(dimensionAttribute);
                    break;
                }
                this.removeForGenerate(dimensionAttribute);
                break;
            }
            case 1: {
                String string = dimensionAttribute.getName();
                String string2 = (String)object;
                string2 = this.prov.getInternalName(string2);
                if (string2.equals(string)) break;
                dimensionAttribute.rename((AttributeDimension)this.getOriginalObject(), string2);
                if (this.upcaseNameFlag) {
                    this.updateNameToUppercase(string2.toUpperCase(), n, 1);
                    this.upcaseNameFlag = false;
                }
                this.updateAttributeName(dimensionAttribute, string);
                break;
            }
            case 3: {
                String string = (String)object;
                dimensionAttribute.setCaption(string);
                break;
            }
            case 4: {
                String string = (String)object;
                dimensionAttribute.setDescription(string);
                break;
            }
            case 2: {
                String string = (String)object;
                dimensionAttribute.setMapExpression(this.prov.getInternalName(string));
            }
        }
    }

    private void updateAttributeName(DimensionAttribute dimensionAttribute, String string) {
        if (string != null && !string.isEmpty()) {
            for (DimensionLevel dimensionLevel : ((AttributeDimension)this.getUpdatedObject()).getLevels()) {
                String objectArray = dimensionLevel.getLevelKey();
                if (!objectArray.equals(string)) continue;
                dimensionLevel.setLevelKey(dimensionAttribute.getName());
                break;
            }
            for (DimensionLevel dimensionLevel : ((AttributeDimension)this.getUpdatedObject()).getLevels()) {
                OrderByClause[] orderByClauseArray = dimensionLevel.getLevelOrderByClauses();
                String string2 = dimensionLevel.getLevelMemberName();
                String string3 = dimensionLevel.getLevelMemberCaption();
                String string4 = dimensionLevel.getLevelMemberDescription();
                String[] stringArray = dimensionLevel.getLevelAlternateKeys();
                for (OrderByClause orderByClause : orderByClauseArray) {
                    if (!orderByClause.getOrderByKey().equals(string)) continue;
                    orderByClause.setOrderByKey(dimensionAttribute.getName());
                }
                if (string2 != null && string2.equals(string)) {
                    dimensionLevel.setLevelMemberName(dimensionAttribute.getName());
                }
                if (string2 != null && string2.equals(String.format("TO_CHAR(\"%s\")", string))) {
                    dimensionLevel.setLevelMemberName(String.format("TO_CHAR(\"%s\")", dimensionAttribute.getName()));
                }
                if (string3 != null && string3.equals(string)) {
                    dimensionLevel.setLevelMemberCaption(dimensionAttribute.getName());
                }
                if (string4 != null && string4.equals(string)) {
                    dimensionLevel.setLevelMemberDescription(dimensionAttribute.getName());
                }
                if (stringArray == null || stringArray.length <= 0) continue;
                boolean bl = false;
                String[] stringArray2 = new String[stringArray.length];
                for (String string5 : stringArray) {
                    int n = 0;
                    String string6 = string5;
                    if (string5.equals(string)) {
                        bl = true;
                        string6 = dimensionAttribute.getName();
                    }
                    stringArray2[n] = string6;
                    ++n;
                }
                if (!bl) continue;
                dimensionLevel.setLevelAlternateKeys(stringArray2);
            }
            block4: for (DimensionLevel dimensionLevel : ((AttributeDimension)this.getUpdatedObject()).getLevels()) {
                for (String string4 : dimensionLevel.getLevelDeterminesKeys()) {
                    if (!string4.equals(string)) continue;
                    dimensionLevel.replaceLevelDeterminesKey(string, dimensionAttribute.getName());
                    continue block4;
                }
            }
            if (this.selectedAttributes.containsKey(string)) {
                this.selectedAttributes.remove(string);
                if (!this.selectedAttributes.containsKey(dimensionAttribute.getName())) {
                    this.selectedAttributes.put(dimensionAttribute.getName(), dimensionAttribute);
                }
            }
        }
    }

    @Override
    protected int getNameColumnIndex() {
        return 1;
    }

    @Override
    protected int getCaptionColumnIndex() {
        return 3;
    }

    @Override
    protected int getDescriptionColumnIndex() {
        return 4;
    }

    @Override
    public C newChild() {
        DimensionAttribute dimensionAttribute = (DimensionAttribute)super.newChild();
        dimensionAttribute.setNewObject();
        dimensionAttribute.setDataType("VARCHAR2(100)");
        dimensionAttribute.generateDescriptions();
        ((AttributeDimension)this.getUpdatedObject()).addAttribute(dimensionAttribute);
        return (C)dimensionAttribute;
    }

    private void addForGenerate(DimensionAttribute dimensionAttribute) {
        if (!this.toGenerate.contains(dimensionAttribute)) {
            this.toGenerate.add(dimensionAttribute);
        }
        if (!this.selectedAttributes.containsKey(dimensionAttribute.getName())) {
            this.selectedAttributes.put(dimensionAttribute.getName(), dimensionAttribute);
        }
    }

    private void removeForGenerate(DimensionAttribute dimensionAttribute) {
        if (this.toGenerate.contains(dimensionAttribute)) {
            this.toGenerate.remove(dimensionAttribute);
        }
        if (this.selectedAttributes.containsKey(dimensionAttribute.getName())) {
            this.selectedAttributes.remove(dimensionAttribute.getName());
        }
        block0: for (DimensionLevel dimensionLevel : ((AttributeDimension)this.getUpdatedObject()).getLevels()) {
            String[] stringArray;
            String string = dimensionLevel.getLevelKey();
            string = string.replaceAll("[()]", "");
            for (String string2 : stringArray = string.split(",")) {
                if (!string2.equals(dimensionAttribute.getName())) continue;
                ((AttributeDimension)this.getUpdatedObject()).removeLevel(dimensionLevel);
                continue block0;
            }
        }
    }

    private void generateLevels() {
        for (DimensionAttribute dimensionAttribute : this.toGenerate) {
            String string = dimensionAttribute.getName();
            int n = 0;
            String string2 = string;
            while (((AttributeDimension)this.getUpdatedObject()).findLevel(string2) != null) {
                string2 = string + Integer.toString(++n);
            }
            string = string2;
            DimensionLevel dimensionLevel = new DimensionLevel((AttributeDimension)this.getUpdatedObject(), string);
            dimensionLevel.setLevelKey(dimensionAttribute.getName());
            String string3 = DescriptionGenerator.generate(string);
            dimensionLevel.setCaption(string3);
            dimensionLevel.setDescription(string3);
            ((AttributeDimension)this.getUpdatedObject()).addLevel(dimensionLevel);
        }
        this.toGenerate.clear();
    }

    private void syncFromLevels() {
        for (DimensionLevel dimensionLevel : ((AttributeDimension)this.getUpdatedObject()).getLevels()) {
            String[] stringArray;
            DimensionLevel[] dimensionLevelArray = dimensionLevel.getLevelKey();
            dimensionLevelArray = dimensionLevelArray.replaceAll("[()]", "");
            block1: for (String stringArray2 : stringArray = dimensionLevelArray.split(",")) {
                for (DimensionAttribute dimensionAttribute : ((AttributeDimension)this.getUpdatedObject()).getAttributes()) {
                    if (!stringArray2.equals(dimensionAttribute.getName())) continue;
                    this.selectedAttributes.put(stringArray2, dimensionAttribute);
                    continue block1;
                }
            }
        }
        ArrayList arrayList = new ArrayList();
        for (String string : this.selectedAttributes.keySet()) {
            boolean bl = false;
            block4: for (DimensionLevel dimensionLevel : ((AttributeDimension)this.getUpdatedObject()).getLevels()) {
                String string2 = dimensionLevel.getLevelKey();
                string2 = string2.replaceAll("[()]", "");
                String[] stringArray = string2.split(",");
                for (String string3 : stringArray) {
                    if (!string.equals(string3)) continue;
                    bl = true;
                    continue block4;
                }
            }
            if (bl) continue;
            arrayList.add(string);
        }
        Iterator<String> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            this.selectedAttributes.remove(string);
        }
    }

    class MyCellEditor
    extends BaseChildTableEditorPanel.MyBaseCellEditor {
        @Override
        public boolean stopCellEditing() {
            TableColumnModel tableColumnModel = this.jtable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(this.column);
            int n = tableColumn.getModelIndex();
            if (n == 1) {
                boolean bl = false;
                boolean bl2 = true;
                String string = null;
                AttributeDimension attributeDimension = (AttributeDimension)this.abstractChildObjectWithDesc.getParent();
                String string2 = this.abstractChildObjectWithDesc.getName();
                String string3 = DimensionAttributeTableEditorPanel.this.prov.getExternalName(string2);
                String string4 = this.cellTextField.getText();
                String string5 = UIStringUtils.normalizeName(string4, DimensionAttributeTableEditorPanel.this.prov);
                String string6 = DimensionAttributeTableEditorPanel.this.prov.getInternalName(string5);
                bl = UIStringUtils.isQuotedName(string5);
                if (string5 == null || string5.length() == 0) {
                    bl2 = false;
                    string = HCSArb.getString("DIMENSION_ATTRIBUTE_NAME_VALIDATION_ERROR_MSG");
                } else {
                    try {
                        DimensionAttributeTableEditorPanel.this.prov.validateName("DIMENSION ATTRIBUTE", string5);
                    }
                    catch (InvalidNameException invalidNameException) {
                        string = invalidNameException.getMessage();
                        bl2 = false;
                    }
                }
                if (bl2) {
                    String string7 = string5;
                    if (attributeDimension.findAttribute(string6) != null && !string7.equals(string3)) {
                        string = HCSArb.format("VALIDATION_ERROR_DUPLICATE_ATTRIBUTE_NAME_MSG", string7);
                        bl2 = false;
                    } else if (!DimensionAttributeTableEditorPanel.this.isEditing()) {
                        ((DimensionAttribute)this.abstractChildObjectWithDesc).setOriginalAttributeName(string6);
                    } else if (this.abstractChildObjectWithDesc.isNewObject()) {
                        ((DimensionAttribute)this.abstractChildObjectWithDesc).setOriginalAttributeName(string6);
                    }
                }
                if (!bl2) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)HCSArb.get("DIMENSION_ATTRIBUTE_NAME_VALIDATION_ERROR_MSG"), null);
                    this.cellTextField.setText(string3);
                    return bl2;
                }
                if (!bl) {
                    DimensionAttributeTableEditorPanel.this.upcaseNameFlag = true;
                } else {
                    DimensionAttributeTableEditorPanel.this.upcaseNameFlag = false;
                }
            }
            return super.stopCellEditing();
        }
    }
}

