/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import oracle.hcs.HCSArb;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.ChildNameObjectEditorContext;
import oracle.hcs.db.panels.ChildObjectEditorPanel2;
import oracle.hcs.dimension.DimensionRemoveChildDispatcher;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.diff.DBObjectComparator;

public class DimensionAttributeObjectEditorPanel<T extends DimensionAttribute, P extends AttributeDimension>
extends ChildObjectEditorPanel2<T, P> {
    private JLabel lblName;
    private DBObjectProvider prov;
    private JLabel roleLabel;
    private JComboBox roleComboBox;
    private DefaultComboBoxModel roleComboBoxModel;
    private boolean isInitializing;
    private TreeSet<DimensionAttribute> invalidAttributes = new TreeSet(new DBObjectComparator());

    public DimensionAttributeObjectEditorPanel() {
        super(DimensionAttributeObjectEditorPanel.class.getName(), "DIMENSION ATTRIBUTE");
        this.layoutComponents();
        DimensionRemoveChildDispatcher dimensionRemoveChildDispatcher = DimensionRemoveChildDispatcher.getInstance();
        dimensionRemoveChildDispatcher.registerObserver(this);
    }

    private void initFromAttributeData(DimensionAttribute dimensionAttribute) {
        if (this.getChildObject() == null) {
            this.getNameField().setText("");
            this.lblName.setEnabled(false);
            this.getNameField().setEnabled(false);
        } else {
            AttributeDimension attributeDimension = dimensionAttribute.getDimension();
            String string = ((DimensionAttribute)this.getChildObject()).getName();
            if (!this.invalidAttributes.contains(this.getChildObject())) {
                // empty if block
            }
            ChildNameObjectEditorContext childNameObjectEditorContext = ChildNameObjectEditorContext.getInstance();
            childNameObjectEditorContext.setEditingState(1);
            this.getNameField().setText(string);
            this.getNameField().setEnabled(true);
            childNameObjectEditorContext.setEditingState(0);
            this.isInitializing = true;
            this.loadRoleComboBox(attributeDimension);
            this.isInitializing = false;
            String string2 = dimensionAttribute.getRole();
            String string3 = this.getRoleComboBoxSelection(string2);
            if (dimensionAttribute.getPersistedOrSpecial()) {
                this.enableRoleComboBox(false);
            } else {
                this.enableRoleComboBox(true);
            }
            this.roleComboBox.setSelectedItem(string3);
            String string4 = ((DimensionAttribute)this.getChildObject()).getDataType();
        }
        this.validate();
        this.repaint();
    }

    private void loadRoleComboBox(AttributeDimension attributeDimension) {
        this.roleComboBoxModel.removeAllElements();
        this.roleComboBoxModel.addElement(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_USER"));
        this.roleComboBoxModel.addElement(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_MEMBER_LONG"));
        this.roleComboBoxModel.addElement(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_MEMBER_SHORT"));
        if (attributeDimension.getDimensionType() != null && attributeDimension.getDimensionType().equalsIgnoreCase("TIME")) {
            this.roleComboBoxModel.addElement(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_END_DATE"));
            this.roleComboBoxModel.addElement(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_TIME_SPAN"));
        }
    }

    private String getRoleComboBoxSelection(String string) {
        String string2 = null;
        if (string == null || string.length() == 0) {
            string = "USER";
        }
        string2 = string.equalsIgnoreCase("LONG_DESCRIPTION") ? HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_MEMBER_LONG") : (string.equalsIgnoreCase("SHORT_DESCRIPTION") ? HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_MEMBER_SHORT") : (string.equalsIgnoreCase("END_DATE") ? HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_END_DATE") : (string.equalsIgnoreCase("TIME_SPAN") ? HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_TIME_SPAN") : HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_USER"))));
        return string2;
    }

    private String getRoleComboBoxInternalSelection() {
        String string = null;
        String string2 = (String)this.roleComboBox.getSelectedItem();
        string = string2.equalsIgnoreCase(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_MEMBER_LONG")) ? "LONG_DESCRIPTION" : (string2.equalsIgnoreCase(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_MEMBER_SHORT")) ? "SHORT_DESCRIPTION" : (string2.equalsIgnoreCase(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_END_DATE")) ? "END_DATE" : (string2.equalsIgnoreCase(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_TIME_SPAN")) ? "TIME_SPAN" : "USER")));
        return string;
    }

    private void enableRoleComboBox(boolean bl) {
        this.roleLabel.setEnabled(bl);
        this.roleComboBox.setEnabled(bl);
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        super.initialisePanel();
        this.initFromAttribute((DimensionAttribute)this.getChildObject());
    }

    public void commit(DimensionAttribute dimensionAttribute) throws TraversalException {
        if (this.invalidAttributes.contains(dimensionAttribute)) {
            this.invalidAttributes.remove(dimensionAttribute);
        }
    }

    public void initFromAttribute(DimensionAttribute dimensionAttribute) {
        this.initFromAttributeData(dimensionAttribute);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        DimensionAttribute dimensionAttribute = (DimensionAttribute)this.getChildObject();
        this.commit(dimensionAttribute);
        AttributeDimension attributeDimension = dimensionAttribute.getDimension();
        if (attributeDimension.findAttribute(dimensionAttribute.getName()) == null) {
            attributeDimension.addAttribute(dimensionAttribute);
        }
    }

    private void layoutComponents() {
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"attributes"});
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JSplitPane jSplitPane = new JSplitPane();
        JLabel jLabel = new JLabel(HCSArb.getString("DIMENSION_ATTRIBUTE_APPLY_TO_LABEL"));
        jLabel.setName("visibilityLabel");
        this.lblName = new JLabel();
        this.lblName.setName("lblName");
        componentFactory.registerComponent(this.lblName, (Component)this.getNameField(), UIBundle.get((String)"COLUMN_INFO_LABEL_NAME"), "name", "name");
        this.roleLabel = new JLabel(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_LABEL"));
        this.roleLabel.setName("roleLabel");
        this.roleComboBoxModel = new DefaultComboBoxModel();
        this.roleComboBox = new JComboBox(this.roleComboBoxModel);
        this.roleComboBox.setName("roleComboBox");
        this.getNameField().setColumns(30);
        this.roleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!DimensionAttributeObjectEditorPanel.this.isInitializing) {
                    DimensionAttribute dimensionAttribute = (DimensionAttribute)DimensionAttributeObjectEditorPanel.this.getChildObject();
                    String string = (String)DimensionAttributeObjectEditorPanel.this.roleComboBox.getSelectedItem();
                    String string2 = "USER";
                    if (string.equalsIgnoreCase(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_MEMBER_LONG"))) {
                        string2 = "LONG_DESCRIPTION";
                    } else if (string.equalsIgnoreCase(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_MEMBER_SHORT"))) {
                        string2 = "SHORT_DESCRIPTION";
                    } else if (string.equalsIgnoreCase(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_END_DATE"))) {
                        string2 = "END_DATE";
                    } else if (string.equalsIgnoreCase(HCSArb.getString("DIMENSION_ATTRIBUTE_ROLE_TIME_SPAN"))) {
                        string2 = "TIME_SPAN";
                    }
                    dimensionAttribute.setRole(string2);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(HCSArb.getString("DIMENSION_ATTRIBUTE_PROPERTIES_BORDER_LABEL")));
        jPanel.add((Component)this.roleLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        jPanel.add((Component)this.roleComboBox, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        int n = 0;
        jPanel.add((Component)new JPanel(), new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 17, 2, new Insets(5, 5, 0, 12), 0, 0));
        n = 0;
        jSplitPane.setOrientation(1);
        jSplitPane.setDividerLocation(0.4);
        jSplitPane.setLeftComponent(jPanel);
        jSplitPane.setRightComponent(jPanel2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(jSplitPane, gridBagConstraints);
    }

    @Override
    public void processRemoveChildEvent(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
        AttributeDimension attributeDimension;
        if (abstractSchemaObjectWithDesc instanceof AttributeDimension && (attributeDimension = (AttributeDimension)abstractSchemaObjectWithDesc).getAttributes().length == 0) {
            this.enableDescriptions(false);
        }
    }

    protected void validateObject() throws TraversalException {
    }
}

