/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.panels;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.hcs.HCSImagesArb;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.dimension.model.DimensionAttribute;
import oracle.hcs.dimension.panels.AttributeMatchFilter;
import oracle.hcs.util.CompletionProviderWithFilter;
import oracle.hcs.util.ListSeparatorsRenderer;

public class CompletionAttributeMatchProvider
implements CompletionProviderWithFilter<DimensionAttribute> {
    private List<DimensionAttribute> attributes = new ArrayList<DimensionAttribute>();
    private boolean filter = true;
    private final ListCellRenderer renderer;
    private AttributeMatchFilter attributeMatchFilter;

    public CompletionAttributeMatchProvider(JList jList, Collection<DimensionAttribute> collection) {
        this(jList);
        this.attributes.addAll(collection);
    }

    public CompletionAttributeMatchProvider(JComponent jComponent, Collection<DimensionAttribute> collection) {
        this((JList)jComponent);
        this.attributes.addAll(collection);
    }

    public CompletionAttributeMatchProvider(JList jList) {
        this.renderer = new ListSeparatorsRenderer(jList.getCellRenderer()){

            @Override
            protected boolean addSeparatorAfter(JList jList, Object object, int n) {
                Object object2 = null;
                if (n + 1 < jList.getModel().getSize()) {
                    object2 = jList.getModel().getElementAt(n + 1);
                }
                if (object2 != null) {
                    IdentifierElement identifierElement = new IdentifierElement(object2.toString());
                    IdentifierElement identifierElement2 = new IdentifierElement(object.toString());
                    if (identifierElement.getCount() == 2 && identifierElement2.getCount() == 2) {
                        boolean bl = identifierElement.getFirst().equals(identifierElement2.getFirst());
                        return !bl;
                    }
                }
                return false;
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent(jList, object, n, bl, bl2);
                if (component instanceof JLabel && object instanceof ColumnIdentifier) {
                    JLabel jLabel = (JLabel)component;
                    ColumnIdentifier columnIdentifier = (ColumnIdentifier)object;
                    if (columnIdentifier.getColumn().isDate()) {
                        jLabel.setIcon(HCSImagesArb.getIcon("DATATYPE_DATE"));
                    }
                    if (columnIdentifier.getColumn().isNumeric()) {
                        jLabel.setIcon(HCSImagesArb.getIcon("DATATYPE_NUMBER"));
                    }
                    if (columnIdentifier.getColumn().isString()) {
                        jLabel.setIcon(HCSImagesArb.getIcon("DATATYPE_STRING"));
                    }
                }
                return component;
            }
        };
    }

    public void setStrings(Collection<DimensionAttribute> collection) {
        this.filter = true;
        this.attributes.clear();
        this.attributes.addAll(collection);
    }

    @Override
    public void setFilter(boolean bl) {
        this.filter = bl;
    }

    public ListCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public boolean handlesInsight(Document document, int n) {
        return true;
    }

    public void setAttributeMatchFilter(AttributeMatchFilter attributeMatchFilter) {
        this.attributeMatchFilter = attributeMatchFilter;
    }

    public DimensionAttribute[] getInsightData(Document document, int n) {
        ArrayList<DimensionAttribute> arrayList = new ArrayList<DimensionAttribute>();
        try {
            String string = document.getText(0, n).toLowerCase();
            if (string.trim().length() == 0) {
                this.filter = false;
            }
            for (DimensionAttribute dimensionAttribute : this.attributes) {
                String string2 = dimensionAttribute.getExternalName();
                if (string2 == null) {
                    string2 = dimensionAttribute.getName();
                }
                if (this.filter) {
                    int n2 = string2.toLowerCase().indexOf(string.toLowerCase());
                    if (n2 < 0) continue;
                    if (this.attributeMatchFilter != null) {
                        if (this.attributeMatchFilter.filter(dimensionAttribute)) continue;
                        arrayList.add(dimensionAttribute);
                        continue;
                    }
                    arrayList.add(dimensionAttribute);
                    continue;
                }
                if (this.attributeMatchFilter == null || this.attributeMatchFilter.filter(dimensionAttribute)) continue;
                arrayList.add(dimensionAttribute);
            }
            if (arrayList.size() == 1) {
                DimensionAttribute dimensionAttribute = (DimensionAttribute)arrayList.get(0);
                if (this.attributeMatchFilter != null && !this.attributeMatchFilter.filter(dimensionAttribute) && ((DimensionAttribute)arrayList.get(0)).getExternalName().equalsIgnoreCase(string)) {
                    arrayList.clear();
                    arrayList.addAll(this.attributes);
                }
            }
            if (arrayList.size() == 0) {
                arrayList.addAll(this.attributes);
            }
            this.filter = true;
        }
        catch (BadLocationException badLocationException) {
            return new DimensionAttribute[0];
        }
        return arrayList.toArray(new DimensionAttribute[arrayList.size()]);
    }

    public void completeInsight(Document document, int n, DimensionAttribute dimensionAttribute) {
        try {
            document.remove(0, document.getLength());
            document.insertString(0, dimensionAttribute.getExternalName(), null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public boolean isAutoPopupChar(char c) {
        return true;
    }
}

