/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension.model;

import oracle.hcs.db.model.DataTypeProperty;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.model.DimensionAttributeMap;
import oracle.hcs.dimension.model.DimensionMap;
import oracle.hcs.dimension.model.DimensionedObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Internal;

public class DimensionAttribute
extends DimensionedObject
implements DataTypeProperty {
    public static final String TYPE = "DIMENSION ATTRIBUTE";
    public static final String LONG_DESCRIPTION = "LONG_DESCRIPTION";
    public static final String SHORT_DESCRIPTION = "SHORT_DESCRIPTION";
    public static final String END_DATE = "END_DATE";
    public static final String TIME_SPAN = "TIME_SPAN";
    public static final String USER_ATTRIBUTE = "USER";
    private String externalName;

    public DimensionAttribute() {
        this.setDataType("VARCHAR2(100)");
        this.setRole(USER_ATTRIBUTE);
        this.setPersistedOrSpecial(false);
    }

    public DimensionAttribute(String string) {
        super(string);
        this.setDataType("VARCHAR2(100)");
        this.setRole(USER_ATTRIBUTE);
        this.setPersistedOrSpecial(false);
        this.setOriginalAttributeName(string);
    }

    public DimensionAttribute(String string, String string2, String string3) {
        super(string);
        this.setDataType("VARCHAR2(100)");
        this.setRole(string2);
        this.setPersistedOrSpecial(false);
        this.setOriginalAttributeName(string);
        this.setDescription(string3);
    }

    public String getType() {
        return TYPE;
    }

    public void setPersistedOrSpecial(boolean bl) {
        this.setProperty("persistedOrSpecial", bl);
    }

    public boolean getPersistedOrSpecial() {
        boolean bl = (Boolean)this.getProperty("persistedOrSpecial");
        return bl;
    }

    public void setRole(String string) {
        if (string == null) {
            string = USER_ATTRIBUTE;
        }
        this.setProperty("attributeType", string);
        if (string.equals(END_DATE)) {
            this.setDataType("DATE");
        }
        if (string.equals(TIME_SPAN)) {
            this.setDataType("NUMBER");
        }
    }

    public String getRole() {
        return (String)this.getProperty("attributeType");
    }

    public boolean isDescriptionRole() {
        return this.getRole().equals(LONG_DESCRIPTION) || this.getRole().equals(SHORT_DESCRIPTION);
    }

    public void setLanguage(String string) {
        this.setProperty("attributeLanguage", string);
    }

    public String getLanguage() {
        return (String)this.getProperty("attributeLanguage");
    }

    public void setNls(boolean bl) {
        this.setProperty("nls", bl);
    }

    public boolean isNls() {
        Boolean bl = (Boolean)this.getProperty("nls");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void setOriginalAttributeName(String string) {
        this.setProperty("originalAttributeName", string);
    }

    public String getOriginalAttributeName() {
        return (String)this.getProperty("originalAttributeName");
    }

    @Override
    public void setDataType(String string) {
        this.setProperty("dataType", string);
    }

    @Override
    public String getDataType() {
        return (String)this.getProperty("dataType");
    }

    public void rename(AttributeDimension attributeDimension, String string) {
        String string2 = this.getName();
        DimensionMap dimensionMap = this.getDimension().getMap();
        this.setAttributeMapNameAndOriginal(dimensionMap, string2, string);
        if (attributeDimension != null) {
            dimensionMap = attributeDimension.getMap();
            this.setAttributeMapName(dimensionMap, string2, string);
        }
        this.setName(string);
        if (!this.getPersistedOrSpecial()) {
            this.setOriginalAttributeName(string);
        }
    }

    private void setAttributeMapNameAndOriginal(DimensionMap dimensionMap, String string, String string2) {
        if (dimensionMap != null) {
            for (DimensionAttributeMap dimensionAttributeMap : dimensionMap.getAttributeMaps()) {
                if (!dimensionAttributeMap.getMapAttribute().equals(string)) continue;
                dimensionAttributeMap.setMapAttributeAndOriginal(string2);
            }
        }
    }

    private void setAttributeMapName(DimensionMap dimensionMap, String string, String string2) {
        if (dimensionMap != null) {
            for (DimensionAttributeMap dimensionAttributeMap : dimensionMap.getAttributeMaps()) {
                if (!dimensionAttributeMap.getMapAttribute().equals(string)) continue;
                dimensionAttributeMap.setMapAttribute(string2);
            }
        }
    }

    public void setName(String string) {
        super.setName(string);
        String string2 = this.getOriginalAttributeName();
        if (string2 == null) {
            this.setOriginalAttributeName(string);
        }
    }

    public void setParent(DBObject dBObject) {
        if (dBObject instanceof AttributeDimension) {
            super.setParent(dBObject);
        }
    }

    public void setMapExpression(String string) {
        this.setProperty("mapExpression", string);
    }

    public String getMapExpression() {
        return (String)this.getProperty("mapExpression");
    }

    @Internal
    public void setExternalName(String string) {
        this.externalName = string;
    }

    @Override
    @Internal
    public String getExternalName() {
        return this.externalName;
    }

    public String toString() {
        String string = this.getExternalName();
        if (string != null) {
            return string;
        }
        return super.toString();
    }
}

