/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.hcs.HCSArb;
import oracle.hcs.db.panels.HCSPanel;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;

public class DimensionTypePanel
extends HCSPanel<AttributeDimension>
implements ItemListener {
    private JLabel dimensionTypeLabel = new JLabel(HCSArb.getString("DIMENSION_TYPE_LABEL"));
    private JRadioButton standardDimensionRadioButton = new JRadioButton(HCSArb.getString("DIMENSION_TYPE_STANDARD"));
    private JRadioButton timeDimensionRadioButton = new JRadioButton(HCSArb.getString("DIMENSION_TYPE_TIME"));
    private boolean initialized = false;
    private boolean radioButtonSelected = false;

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource().getClass().equals(JRadioButton.class)) {
            this.radioButtonSelected = true;
            this.setDimensionType();
            AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        }
    }

    private void setDimensionType() {
        String string = "STANDARD";
        if (this.timeDimensionRadioButton.isSelected()) {
            string = "TIME";
        }
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        attributeDimension.setDimensionType(string);
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.standardDimensionRadioButton.removeItemListener(this);
        this.timeDimensionRadioButton.removeItemListener(this);
        AttributeDimension attributeDimension = (AttributeDimension)this.getUpdatedObject();
        String string = attributeDimension.getDimensionType();
        if (string == null || string != null && string.equalsIgnoreCase("STANDARD")) {
            this.standardDimensionRadioButton.setSelected(true);
        } else if (string.equalsIgnoreCase("TIME")) {
            this.timeDimensionRadioButton.setSelected(true);
        }
        this.standardDimensionRadioButton.addItemListener(this);
        this.timeDimensionRadioButton.addItemListener(this);
        if (!this.initialized) {
            this.initialized = true;
            ((AttributeDimension)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    if (DimensionTypePanel.this.radioButtonSelected) {
                        return;
                    }
                    Map map = dBObjectChange.getPropertiesChanged();
                    for (String string : map.keySet()) {
                        String string2;
                        String string3;
                        if (!string.equals("name") || DimensionTypePanel.this.getUpdatedObject() == null || (string3 = ((AttributeDimension)DimensionTypePanel.this.getUpdatedObject()).getName()) == null || string3.length() <= 0 || !(string3 = string3.toUpperCase()).startsWith(string2 = HCSArb.getString("DIMENSION_NAME_FOR_TIME").toUpperCase())) continue;
                        DimensionTypePanel.this.timeDimensionRadioButton.setSelected(true);
                        DimensionTypePanel.this.setDimensionType();
                    }
                }
            });
        }
    }

    private void disableDimensionTypeRadioButtons() {
        this.standardDimensionRadioButton.setEnabled(false);
        this.timeDimensionRadioButton.setEnabled(false);
    }

    @Override
    protected void layoutComponents(DBUILayoutHelper dBUILayoutHelper) {
        super.layoutComponents(dBUILayoutHelper);
        dBUILayoutHelper.nextRow();
        this.standardDimensionRadioButton.addItemListener(this);
        this.timeDimensionRadioButton.addItemListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.standardDimensionRadioButton);
        buttonGroup.add(this.timeDimensionRadioButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.standardDimensionRadioButton);
        jPanel.add(this.timeDimensionRadioButton);
        dBUILayoutHelper.add((Component)this.dimensionTypeLabel, 1, 1, false, true);
        dBUILayoutHelper.add((Component)jPanel, 1, 1, false, true);
    }
}

