/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.dimension;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import oracle.hcs.HCSArb;
import oracle.hcs.db.BasePanelLibrary;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.AttributeDimensionDDLPanel;
import oracle.hcs.db.panels.HCSObjectDependenciesGenerator;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.dimension.DimensionTypePanel;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.dimension.panels.DimensionAttributeTableEditorPanel;
import oracle.hcs.dimension.panels.DimensionDescriptionPanel;
import oracle.hcs.dimension.panels.DimensionGeneralPanel;
import oracle.hcs.dimension.panels.DimensionLevelDeterminesTableEditorPanel;
import oracle.hcs.dimension.panels.DimensionLevelTableEditorPanel;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.Traversable;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class DimensionPanelLibrary
extends BasePanelLibrary {
    private static final String GENERAL = HCSArb.get("GENERAL.TITLE");
    private static final String LEVELS = HCSArb.get("LEVELS.TITLE");
    private static final String HIERARCHIES = HCSArb.get("HIERARCHIES_TITLE");
    private static final String ATTRIBUTES = HCSArb.get("ATTRIBUTES_TITLE");
    private static final String STORAGE = HCSArb.get("STORAGE.TITLE");
    private static final String DESCRIPTION = HCSArb.get("DESCRIPTIONS.TITLE");
    private static final String DETERMINES = HCSArb.get("DETERMINES_TITLE");
    private static final String MAP = HCSArb.get("MAP.TITLE");

    public DimensionPanelLibrary() {
        super("ATTRIBUTE DIMENSION");
        this.addPanel(GENERAL, DimensionGeneralPanel.class, "av_create_attr_dim_general", new String[0]);
        Navigable navigable = this.addPanel(ATTRIBUTES, DimensionAttributeTableEditorPanel.class, "av_create_attr_dim_attributes", new String[0]);
        navigable = this.addPanel(LEVELS, DimensionLevelTableEditorPanel.class, "av_create_attr_dim_levels", new String[0]);
        navigable = this.addPanel(DETERMINES, DimensionLevelDeterminesTableEditorPanel.class, "av_attr_dim_level_determines", new String[0]);
        navigable = this.addPanel(DESCRIPTION, DimensionDescriptionPanel.class, "av_create_attr_dim_descriptions", new String[0]);
    }

    @Override
    protected Class<? extends Traversable> getDDLPanel() {
        return AttributeDimensionDDLPanel.class;
    }

    protected List<String> getTitles(DBObject dBObject, DBObjectProvider dBObjectProvider, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(GENERAL);
        arrayList.add(ATTRIBUTES);
        arrayList.add(LEVELS);
        arrayList.add(DETERMINES);
        arrayList.add(DESCRIPTION);
        return arrayList;
    }

    protected List<String> getSimpleTitles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(GENERAL);
        arrayList.add(ATTRIBUTES);
        arrayList.add(LEVELS);
        arrayList.add(DETERMINES);
        arrayList.add(DESCRIPTION);
        return null;
    }

    public String getCreateTitle() {
        return HCSArb.get("DIMENSION_CREATE_TITLE");
    }

    public String getEditTitle() {
        return HCSArb.get("DIMENSION_EDIT_TITLE");
    }

    public boolean canEditObject(DBObject dBObject, DBObjectProvider dBObjectProvider) {
        return true;
    }

    public Class<? extends Traversable> getHeader() {
        return DimensionTypePanel.class;
    }

    public Dimension getSize(boolean bl) {
        Dimension dimension = new Dimension(800, 600);
        return dimension;
    }

    public Navigable getDDLNavigable() {
        Navigable navigable = super.getDDLNavigable();
        navigable.setHelpID("av_create_attr_dim_ddl");
        return navigable;
    }

    @Override
    protected HCSSyntaxType getObjectType() {
        return HCSSyntaxType.DIMENSION;
    }

    @Override
    protected void addMetadataChanges(SystemObject systemObject, Difference difference, List<MetadataChange> list) {
        this.addMetadataChanges(systemObject, "attributes", difference, list, HCSSyntaxType.ATTRIBUTE);
        this.addMetadataChanges(systemObject, "levels", difference, list, HCSSyntaxType.LEVEL);
    }

    @Override
    protected boolean containsChanges(List<MetadataChange> list, HCSSyntaxType hCSSyntaxType) {
        boolean bl = false;
        for (MetadataChange metadataChange : list) {
            if (!metadataChange.getObjectType().equals((Object)hCSSyntaxType) || hCSSyntaxType.equals((Object)HCSSyntaxType.ATTRIBUTE) || hCSSyntaxType.equals((Object)HCSSyntaxType.LEVEL)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    protected void addParentObjectChanges(SystemObject systemObject, SystemObject systemObject2, List<MetadataChange> list) {
        super.addParentObjectChanges(systemObject, systemObject2, list);
        AttributeDimension attributeDimension = (AttributeDimension)systemObject;
        AttributeDimension attributeDimension2 = (AttributeDimension)systemObject2;
        String string = attributeDimension.getAllMemberName();
        String string2 = attributeDimension2.getAllMemberName();
        String string3 = attributeDimension.getAllMemberCaption();
        String string4 = attributeDimension2.getAllMemberCaption();
        String string5 = attributeDimension.getAllMemberDescription();
        String string6 = attributeDimension2.getAllMemberDescription();
        if (string == null && string2 != null || string2 != null && !string.equals(string2) || string3 == null && string4 != null || string4 != null && !string3.equals(string4) || string5 == null && string6 != null || string6 != null && !string5.equals(string6)) {
            list.add(new MetadataChange(systemObject2.getName(), systemObject2.getName(), this.getObjectType()));
        }
    }

    @Override
    public void commitToProvider(DBEditorConfig dBEditorConfig) {
        AttributeDimension attributeDimension = (AttributeDimension)dBEditorConfig.getUpdatedObject();
        boolean bl = attributeDimension.isForceCreate();
        if (!bl && !this.isSourceValid(dBEditorConfig)) {
            this.showErrorMessage(HCSArb.format("VALIDATION_ERROR_INVALID_SOURCE_TABLE", this.getType()), HCSArb.getString("VALIDATION_ERROR_DIMENSION_INVALID_SOURCE_TABLE"));
            return;
        }
        if (attributeDimension.getLevels().length == 0) {
            this.showErrorMessage(LEVELS, HCSArb.getString("VALIDATION_ERROR_NO_LEVELS"));
            return;
        }
        super.commitToProvider(dBEditorConfig);
    }

    @Override
    protected List<AbstractSchemaObjectWithDesc> getDependencies(String string, OracleDatabaseImpl oracleDatabaseImpl, String string2) {
        return HCSObjectDependenciesGenerator.getDimensionDependencies(string, oracleDatabaseImpl, string2);
    }

    @Override
    protected String getSourceQualifiedName(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
        AttributeDimension attributeDimension = (AttributeDimension)abstractSchemaObjectWithDesc;
        DatabaseSource[] databaseSourceArray = attributeDimension.getSources();
        if (databaseSourceArray != null) {
            return databaseSourceArray[0].getQualifiedName();
        }
        return "";
    }
}

