/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.hcs.HCSArb;
import oracle.hcs.db.view.DescriptionPanel;
import oracle.hcs.db.view.EditDescriptionDialog;
import oracle.hcs.util.UIUtilities;
import oracle.ide.Ide;
import oracle.javatools.icons.OracleIcons;

class MyTableCellEditorComponent
extends JPanel {
    private int row;
    private JTextField textField;
    private JButton editorButton;
    private String origValue;
    private DescriptionPanel descPanel;
    private int col;

    public MyTableCellEditorComponent(final DescriptionPanel descriptionPanel) {
        this.descPanel = descriptionPanel;
        this.textField = new JTextField();
        this.editorButton = new JButton(OracleIcons.getIcon((String)"edit.png"));
        this.origValue = "";
        this.textField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = MyTableCellEditorComponent.this.textField.getText();
                if (MyTableCellEditorComponent.this.col >= 2 && string != null && !string.equalsIgnoreCase(MyTableCellEditorComponent.this.origValue)) {
                    descriptionPanel.setLanguageDescriptionsModified(true);
                }
                if (MyTableCellEditorComponent.this.col == 1) {
                    if (MyTableCellEditorComponent.this.row == 2 && string != null && !string.equalsIgnoreCase(MyTableCellEditorComponent.this.origValue)) {
                        descriptionPanel.setParentObjectDescriptionModified(true);
                    }
                    if (MyTableCellEditorComponent.this.row == 1 && string != null && !string.equalsIgnoreCase(MyTableCellEditorComponent.this.origValue)) {
                        descriptionPanel.setParentObjectCaptionModified(true);
                    }
                }
            }
        });
        this.jbInit();
    }

    public void setCol(int n) {
        this.col = n;
    }

    public void setRow(int n) {
        this.row = n;
    }

    public String getText() {
        return this.textField.getText();
    }

    public void setText(String string) {
        this.origValue = string;
        this.textField.setText(string);
    }

    public JTextField getTextField() {
        return this.textField;
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.textField, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.editorButton, gridBagConstraints);
        this.editorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = null;
                String string2 = null;
                String string3 = MyTableCellEditorComponent.this.descPanel.getJTreeTableCellValue(MyTableCellEditorComponent.this.row);
                if (string3.contains("caption")) {
                    string = HCSArb.format("DESCRIPTION_PANEL_EDIT_DESC_TITLE", HCSArb.getString("DESCRIPTION_PANEL_SHORT_LABEL"));
                    string2 = HCSArb.getString("DESCRIPTION_PANEL_SHORT_LABEL");
                } else if (string3.contains("longDescription")) {
                    string = HCSArb.format("DESCRIPTION_PANEL_EDIT_DESC_TITLE", HCSArb.getString("DESCRIPTION_PANEL_LONG_LABEL"));
                    string2 = HCSArb.getString("DESCRIPTION_PANEL_LONG_LABEL");
                } else {
                    string = HCSArb.format("DESCRIPTION_PANEL_EDIT_DESC_TITLE", HCSArb.getString("DESCRIPTION_PANEL_DESCRIPTION"));
                    string2 = HCSArb.getString("DESCRIPTION_PANEL_DESCRIPTION");
                }
                String string4 = MyTableCellEditorComponent.this.getText();
                EditDescriptionDialog editDescriptionDialog = new EditDescriptionDialog(MyTableCellEditorComponent.this.descPanel, string2, string4);
                Rectangle rectangle = UIUtilities.centerWindow((Component)Ide.getMainWindow(), 500, 150);
                editDescriptionDialog.setBounds(rectangle);
                editDescriptionDialog.setModal(true);
                editDescriptionDialog.setTitle(string);
                editDescriptionDialog.setVisible(true);
                if (MyTableCellEditorComponent.this.descPanel.getEditOperationResult() == 1) {
                    MyTableCellEditorComponent.this.textField.setText(MyTableCellEditorComponent.this.descPanel.getEditDescriptionText());
                }
            }
        });
    }
}

