/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.panels;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AVCacheMeasureGroup;
import oracle.hcs.db.BasePanelLibrary;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.GeneralBaseEditorPanel;
import oracle.hcs.db.panels.GeneralBaseEditorPanelContext;
import oracle.hcs.db.panels.HCSPanelReference;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.components.ComponentWrapper;
import oracle.ide.db.controls.NameAndSchemaAdvancedEditor;
import oracle.ide.db.event.SwingDBObjectPropertyListener;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;

public class HCSPanel<T extends AbstractSchemaObjectWithDesc>
extends NameAndSchemaAdvancedEditor<T> {
    private JCheckBox forceCreate;
    private boolean isBusyProcessingAlready;
    private boolean initialized;

    public HCSPanel() {
        this.getComponentFactory().setAllowRecreate(true);
        HCSPanelReference hCSPanelReference = HCSPanelReference.getInstance();
        hCSPanelReference.setMDSPanel(this);
        this.forceCreate = new JCheckBox(HCSArb.getString("OBJECT_FORCE_CREATE"));
        this.forceCreate.setName("forceCreateChkbox");
        this.forceCreate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!HCSPanel.this.forceCreate.isSelected() && HCSPanel.this.isEditing()) {
                    Namespace namespace = HCSPanel.this.getDataContext();
                    Window window = (Window)namespace.get("oracle.bali.ewt.dialog.JEWTDialog");
                    PanelLibrary panelLibrary = (PanelLibrary)namespace.find(PanelLibrary.class);
                    BasePanelLibrary basePanelLibrary = (BasePanelLibrary)panelLibrary;
                    basePanelLibrary.showForceCreateWarning(window);
                }
                ((AbstractSchemaObjectWithDesc)HCSPanel.this.getUpdatedObject()).setForceCreate(HCSPanel.this.forceCreate.isSelected());
            }
        });
    }

    protected void initialisePanel() {
        if (!this.initialized) {
            super.initialisePanel();
            for (Component component : this.getComponents()) {
                if (component == null || !(component instanceof JCheckBox) || component.getName().equals("forceCreateChkbox")) continue;
                JCheckBox jCheckBox = (JCheckBox)component;
                jCheckBox.setVisible(false);
                break;
            }
            if (this.isEditing()) {
                ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).setForceCreate(true);
                this.forceCreate.setSelected(true);
            } else {
                ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).setForceCreate(false);
                this.forceCreate.setSelected(false);
            }
            ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    Map map = dBObjectChange.getPropertiesChanged();
                    for (String string : map.keySet()) {
                        PropertyChangeEvent propertyChangeEvent;
                        Object object;
                        Boolean bl;
                        if (!string.equals("forceCreate") || !HCSPanel.this.isEditing() || (bl = (Boolean)(object = (propertyChangeEvent = (PropertyChangeEvent)map.get(string)).getNewValue())) == null || bl.booleanValue()) continue;
                        SystemObject systemObject = (SystemObject)HCSPanel.this.getOriginalObject();
                        AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc = (AbstractSchemaObjectWithDesc)HCSPanel.this.getUpdatedObject();
                        Database database = (Database)HCSPanel.this.getProvider();
                        Namespace namespace = HCSPanel.this.getDataContext();
                        PanelLibrary panelLibrary = (PanelLibrary)namespace.find(PanelLibrary.class);
                        BasePanelLibrary basePanelLibrary = (BasePanelLibrary)panelLibrary;
                        basePanelLibrary.reconcileDependencies(database, systemObject, (SystemObject)abstractSchemaObjectWithDesc);
                    }
                }
            });
            ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).addObjectListener(new DBObjectListener(){

                public void objectUpdated(DBObjectChange dBObjectChange) {
                    if (HCSPanel.this.getUpdatedObject() instanceof AnalyticView) {
                        DBObjectProvider dBObjectProvider = HCSPanel.this.getProvider();
                        if (!HCSPanel.this.isBusyProcessingAlready) {
                            HCSPanel.this.isBusyProcessingAlready = true;
                            AnalyticView analyticView = (AnalyticView)HCSPanel.this.getUpdatedObject();
                            AVCacheMeasureGroup[] aVCacheMeasureGroupArray = analyticView.getCacheMeasureGroups();
                            if (aVCacheMeasureGroupArray != null && aVCacheMeasureGroupArray.length > 0) {
                                String string;
                                Object object;
                                Object object2;
                                List list = dBObjectChange.getOwnedObjectsAdded();
                                if (!list.isEmpty()) {
                                    object2 = list.iterator();
                                    while (object2.hasNext()) {
                                        object = (DBObject)object2.next();
                                        if (object instanceof AVMeasure) {
                                            analyticView.manageCacheMeasureGroupMeasureAdded();
                                        }
                                        if (!(object instanceof AVDimensionality)) continue;
                                        analyticView.manageCacheMeasureGroupDimensionalityAdded();
                                    }
                                }
                                if (!(object2 = dBObjectChange.getOwnedObjectsRemoved()).isEmpty()) {
                                    object = object2.iterator();
                                    while (object.hasNext()) {
                                        Object object3;
                                        DBObject dBObject = (DBObject)object.next();
                                        if (dBObject instanceof AVMeasure) {
                                            object3 = (AVMeasure)dBObject;
                                            string = object3.getName();
                                            string = dBObjectProvider.getInternalName(string);
                                            analyticView.manageCacheMeasureGroupMeasureDelete(string);
                                            continue;
                                        }
                                        if (!(dBObject instanceof AVDimensionality)) continue;
                                        object3 = (AVDimensionality)dBObject;
                                        string = ((AVDimensionality)object3).getDimensionAlias();
                                        string = dBObjectProvider.getExternalName(string);
                                        analyticView.manageCacheMeasureGroupDimensionalityDeleted(string);
                                    }
                                }
                                object = dBObjectChange.getOwnedObjectsUpdated();
                                for (Object object3 : object.keySet()) {
                                    Object object4;
                                    Object object5;
                                    PropertyChangeEvent propertyChangeEvent;
                                    if (object3 instanceof AVMeasure) {
                                        string = (DBObjectChange)object.get(object3);
                                        if (!string.hasNameChanged()) continue;
                                        propertyChangeEvent = string.getPropertyChange("name");
                                        object5 = (String)propertyChangeEvent.getOldValue();
                                        object4 = (String)propertyChangeEvent.getNewValue();
                                        object5 = dBObjectProvider.getExternalName((String)object5);
                                        object4 = dBObjectProvider.getExternalName((String)object4);
                                        analyticView.manageCacheMeasureGroupMeasureRenamed(dBObjectProvider, (String)object5, (String)object4);
                                        continue;
                                    }
                                    if (!(object3 instanceof AVDimensionality)) continue;
                                    string = (DBObjectChange)object.get(object3);
                                    propertyChangeEvent = string.getPropertyChange("dimensionAlias");
                                    if (propertyChangeEvent != null) {
                                        object5 = (String)propertyChangeEvent.getOldValue();
                                        object4 = (String)propertyChangeEvent.getNewValue();
                                        object5 = dBObjectProvider.getExternalName((String)object5);
                                        object4 = dBObjectProvider.getExternalName((String)object4);
                                        analyticView.manageAVCacheMeasureGroupDimensionAliasRename(dBObjectProvider, (String)object5, (String)object4);
                                    }
                                    object5 = string.getOwnedObjectsUpdated();
                                    for (DBObject dBObject : object5.keySet()) {
                                        Object object6;
                                        Object object7;
                                        if (!(dBObject instanceof AVHierarchy)) continue;
                                        AVHierarchy aVHierarchy = (AVHierarchy)dBObject;
                                        DBObjectChange dBObjectChange2 = (DBObjectChange)object5.get(dBObject);
                                        propertyChangeEvent = dBObjectChange2.getPropertyChange("hierarchyAlias");
                                        if (propertyChangeEvent != null) {
                                            object7 = (String)propertyChangeEvent.getOldValue();
                                            object6 = (String)propertyChangeEvent.getNewValue();
                                            object7 = dBObjectProvider.getExternalName((String)object7);
                                            object6 = dBObjectProvider.getExternalName((String)object6);
                                            analyticView.manageCacheMeasureGroupHierarchyAliasRename(dBObjectProvider, aVHierarchy, (String)object7, (String)object6);
                                        }
                                        if ((propertyChangeEvent = dBObjectChange2.getPropertyChange("hierarchyIncludedInAV")) == null) continue;
                                        object7 = Boolean.FALSE;
                                        if (propertyChangeEvent.getOldValue() != null) {
                                            object7 = (Boolean)propertyChangeEvent.getOldValue();
                                        }
                                        if (!((Boolean)(object6 = (Boolean)propertyChangeEvent.getNewValue())).booleanValue()) continue;
                                        analyticView.manageCacheMeasureGroupHierarchyIncludeChanged(dBObjectProvider, aVHierarchy, (Boolean)object7, (Boolean)object6);
                                    }
                                }
                            }
                            HCSPanel.this.isBusyProcessingAlready = false;
                        }
                    }
                }
            });
            this.initialized = true;
        }
    }

    protected DBObjectListener createObjectListener() {
        String[] stringArray = new String[]{"name"};
        return new SwingDBObjectPropertyListener(stringArray){

            protected void updateUI(DBObject dBObject, String string, PropertyChangeEvent propertyChangeEvent) {
                if (HCSPanel.this.isEditing()) {
                    return;
                }
                GeneralBaseEditorPanelContext generalBaseEditorPanelContext = GeneralBaseEditorPanelContext.getInstance();
                if (!generalBaseEditorPanelContext.isDescriptionSynchOn()) {
                    return;
                }
                GeneralBaseEditorPanel generalBaseEditorPanel = generalBaseEditorPanelContext.getGeneralBaseEditorPanel();
                String string2 = generalBaseEditorPanel.getCaptionFld().getText();
                String string3 = generalBaseEditorPanel.getDescriptionFld().getText();
                if (string.equals("name")) {
                    Object object;
                    HCSPanelReference hCSPanelReference = HCSPanelReference.getInstance();
                    HCSPanel hCSPanel = hCSPanelReference.getMDSPanel();
                    ComponentFactory componentFactory = hCSPanel.getPanelHelper();
                    ComponentWrapper componentWrapper = componentFactory.findComponentWrapper("name");
                    String string4 = null;
                    if (componentWrapper == null) {
                        string4 = ((AbstractSchemaObjectWithDesc)HCSPanel.this.getUpdatedObject()).getName();
                    } else {
                        object = componentWrapper.getActiveComponent();
                        if (object instanceof JTextField) {
                            JTextField jTextField = (JTextField)componentWrapper.getActiveComponent();
                            String string5 = jTextField.getText();
                            if (string5.contains("\"")) {
                                string5 = string5.replaceAll("\"", "");
                            }
                            string4 = string5;
                        } else {
                            string4 = ((AbstractSchemaObjectWithDesc)HCSPanel.this.getUpdatedObject()).getName();
                        }
                    }
                    object = (AbstractSchemaObjectWithDesc)HCSPanel.this.getUpdatedObject();
                    boolean bl = string2 != null && UIStringUtils.isObjectNameAndDescriptionEqual(((AbstractSchemaObjectWithDesc)HCSPanel.this.getUpdatedObject()).getName(), string2);
                    boolean bl2 = string3 != null && UIStringUtils.isObjectNameAndDescriptionEqual(((AbstractSchemaObjectWithDesc)HCSPanel.this.getUpdatedObject()).getName(), string3);
                    boolean bl3 = ((AbstractSchemaObjectWithDesc)object).getCaptionDirty();
                    boolean bl4 = generalBaseEditorPanel.isCaptionTextFieldUpdated();
                    generalBaseEditorPanel.setCaptionTextFieldUpdated(bl4 || bl3);
                    generalBaseEditorPanel.setDescriptionTextFieldUpdated(generalBaseEditorPanel.isDescriptionTextFieldUpdated() || ((AbstractSchemaObjectWithDesc)object).getDescriptionDirty() != false);
                    if (!(generalBaseEditorPanel.isCaptionTextFieldUpdated() || string2 != null && bl)) {
                        generalBaseEditorPanel.setSkipCaptionToDescriptionSynch(true);
                        ((AbstractSchemaObjectWithDesc)object).setCaption(UIStringUtils.convertDescription(string4));
                    }
                    if (!(generalBaseEditorPanel.isDescriptionTextFieldUpdated() || generalBaseEditorPanel.isCaptionToDescriptionCopyOccurred() || string3 != null && bl2)) {
                        ((AbstractSchemaObjectWithDesc)object).setDescription(UIStringUtils.convertDescription(string4));
                    }
                    HCSPanel.this.updateDescriptions(generalBaseEditorPanelContext);
                }
            }
        };
    }

    private void updateDescriptions(GeneralBaseEditorPanelContext generalBaseEditorPanelContext) {
        GeneralBaseEditorPanel generalBaseEditorPanel = generalBaseEditorPanelContext.getGeneralBaseEditorPanel();
        String string = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getCaption();
        generalBaseEditorPanel.getCaptionFld().setText(string);
        String string2 = ((AbstractSchemaObjectWithDesc)this.getUpdatedObject()).getDescription();
        generalBaseEditorPanel.getDescriptionFld().setText(string2);
    }

    protected void layoutComponents(DBUILayoutHelper dBUILayoutHelper) {
        super.layoutComponents(dBUILayoutHelper);
        dBUILayoutHelper.nextRow();
        dBUILayoutHelper.add((Component)this.forceCreate);
    }

    protected boolean isAdvancedLayout() {
        return true;
    }

    public ComponentFactory getPanelHelper() {
        return this.getComponentFactory();
    }
}

