/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db.panels;

import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.db.model.AbstractSchemaObjectWithDesc;
import oracle.hcs.db.panels.ChildNameObjectEditorContext;
import oracle.hcs.db.panels.DescriptionFields;
import oracle.hcs.db.panels.PanelUtil;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.DBObject;

public abstract class ChildObjectEditorPanel2<T extends AbstractChildObjectWithDesc, P extends DBObject>
extends ChildObjectEditorPanel<T, P>
implements DescriptionFields {
    private JTextField m_fldName = new JTextField();
    private JLabel captionLabel = new JLabel();
    private JLabel descLabel = new JLabel();
    private String m_propPath;
    private JTextField descriptionFld = new JTextField();
    private JTextField captionFld = new JTextField();

    public ChildObjectEditorPanel2(String string, String string2) {
        super(string, string2);
        this.m_propPath = string2;
        this.initializeNameFieldListener();
    }

    public String getPropertyPath() {
        return this.m_propPath;
    }

    public JTextField getNameField() {
        return this.m_fldName;
    }

    public T getChildDBObject() {
        return (T)((AbstractChildObjectWithDesc)this.getChildObject());
    }

    protected void initialisePanel() {
        AbstractChildObjectWithDesc abstractChildObjectWithDesc = (AbstractChildObjectWithDesc)this.getChildObject();
        if (abstractChildObjectWithDesc != null) {
            this.descriptionFld.setText(abstractChildObjectWithDesc.getDescription());
            this.captionFld.setText(abstractChildObjectWithDesc.getCaption());
        }
    }

    public void initializeNameFieldListener() {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                Object t = ChildObjectEditorPanel2.this.getChildDBObject();
                if (t == null) {
                    keyEvent.consume();
                    return;
                }
                if (keyEvent.getSource() == ChildObjectEditorPanel2.this.m_fldName) {
                    if (keyEvent.getKeyChar() == ' ' || keyEvent.getKeyChar() == '.' || keyEvent.getKeyChar() == '\"') {
                        Toolkit.getDefaultToolkit().beep();
                        keyEvent.consume();
                        return;
                    }
                } else if (keyEvent.getSource() == ChildObjectEditorPanel2.this.captionFld) {
                    ((AbstractChildObjectWithDesc)t).markCaptionDirty(true);
                } else if (keyEvent.getSource() == ChildObjectEditorPanel2.this.descriptionFld) {
                    ((AbstractChildObjectWithDesc)t).markDescriptionDirty(true);
                }
                if (keyEvent.getKeyChar() == '\u001b') {
                    return;
                }
            }
        };
        this.m_fldName.addKeyListener(keyAdapter);
        this.captionFld.addKeyListener(keyAdapter);
        this.descriptionFld.addKeyListener(keyAdapter);
        this.m_fldName.getDocument().addDocumentListener(new DocumentListener(){

            public void common() {
                Object t = ChildObjectEditorPanel2.this.getChildDBObject();
                if (t == null) {
                    return;
                }
                if (!ChildObjectEditorPanel2.this.isEditing() || ((AbstractChildObjectWithDesc)t).isNewObject()) {
                    String string = ChildObjectEditorPanel2.this.m_fldName.getText();
                    ChildNameObjectEditorContext childNameObjectEditorContext = ChildNameObjectEditorContext.getInstance();
                    int n = childNameObjectEditorContext.getEditingState();
                    if (n == 1) {
                        return;
                    }
                    String string2 = ChildObjectEditorPanel2.this.descriptionFld.getText();
                    String string3 = ChildObjectEditorPanel2.this.captionFld.getText();
                    boolean bl = string2 != null && UIStringUtils.isObjectNameAndDescriptionEqual(string, string2);
                    boolean bl2 = string3 != null && UIStringUtils.isObjectNameAndDescriptionEqual(string, string3);
                    boolean bl3 = false;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (((AbstractChildObjectWithDesc)t).getDescriptionDirty().booleanValue()) {
                        bl3 = true;
                    }
                    if (((AbstractChildObjectWithDesc)t).getCaptionDirty().booleanValue()) {
                        bl4 = true;
                    }
                    if (!bl2 && (!bl4 || ChildObjectEditorPanel2.this.captionFld.getText().length() == 0 && string.length() < 2 && n == 0)) {
                        ChildObjectEditorPanel2.this.captionFld.setText(UIStringUtils.convertDescription(string));
                        ((AbstractChildObjectWithDesc)t).markCaptionDirty(false);
                    }
                    if (!bl && (!bl3 || ChildObjectEditorPanel2.this.descriptionFld.getText().length() == 0 && string.length() < 2 && n == 0)) {
                        ChildObjectEditorPanel2.this.descriptionFld.setText(UIStringUtils.convertDescription(string));
                        ((AbstractChildObjectWithDesc)t).markDescriptionDirty(false);
                    }
                }
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.common();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.common();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.common();
            }
        });
    }

    protected void commitPanel() throws TraversalException {
    }

    protected void registerDescriptionFields() {
        ComponentFactory componentFactory = this.getComponentFactory();
        PanelUtil.registerDescriptionFields(componentFactory, this);
    }

    protected int layoutDescriptionFields(int n) {
        return PanelUtil.layoutDescriptionFields((JPanel)((Object)this), this, n);
    }

    @Override
    public JLabel getDescriptionLabel() {
        return this.descLabel;
    }

    @Override
    public JLabel getCaptionLabel() {
        return this.captionLabel;
    }

    @Override
    public JTextField getDescriptionFld() {
        return this.descriptionFld;
    }

    @Override
    public JTextField getCaptionFld() {
        return this.captionFld;
    }

    public void enableDescriptions(boolean bl) {
        this.descLabel.setEnabled(bl);
        this.captionLabel.setEnabled(bl);
        this.descriptionFld.setEnabled(bl);
        this.captionFld.setEnabled(bl);
        if (!bl) {
            this.descriptionFld.setText("");
            this.captionFld.setText("");
        }
    }

    public void processRemoveChildEvent(AbstractSchemaObjectWithDesc abstractSchemaObjectWithDesc) {
    }
}

