/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.i18n.util.LocaleMapper;
import oracle.javatools.db.DBException;

public class LanguageDBSettings {
    public static String getDefaultLanguage(Connection connection) throws DBException {
        String string = "";
        boolean bl = Boolean.parseBoolean(System.getProperty("sqldev_hcs.cache", "true"));
        if (!bl) {
            return "AMERICAN";
        }
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("language", "NLS_LANGUAGE");
        String string2 = "select value from nls_session_parameters where parameter = :language";
        string = dBUtil.executeReturnOneCol(string2, hashMap);
        return string;
    }

    public static void setLanguage(String string, Connection connection) throws DBException {
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        String string2 = String.format("alter session set NLS_LANGUAGE='%s'", string);
        dBUtil.execute(string2);
    }

    public static String getLanguageCodeForLanguage(String string) {
        return LocaleMapper.getOraShortNameFromLanguage((String)string);
    }

    private static boolean objectBelongsToAw(String string, String string2, String string3) throws Exception {
        return true;
    }

    public static List<String> getDescriptionLanguagesUnionForObjectType(Connection connection, String string) throws Exception {
        String string2 = LanguageDBSettings.getDefaultLanguage(connection);
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("language", string2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("select distinct LANGUAGE from all_analytic_view_class where LANGUAGE <> :language and ANALYTIC_VIEW_NAME in (%s)", string));
        stringBuilder.append(" union ");
        stringBuilder.append(String.format("select distinct LANGUAGE from all_attribute_dim_class where LANGUAGE <> :language and DIMENSION_NAME in (%s)", string));
        stringBuilder.append(" union ");
        stringBuilder.append(String.format("select distinct LANGUAGE from all_hier_class where LANGUAGE <> :language and HIER_NAME in (%s)", string));
        Connections.getInstance().lock(connection);
        ResultSet resultSet = dBUtil.executeQuery(stringBuilder.toString(), hashMap);
        if (resultSet != null) {
            arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                String string3 = resultSet.getString("LANGUAGE");
                arrayList.add(string3);
            }
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(connection);
        return arrayList;
    }
}

