/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import oracle.hcs.db.DatabaseImpl;
import oracle.hcs.dimension.DimensionBuilder;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.metadata.HCSMetadataReader;
import oracle.hcs.metadata.HCSSchema;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AttributeDimensionList {
    private OracleDatabaseImpl db;
    private HCSSchema schema;
    private List<AttributeDimension> dimensions;
    private DimensionBuilder dimBuilder;
    private String dimensionName;

    public AttributeDimensionList(OracleDatabaseImpl oracleDatabaseImpl, HCSSchema hCSSchema) {
        this(oracleDatabaseImpl, hCSSchema, null);
    }

    public AttributeDimensionList(OracleDatabaseImpl oracleDatabaseImpl, HCSSchema hCSSchema, String string) {
        this.db = oracleDatabaseImpl;
        this.schema = hCSSchema;
        this.dimensions = new ArrayList<AttributeDimension>();
        this.dimBuilder = new DimensionBuilder(oracleDatabaseImpl);
        this.dimensionName = string;
    }

    private void addHierarchyDimension(String string, String string2, boolean bl) throws DBException, SQLException, IOException, JAXBException {
        if (this.dimBuilder != null) {
            NameBasedID nameBasedID = new NameBasedID("ATTRIBUTE DIMENSION", this.schema.getName(), string, (AbstractDBObjectProvider)this.db);
            AttributeDimension attributeDimension = this.dimBuilder.createObject(string, this.schema, (DBObjectID)nameBasedID);
            attributeDimension.setDimensionType(string2);
            this.dimBuilder.buildDetails(attributeDimension);
            this.dimensions.add(attributeDimension);
        }
    }

    public void build(AttributeDimension attributeDimension, boolean bl) throws DBException, SQLException, IOException, JAXBException {
        if (bl) {
            this.dimBuilder.buildDetails(attributeDimension);
        } else {
            this.dimBuilder.build(attributeDimension);
        }
    }

    public List<AttributeDimension> getHierarchyDimensions() throws DBException, SQLException, IOException, JAXBException {
        DatabaseImpl databaseImpl = new DatabaseImpl(this.db.getConnection());
        HCSMetadataReader hCSMetadataReader = new HCSMetadataReader(databaseImpl, this.schema);
        hCSMetadataReader.loadAttributeDimensions();
        this.dimensions = this.schema.getDimensions();
        return this.dimensions;
    }
}

