/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.AVCalcPersist;
import oracle.hcs.db.CalculatedMeasuresSQLOperationsNotifier;
import oracle.hcs.db.Database;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.MetadataChange;
import oracle.hcs.db.panels.HCSDDLPanel;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SystemObject;

public class AVCalcPersistSQL
implements AVCalcPersist {
    private Database database;
    private oracle.javatools.db.Database db;
    private boolean throwException;
    private StringBuffer alterAVSQL;
    private AnalyticView analyticView;
    private AnalyticView updatedAnalyticView;
    private List<String> measures;
    private HashMap<String, String> measureDescriptions;
    private HashMap<String, List<String>> measuresToRemove;
    private StringBuffer updateMeasuresSQL;
    private CalculatedMeasuresSQLOperationsNotifier progressNotifier;
    private HashSet<String> changedMeasures;
    private static final Logger LOG = Logger.getLogger(AVCalcPersistSQL.class.getName());

    public AVCalcPersistSQL(Database database, AnalyticView analyticView) throws Exception {
        this.database = database;
        this.measureDescriptions = new HashMap();
        this.updateMeasuresSQL = new StringBuffer();
        this.measuresToRemove = new HashMap();
        this.analyticView = analyticView;
        this.updatedAnalyticView = new AnalyticView();
        this.throwException = true;
        this.init();
    }

    public void setProvider(oracle.javatools.db.Database database) {
        this.db = database;
    }

    private void init() throws SQLException, IOException {
        this.alterAVSQL = new StringBuffer();
        this.measures = new ArrayList<String>();
        String string = "select measure_name from all_analytic_view_base_meas where owner = ? and analytic_view_name = ?";
        List<List<String>> list = this.database.executeSQL(string, new Object[]{this.analyticView.getSchema().getName(), this.analyticView.getName()});
        for (List<String> list2 : list) {
            for (String string2 : list2) {
                this.measures.add(string2);
            }
        }
        string = "select measure_name from all_analytic_view_calc_meas where owner = ? and analytic_view_name = ?";
        list = this.database.executeSQL(string, new Object[]{this.analyticView.getSchema().getName(), this.analyticView.getName()});
        for (List<String> list2 : list) {
            for (String string2 : list2) {
                this.measures.add(string2);
            }
        }
        this.changedMeasures = new HashSet();
        this.analyticView.copyTo(this.updatedAnalyticView);
    }

    @Override
    public void setProgressNotifier(CalculatedMeasuresSQLOperationsNotifier calculatedMeasuresSQLOperationsNotifier) {
        this.progressNotifier = calculatedMeasuresSQLOperationsNotifier;
    }

    @Override
    public void clear() {
        this.alterAVSQL = new StringBuffer();
        this.measureDescriptions = new HashMap();
        this.updateMeasuresSQL = new StringBuffer();
        this.measuresToRemove = new HashMap();
        this.changedMeasures = new HashSet();
        this.analyticView.copyTo(this.updatedAnalyticView);
    }

    @Override
    public Object addDerivedMeasure(AnalyticView analyticView, String string, String string2, String string3, Map<String, String> map) throws SQLException, IOException {
        AVCalculatedMeasure aVCalculatedMeasure;
        if (this.analyticView == null) {
            this.analyticView = analyticView;
            this.init();
        }
        if ((aVCalculatedMeasure = this.updatedAnalyticView.findCalculatedMeasure(string)) == null) {
            aVCalculatedMeasure = new AVCalculatedMeasure(string);
            this.updatedAnalyticView.addCalculatedMeasure(aVCalculatedMeasure);
        }
        aVCalculatedMeasure.setMeasureExpression(string3);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.measureDescriptions.size() > 0) {
            stringBuffer.append(" description (");
        }
        for (Map.Entry<String, String> entry : this.measureDescriptions.entrySet()) {
            stringBuffer.append(String.format("'%s'='%s',", entry.getKey(), entry.getValue()));
        }
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringBuffer.append(String.format("'%s'='%s',", entry.getKey(), entry.getValue()));
            }
        }
        if (this.measureDescriptions.size() > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append(")");
        }
        this.alterAVSQL.append(String.format("%s MEASURE\n        AS '%s'\n         TYPE \"%s\"\n       %s,\n", string, string3, string2, stringBuffer.toString()));
        this.changedMeasures.add(string);
        return string;
    }

    @Override
    public void setAV(AnalyticView analyticView) {
        this.analyticView = analyticView;
        analyticView.copyTo(this.updatedAnalyticView);
    }

    @Override
    public void setDescription(AnalyticView analyticView, Object object, String string, String string2) throws SQLException, IOException {
        AVCalculatedMeasure aVCalculatedMeasure;
        if (this.analyticView == null) {
            this.analyticView = analyticView;
            this.init();
        }
        String string3 = null;
        if (object instanceof String) {
            string3 = (String)object;
        }
        if ((aVCalculatedMeasure = this.updatedAnalyticView.findCalculatedMeasure(string3)) == null) {
            aVCalculatedMeasure = new AVCalculatedMeasure(string3);
            this.updatedAnalyticView.addCalculatedMeasure(aVCalculatedMeasure);
        }
        if (string.equalsIgnoreCase("description")) {
            aVCalculatedMeasure.setDescription(string2);
            this.measureDescriptions.put("Description", string2);
        }
        if (string.equalsIgnoreCase("caption")) {
            aVCalculatedMeasure.setCaption(string2);
            this.measureDescriptions.put("Caption", string2);
        }
        if (string.equalsIgnoreCase("format_string")) {
            aVCalculatedMeasure.setMeasureFormat(string2);
        }
    }

    @Override
    public void setThrowException(boolean bl) {
        this.throwException = bl;
    }

    @Override
    public void commit() throws Exception {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.db.getConnection());
        List<String> list = this.generateSQL();
        dBUtil.setRaiseError(this.throwException);
        for (String string : list) {
            dBUtil.execute(string);
        }
        SQLException sQLException = dBUtil.getLastException();
        if (sQLException != null) {
            throw sQLException;
        }
        dBUtil.setRaiseError(false);
    }

    private void recordMetadataChanges() {
        Connection connection = this.db.getConnection();
        String string = Connections.getInstance().getConnectionName(connection);
        String string2 = this.analyticView.getSchema().getName();
        LinkedList<MetadataChange> linkedList = new LinkedList<MetadataChange>();
        for (String object : this.changedMeasures) {
            linkedList.add(new MetadataChange(this.analyticView.getName(), object, HCSSyntaxType.MEASURE));
        }
        for (MetadataChange metadataChange : linkedList) {
            LOG.finest(String.format("recording change for %s", metadataChange.getObjectName()));
            HCSMetadataCache.recordMetadataChange(string, string2, metadataChange);
        }
    }

    @Override
    public boolean isMeasureCreated(AnalyticView analyticView, String string) throws Exception {
        if (this.analyticView == null) {
            this.analyticView = analyticView;
            this.init();
        }
        return this.measures.contains(string);
    }

    @Override
    public void rollback() {
    }

    @Override
    public void addRemoveMeasure(String string, String string2) {
    }

    @Override
    public void addUpdateMeasure(String string, String string2, String string3, String string4, String string5, String string6) {
    }

    @Override
    public List<String> generateSQL() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        DBEditorConfig dBEditorConfig = DBEditorConfig.newEditConfig((DBObjectProvider)this.db, (DBObject)this.analyticView);
        dBEditorConfig.setUpdatedObject((SystemObject)this.updatedAnalyticView);
        dBEditorConfig.setOriginalObject((SystemObject)this.analyticView);
        dBEditorConfig.setReplaceAllowed(true);
        Collection<String> collection = HCSDDLPanel.getSQLStatements(dBEditorConfig);
        for (String string : collection) {
            arrayList.add(string);
        }
        return arrayList;
    }
}

