/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.avviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.avviewer.AVConditionPanel;
import oracle.hcs.avviewer.AVDataSource;
import oracle.hcs.avviewer.AVGraphDataViewerPanel;
import oracle.hcs.avviewer.AVMeasureSelectionPanel;
import oracle.hcs.avviewer.AVQueryPanel;
import oracle.hcs.avviewer.AVTable;
import oracle.hcs.db.LanguageDBSettings;
import oracle.hcs.table.LineNumberTableRowHeader;
import oracle.hcs.table.Query;
import oracle.hcs.table.QueryTableModel;
import oracle.hcs.table.TablePacker;
import oracle.hcs.util.CursorUtil;
import oracle.hcs.util.HCSErrorDisplay;
import oracle.hcs.util.HCSResources;
import oracle.hcs.util.LanguageSelector;
import oracle.hcs.util.LanguageSelectorPanel;
import oracle.hcs.util.Resources;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AVViewerPanel
extends JPanel
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(AVViewerPanel.class.getName());
    private OracleDatabaseImpl db;
    private AnalyticView av;
    private JDialog window;
    private ResultSetTable avDataRaptorTable;
    private AVTable avDataTable;
    private JLabel resultsLabel;
    private JButton editQueryButton;
    private AVMeasureSelectionPanel measureSelectionPanel;
    private AVConditionPanel avCondPanel;
    private JSplitPane splitPane;
    private AVQueryPanel queryPanel;
    private AVGraphDataViewerPanel graphPanel;
    private JScrollPane avDataTableScrollPane;
    private boolean queryChanged;
    private List<String> languages;
    private String defaultLanguage;
    private LanguageSelectorPanel languagePanel;
    private Resources resources;
    private Set<AVHierarchy> preselectedAVHierarchies;
    private JTabbedPane queryTab;
    final String AV_QUERY_XML_FILE = "/oracle/hcs/cubeviewer/dimcondition.xml";

    public AVViewerPanel(JDialog jDialog, OracleDatabaseImpl oracleDatabaseImpl, AnalyticView analyticView) throws SQLException, IOException, DBException {
        this(jDialog, oracleDatabaseImpl, analyticView, null, null);
    }

    public AVViewerPanel(JDialog jDialog, final OracleDatabaseImpl oracleDatabaseImpl, AnalyticView analyticView, List<String> list, Set<AVHierarchy> set) throws SQLException, IOException, DBException {
        this.window = jDialog;
        this.db = oracleDatabaseImpl;
        this.av = analyticView;
        this.languages = list;
        if (set == null) {
            set = new HashSet<AVHierarchy>();
        }
        this.preselectedAVHierarchies = set;
        this.queryChanged = true;
        this.resources = new HCSResources("/oracle/hcs/cubeviewer/dimcondition.xml");
        this.avCondPanel = new AVConditionPanel(this, this.resources);
        this.selectDefaultMeasures();
        this.measureSelectionPanel = new AVMeasureSelectionPanel(analyticView);
        this.graphPanel = new AVGraphDataViewerPanel();
        this.graphPanel.setName("graphPanel");
        try {
            this.defaultLanguage = LanguageDBSettings.getDefaultLanguage(oracleDatabaseImpl.getConnection());
        }
        catch (DBException dBException) {
            // empty catch block
        }
        this.languagePanel = new LanguageSelectorPanel(new LanguageSelector(){

            @Override
            public void languageSelectionChanged(String string) {
                try {
                    LanguageDBSettings.setLanguage(string, oracleDatabaseImpl.getConnection());
                    AVViewerPanel.this.avCondPanel.refreshDataPanel();
                    String string2 = AVViewerPanel.this.avCondPanel.getQuery();
                    AVViewerPanel.this.queryPanel.setQuery(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.languagePanel.setVisible(false);
        try {
            if (list != null && !list.isEmpty()) {
                this.languagePanel.addLanguage(this.defaultLanguage);
                for (String string : list) {
                    this.languagePanel.addLanguage(string);
                }
                this.languagePanel.setVisible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.layoutComponents();
        if (this.avCondPanel != null) {
            this.avCondPanel.addPropertyChangeListener(this);
            String string = this.avCondPanel.getQuery();
            this.queryPanel.setQuery(string);
        }
        this.measureSelectionPanel.addPropertyChangeListener(this);
        this.queryPanel.getQueryEditor().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AVViewerPanel.this.queryChanged = true;
                AVViewerPanel.this.avCondPanel.getRunButton().setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AVViewerPanel.this.queryChanged = true;
                AVViewerPanel.this.avCondPanel.getRunButton().setEnabled(true);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AVViewerPanel.this.queryChanged = true;
                AVViewerPanel.this.avCondPanel.getRunButton().setEnabled(true);
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (this.avCondPanel != null) {
                String string = this.avCondPanel.getQuery();
                this.queryPanel.setQuery(string);
                this.queryChanged = true;
                this.avCondPanel.getRunButton().setEnabled(true);
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, throwable.getMessage(), throwable);
        }
    }

    public AnalyticView getAV() {
        return this.av;
    }

    public Set<AVHierarchy> getPreselectedAVHierarchies() {
        return this.preselectedAVHierarchies;
    }

    public OracleDatabaseImpl getDatabase() {
        return this.db;
    }

    public void runQuery() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AVViewerPanel.this.runQueryNonThreaded();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runQueryNonThreaded() {
        try {
            CursorUtil.setBusyCursor(this);
            this.graphPanel.setGraphEnabled(false);
            String string = this.queryPanel.getQuery();
            Query query = new Query();
            query.setText(string);
            String string2 = this.db.getQualifiedName();
            this.avDataRaptorTable.setQuery(string2, string, null, null);
            long l = System.currentTimeMillis();
            this.avDataRaptorTable.refresh();
            this.avDataRaptorTable.allRowsFetched();
            long l2 = System.currentTimeMillis() - l;
            int n = this.avDataRaptorTable.getRowCount();
            float f = (float)l2 / 1000.0f;
            int n2 = (int)f;
            final String string3 = HCSArb.format("AV_DATA_VIEWER_RESULTS", String.valueOf(n2), String.valueOf(n));
            final AVDataSource aVDataSource = new AVDataSource(this.av, this.avDataRaptorTable.getModel());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AVViewerPanel.this.resultsLabel.setText(string3);
                    AVViewerPanel.this.graphPanel.setDataSource(aVDataSource);
                    AVViewerPanel.this.avCondPanel.getRunButton().setEnabled(false);
                }
            });
        }
        catch (Exception exception) {
            HCSErrorDisplay hCSErrorDisplay = new HCSErrorDisplay();
            if (exception.getCause() instanceof SQLException) {
                SQLException sQLException = (SQLException)exception.getCause();
                hCSErrorDisplay.show(sQLException, HCSArb.getString("AV_DATA_VIEWER_ERROR_TITLE"), HCSArb.getString("AV_DATA_VIEWER_ERROR_TITLE"), (Component)Ide.getMainWindow());
            } else {
                hCSErrorDisplay.show(exception, HCSArb.getString("AV_DATA_VIEWER_ERROR_TITLE"), HCSArb.getString("AV_DATA_VIEWER_ERROR_TITLE"), (Component)Ide.getMainWindow());
            }
        }
        finally {
            CursorUtil.setDefaultCursor(this);
            this.graphPanel.setGraphEnabled(true);
        }
    }

    public void closeTableModel() {
        if (this.avDataRaptorTable != null) {
            this.avDataRaptorTable.closeModel();
        }
    }

    public void cleanUp() throws Exception {
        this.closeTableModel();
        LanguageDBSettings.setLanguage(this.defaultLanguage, this.db.getConnection());
    }

    public void packTable() {
        TablePacker tablePacker = new TablePacker();
        tablePacker.pack((JTable)((Object)this.avDataTable));
    }

    private void layoutComponents() {
        this.avDataRaptorTable = new ResultSetTable();
        this.queryPanel = new AVQueryPanel(this.db);
        JScrollPane jScrollPane = new JScrollPane(this.queryPanel);
        if (this.queryPanel.getLeftMargin() != null) {
            jScrollPane.setRowHeaderView(this.queryPanel.getLeftMargin());
        }
        this.avDataTable = new AVTable();
        this.avDataTable.setName("cubeDataTable");
        this.avDataTable.setFont(new Font("Monospaced", 0, 12));
        this.avDataTable.setAutoResizeMode(0);
        this.avDataTableScrollPane = new JScrollPane((Component)((Object)this.avDataTable));
        this.avDataTableScrollPane.setName("cubeDataTableScrollPane");
        LineNumberTableRowHeader lineNumberTableRowHeader = new LineNumberTableRowHeader(this.avDataTableScrollPane, (JTable)((Object)this.avDataTable));
        lineNumberTableRowHeader.setBackground(Color.WHITE);
        this.avDataTableScrollPane.setRowHeaderView(lineNumberTableRowHeader);
        this.avDataTableScrollPane = new JScrollPane((Component)this.avDataRaptorTable);
        lineNumberTableRowHeader = new LineNumberTableRowHeader(this.avDataTableScrollPane, (JTable)this.avDataRaptorTable);
        lineNumberTableRowHeader.setBackground(Color.WHITE);
        this.avDataTableScrollPane.setRowHeaderView(lineNumberTableRowHeader);
        this.resultsLabel = new JLabel();
        this.resultsLabel.setName("resultsLabel");
        this.queryTab = new JTabbedPane();
        this.queryTab.setName("queryTab");
        this.queryTab.setBorder(null);
        JPanel jPanel = new JPanel();
        jPanel.setName("topPane");
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        jPanel.add((Component)this.languagePanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 1.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.queryTab, new GridBagConstraints(0, n, 2, 1, 1.0, 1.0, 18, 1, new Insets(20, 0, 0, 0), 5, 0));
        jPanel.add((Component)this.resultsLabel, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 5, 0));
        n = 0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("bottomPane");
        jPanel2.setLayout(new GridBagLayout());
        this.splitPane = new JSplitPane(0, this.avCondPanel, jScrollPane);
        this.splitPane.setDividerLocation(300);
        this.queryTab.add(HCSArb.get("AV_QUERY_QUERY_TAB"), this.splitPane);
        boolean bl = false;
        final JTabbedPane jTabbedPane = new JTabbedPane();
        if (bl) {
            jTabbedPane.setName("dataTabPane");
            jTabbedPane.add(HCSArb.format("AV_DATA_VIEWER_GRAPH_TAB", new Object[0]), this.graphPanel);
            jTabbedPane.add(HCSArb.format("AV_DATA_VIEWER_DATA_TAB", new Object[0]), this.avDataTableScrollPane);
            jPanel2.add((Component)jTabbedPane, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 5, 0));
            JSplitPane jSplitPane = new JSplitPane(0, jPanel, jPanel2);
            jSplitPane.setName("querySplitPane");
            this.setLayout(new GridBagLayout());
            n = 0;
            JLabel jLabel = new JLabel(HCSArb.get("AV_DATA_VIEWER_HEADER"));
            jLabel.setName("headerLabel");
            this.add((Component)jSplitPane, new GridBagConstraints(0, n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
            jTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (jTabbedPane.getSelectedComponent() == AVViewerPanel.this.avDataTableScrollPane) {
                        AVViewerPanel.this.packTable();
                    }
                }
            });
        } else {
            this.queryTab.add(HCSArb.format("AV_DATA_VIEWER_DATA_TAB", new Object[0]), this.avDataTableScrollPane);
            this.queryTab.add(HCSArb.format("AV_DATA_VIEWER_GRAPH_TAB", new Object[0]), this.graphPanel);
            this.setLayout(new GridBagLayout());
            n = 0;
            JLabel jLabel = new JLabel(HCSArb.get("AV_DATA_VIEWER_HEADER"));
            jLabel.setName("headerLabel");
            this.add((Component)jPanel, new GridBagConstraints(0, n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        }
        this.queryTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
            }
        });
    }

    private void selectDefaultMeasures() {
        int n = 0;
        boolean bl = false;
        for (AVBaseMeasure aVBaseMeasure : this.av.getStoredAndCalculatedMeasures()) {
            if (!aVBaseMeasure.isSelected()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (AVMeasure aVMeasure : this.av.getMeasures()) {
                aVMeasure.setSelected(true);
                if (n == 5) break;
                ++n;
            }
        }
    }

    public void reload(OracleDatabaseImpl oracleDatabaseImpl, AnalyticView analyticView) throws SQLException, IOException, DBException {
        String string;
        this.av = analyticView;
        this.selectDefaultMeasures();
        this.avCondPanel.setupTemplates(this.getDatabase());
        final String string2 = string = this.avCondPanel.getQuery();
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AVViewerPanel.this.avCondPanel.refreshDataPanel();
                    AVViewerPanel.this.avCondPanel.invalidate();
                    AVViewerPanel.this.avCondPanel.repaint();
                    AVViewerPanel.this.queryPanel.setQuery(string2);
                }
            });
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    static class QueryTableModelReadOnly
    extends QueryTableModel {
        public QueryTableModelReadOnly(Connection connection, Query query, Map<String, Object> map) {
            super(connection, query, map);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

