/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.avviewer;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import oracle.dss.dataView.LocalDataSource;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.sql.NUMBER;

public class AVDataSource
extends LocalDataSource {
    private static Pattern numeric = Pattern.compile("-?\\d*(\\.\\d+)?");

    public AVDataSource() {
        this.rowCount = 1;
        this.columnCount = 1;
        this.defaultData1 = new double[this.rowCount][this.columnCount];
        this.defaultData1[0][0] = 0.0;
        this.populateCellData(this.columnCount, this.rowCount, this.defaultData1);
    }

    public AVDataSource(AnalyticView analyticView, TableModel tableModel) {
        Object object;
        int n = analyticView.getDimensions().length;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        for (AVMeasure aVBaseMeasure : analyticView.getMeasures()) {
            if (!aVBaseMeasure.isSelected()) continue;
            object = aVBaseMeasure.getDisplayLabel();
            arrayList.add((String)object);
            ++n2;
        }
        AVBaseMeasure[] aVBaseMeasureArray = analyticView.getCalculatedMeasures();
        int n3 = aVBaseMeasureArray.length;
        for (int i = 0; i < n3; ++i) {
            AVBaseMeasure aVBaseMeasure = aVBaseMeasureArray[i];
            if (!aVBaseMeasure.isSelected()) continue;
            object = aVBaseMeasure.getDisplayLabel();
            arrayList.add((String)object);
            ++n2;
        }
        n = tableModel.getColumnCount() - n2;
        this.rowCount = arrayList.size();
        this.rowLabels = arrayList.toArray(new String[this.rowCount]);
        if (tableModel != null) {
            int n4;
            this.columnCount = n4 = tableModel.getRowCount();
            this.defaultData1 = new double[this.rowCount][this.columnCount];
            this.columnLabels = new String[this.columnCount];
            for (n3 = 0; n3 < n4; ++n3) {
                String string;
                int n5;
                StringBuffer stringBuffer = new StringBuffer();
                for (n5 = 0; n5 < n; ++n5) {
                    object = tableModel.getValueAt(n3, n5);
                    if (object == null) continue;
                    string = object.toString().trim();
                    stringBuffer.append(string + ",\n");
                }
                if (stringBuffer.length() > 0 && stringBuffer.substring(stringBuffer.length() - 2, stringBuffer.length()).equals(",\n")) {
                    stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
                }
                this.columnLabels[n3] = stringBuffer.toString();
                for (n5 = n; n5 < tableModel.getColumnCount(); ++n5) {
                    object = tableModel.getValueAt(n3, n5);
                    if (object == null) continue;
                    string = object.toString();
                    double d = 0.0;
                    if (object instanceof NUMBER) {
                        NUMBER nUMBER = (NUMBER)object;
                        d = nUMBER.doubleValue();
                    } else if (this.isNumeric(string)) {
                        d = Double.valueOf(string);
                    } else if (this.isNumeric(string = string.replaceAll("[^\\d.-]", ""))) {
                        d = Double.valueOf(string);
                    }
                    this.defaultData1[n5 - n][n3] = d;
                }
            }
            this.populateCellData(this.columnCount, this.rowCount, this.defaultData1);
        }
    }

    protected boolean isNumeric(String string) {
        return !string.isEmpty() && numeric.matcher(string).matches();
    }
}

