/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels.cache;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AVCacheLevelGroupNode;
import oracle.hcs.av.model.cache.AVCacheMeasureGroupNode;
import oracle.hcs.av.model.cache.AbstractAVNavigatorCacheModelNode;
import oracle.hcs.av.panels.cache.AVCacheController;
import oracle.hcs.av.panels.cache.AVCacheMeasureSelectionPanel;
import oracle.hcs.av.panels.cache.AVLevelGroupEditorCachePanel;
import oracle.javatools.db.DBObjectProvider;

public class AVObjectEditorCachePanel
extends JPanel
implements PropertyChangeListener {
    private DBObjectProvider prov;
    private AnalyticView analyticView;
    private AVCacheController cacheController;
    private AbstractAVNavigatorCacheModelNode currentNode;
    private GridBagConstraints c;
    private AVLevelGroupEditorCachePanel levelGroupPanel;
    private AVCacheMeasureSelectionPanel measureSelectionPanel;
    private JPanel instructionsPanel;
    private boolean initialized;

    public AVObjectEditorCachePanel() {
        this.initialisePanelLayout();
        this.instructionsPanel = this.getRootNodePanel();
    }

    public void initialisePanel(AnalyticView analyticView, AVCacheController aVCacheController, DBObjectProvider dBObjectProvider) {
        this.analyticView = analyticView;
        this.cacheController = aVCacheController;
        this.prov = dBObjectProvider;
        if (!this.initialized) {
            this.add((Component)this.instructionsPanel, this.c);
            this.revalidate();
            this.repaint();
            this.initialized = true;
        }
    }

    public void stopCellEditing() {
        if (this.currentNode != null && this.currentNode.getModelNodeType().equalsIgnoreCase("LevelsNodeType") && this.levelGroupPanel != null) {
            this.levelGroupPanel.stopCellEditing();
        }
    }

    public void clearObjectEditorPanel() {
        if (this.measureSelectionPanel != null) {
            this.measureSelectionPanel.removeUI();
            this.remove(this.measureSelectionPanel);
            this.measureSelectionPanel = null;
        }
        if (this.levelGroupPanel != null) {
            this.levelGroupPanel.removeUI();
            this.remove(this.levelGroupPanel);
            this.levelGroupPanel = null;
        }
        this.remove(this.instructionsPanel);
    }

    public void updateObjectEditorPanel(AbstractAVNavigatorCacheModelNode abstractAVNavigatorCacheModelNode) {
        this.currentNode = abstractAVNavigatorCacheModelNode;
        this.clearObjectEditorPanel();
        this.c.gridx = 0;
        this.c.gridy = 0;
        if (abstractAVNavigatorCacheModelNode.getModelNodeType().equalsIgnoreCase("MeasureGroupNodeType")) {
            AVCacheMeasureGroupNode aVCacheMeasureGroupNode = (AVCacheMeasureGroupNode)abstractAVNavigatorCacheModelNode;
            this.measureSelectionPanel = new AVCacheMeasureSelectionPanel(this.analyticView, aVCacheMeasureGroupNode, this.prov);
            this.measureSelectionPanel.addPropertyChangeListener(this);
            this.c.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.measureSelectionPanel, this.c);
            this.revalidate();
            this.repaint();
        } else if (abstractAVNavigatorCacheModelNode.getModelNodeType().equalsIgnoreCase("LevelsNodeType")) {
            AVCacheLevelGroupNode aVCacheLevelGroupNode = (AVCacheLevelGroupNode)abstractAVNavigatorCacheModelNode;
            this.levelGroupPanel = new AVLevelGroupEditorCachePanel();
            this.levelGroupPanel.initializePanel(this.analyticView, aVCacheLevelGroupNode, this.cacheController, this.prov);
            this.c.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.levelGroupPanel, this.c);
            this.revalidate();
            this.repaint();
        } else if (abstractAVNavigatorCacheModelNode.getModelNodeType().equalsIgnoreCase("rootNodeType")) {
            this.c.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.instructionsPanel, this.c);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        AVCacheMeasureGroupNode aVCacheMeasureGroupNode = (AVCacheMeasureGroupNode)this.currentNode;
        String string = propertyChangeEvent.getPropertyName();
        string = this.prov.getInternalName(string);
        Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
        boolean bl2 = bl;
        if (bl2) {
            aVCacheMeasureGroupNode.addMeasureByName(string);
        } else {
            aVCacheMeasureGroupNode.removeMeasureByName(string);
        }
        this.cacheController.update(aVCacheMeasureGroupNode);
    }

    private void initialisePanelLayout() {
        this.setLayout(new GridBagLayout());
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 18;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
    }

    private JPanel getRootNodePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 1;
        JLabel jLabel = new JLabel();
        jLabel.setText(this.getFormattedInformationHTML());
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        return jPanel;
    }

    private String getFormattedInformationHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append("<br/><h3>" + HCSArb.getString("AV_CACHE_EDITOR_ROOT_NODE_INFO_HEADER") + "</h3><br/>");
        stringBuffer.append("<div>" + HCSArb.getString("AV_CACHE_EDITOR_ROOT_NODE_INFO_MESSAGE1") + "<br/>");
        stringBuffer.append(HCSArb.getString("AV_CACHE_EDITOR_ROOT_NODE_INFO_MESSAGE2") + "</div>");
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }
}

