/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels.cache;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AVCacheMeasureGroupNode;
import oracle.hcs.table.TableCheckBoxCellEditor;
import oracle.hcs.table.TableCheckBoxCellRenderer;
import oracle.hcs.util.CheckBoxHeader;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;

public class AVCacheMeasureSelectionPanel
extends JPanel
implements TableModelListener {
    private DBObjectProvider prov;
    private DefaultTableModel measureTableModel;
    private JTable measureTable;
    private JPanel measuresPanel;
    private JLabel topLabel;
    private SearchField measureFilterFld;
    private CheckBoxHeader checkBoxHeader;
    private AnalyticView av;
    private List<PropertyChangeListener> listeners;
    private int totalRows;
    private int selectedRows;
    private AVCacheMeasureGroupNode measureGroupNode;
    private static final int COL_SELECT = 0;
    private static final int COL_MEASURE_NAME = 1;

    public AVCacheMeasureSelectionPanel(AnalyticView analyticView, AVCacheMeasureGroupNode aVCacheMeasureGroupNode, DBObjectProvider dBObjectProvider) {
        this.av = analyticView;
        this.measureGroupNode = aVCacheMeasureGroupNode;
        this.prov = dBObjectProvider;
        this.measureTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }
        };
        this.measureTableModel.addTableModelListener(this);
        this.listeners = new ArrayList<PropertyChangeListener>();
        this.layoutComponents();
        this.initTable();
        this.loadMeasureTable(true);
        for (AVMeasure object : analyticView.getMeasures()) {
            object.setSelected(false);
        }
        int n = 0;
        block1: for (AVBaseMeasure aVBaseMeasure : aVCacheMeasureGroupNode.getMeasuresForSelectionPanel()) {
            String string = dBObjectProvider.getExternalName(aVBaseMeasure.getName());
            for (int i = 0; i < this.measureTable.getRowCount(); ++i) {
                String string2 = (String)this.measureTable.getValueAt(i, 1);
                if (!string2.equalsIgnoreCase(string)) continue;
                this.measureTable.setValueAt(Boolean.TRUE, i, 0);
                aVBaseMeasure.setSelected(true);
                ++n;
                continue block1;
            }
        }
        if (n == this.measureTable.getRowCount()) {
            this.checkBoxHeader.setSelected(true);
        } else {
            this.checkBoxHeader.setSelected(false);
        }
    }

    public void removeUI() {
        if (this.topLabel != null) {
            this.remove(this.topLabel);
            this.topLabel = null;
        }
        if (this.measuresPanel != null) {
            this.remove(this.measuresPanel);
            this.measuresPanel = null;
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    private void initTable() {
        this.measureTableModel.setRowCount(0);
        this.measureTableModel.setColumnCount(0);
        this.measureTableModel.addColumn(HCSArb.get("MEASURE_SELECT_COLUMN"));
        this.measureTableModel.addColumn(HCSArb.get("MEASURE_MEASURE_NAME_COLUMN"));
        this.measureTableModel.addColumn(HCSArb.get("MEASURE_DESCRIPTION_COLUMN"));
        TableColumn tableColumn = this.measureTable.getColumnModel().getColumn(0);
        tableColumn.setCellEditor(new TableCheckBoxCellEditor());
        tableColumn.setCellRenderer(new TableCheckBoxCellRenderer());
        this.checkBoxHeader = new CheckBoxHeader(this.measureTable);
        tableColumn.setHeaderRenderer(this.checkBoxHeader);
        tableColumn.setPreferredWidth(120);
    }

    private void loadMeasureTable(boolean bl) {
        String string = "";
        if (this.measureFilterFld.getText() != null) {
            string = this.measureFilterFld.getText();
            if (string.startsWith("\"")) {
                string = string.substring(1);
            }
            if (string.endsWith("\"")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        this.measureTableModel.setRowCount(0);
        this.totalRows = 0;
        this.selectedRows = 0;
        List<AVMeasure> list = this.sortMeasures(this.av.getMeasures());
        for (AVMeasure aVMeasure : list) {
            String string2 = this.prov.getExternalName(aVMeasure.getName());
            if (string.length() > 0) {
                boolean bl2 = false;
                String string3 = this.prov.getInternalName(aVMeasure.getName());
                if (!string2.equals(string3)) {
                    bl2 = true;
                }
                boolean bl3 = true;
                if (!bl2 ? !(bl3 = string2.contains(string.toUpperCase())) : !(bl3 = string3.toUpperCase().contains(string.toUpperCase()))) continue;
            }
            Boolean bl4 = Boolean.FALSE;
            if (!bl) {
                bl4 = aVMeasure.isSelected();
            }
            this.measureTableModel.addRow(new Object[]{bl4, string2, aVMeasure.getDescription()});
            ++this.totalRows;
            if (!bl4.booleanValue()) continue;
            ++this.selectedRows;
        }
        this.updateSelectAll();
    }

    public int getSelectedMeasuresCount() {
        return this.selectedRows;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getColumn();
        if (n == -1) {
            return;
        }
        if (tableModelEvent.getSource() == this.measureTableModel && tableModelEvent.getType() == 0) {
            this.updateMeasureTableModelFromCell(n, n2);
        }
    }

    private void updateMeasureTableModelFromCell(int n, int n2) {
        if (n2 != 0) {
            return;
        }
        String string = (String)this.measureTable.getValueAt(n, 1);
        Object object = this.measureTable.getValueAt(n, n2);
        Boolean bl = (Boolean)object;
        for (AVMeasure aVMeasure : this.av.getMeasures()) {
            String string2 = this.prov.getExternalName(aVMeasure.getName());
            if (!string2.equals(string)) continue;
            aVMeasure.setSelected(bl);
            if (bl.booleanValue() && this.selectedRows < this.totalRows) {
                ++this.selectedRows;
                break;
            }
            if (bl.booleanValue() || this.selectedRows <= 0) break;
            --this.selectedRows;
            break;
        }
        this.updateSelectAll();
        for (PropertyChangeListener propertyChangeListener : this.listeners) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.measureTable, string, bl == false, bl);
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    private void layoutComponents() {
        this.topLabel = new JLabel(HCSArb.getString("AV_CACHE_MEASURE_SELECTION_INSTRUCTIONS_LABEL"));
        this.topLabel.setName("topLabel");
        this.measureTable = new JTable(this.measureTableModel){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                return component;
            }
        };
        this.measureTable.setName("measureTable");
        this.measureTable.setAutoResizeMode(0);
        JLabel jLabel = new JLabel(HCSArb.get("MEASURE_FILTER"));
        jLabel.setName("measureFilterLabel");
        this.measureFilterFld = new SearchField(SearchField.Style.FILTER);
        this.measureFilterFld.setName("measureFilterFld");
        this.measuresPanel = new JPanel();
        this.measuresPanel.setName("measuresPanel");
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setName("measureScrollPane");
        jScrollPane.getViewport().add(this.measureTable);
        this.measuresPanel.setLayout(new GridBagLayout());
        int n = 0;
        this.measuresPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 5, 0));
        this.measuresPanel.add((Component)this.measureFilterFld, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 5, 0));
        this.measuresPanel.add((Component)jScrollPane, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        n = 0;
        this.add((Component)this.topLabel, new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 5, 0));
        this.add((Component)this.measuresPanel, new GridBagConstraints(0, ++n, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.measureFilterFld.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent searchEvent) {
                AVCacheMeasureSelectionPanel.this.loadMeasureTable(false);
            }

            public void searchCategoryChanged(SearchEvent searchEvent) {
            }
        });
    }

    private void updateSelectAll() {
        if (this.selectedRows == this.totalRows && this.selectedRows > 0) {
            this.checkBoxHeader.setSelected(true);
        } else if (this.selectedRows < this.totalRows) {
            this.checkBoxHeader.setSelected(false);
        } else if (this.selectedRows == 0) {
            this.checkBoxHeader.setSelected(false);
        }
        this.measureTable.getTableHeader().repaint();
    }

    private List<AVMeasure> sortMeasures(AVMeasure[] aVMeasureArray) {
        ArrayList<AVMeasure> arrayList = new ArrayList<AVMeasure>();
        for (AVMeasure aVMeasure : aVMeasureArray) {
            arrayList.add(aVMeasure);
        }
        Collections.sort(arrayList, new Comparator<AVMeasure>(){

            @Override
            public int compare(AVMeasure aVMeasure, AVMeasure aVMeasure2) {
                String string = aVMeasure.getName();
                String string2 = aVMeasure2.getName();
                return string.compareTo(string2);
            }
        });
        return arrayList;
    }
}

