/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import oracle.hcs.HCSArb;
import oracle.hcs.av.panels.AttributeDimensionNode;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.ui.treetable.TreeTableModel;

public class AttributeDimensionTreeTableModel
implements TreeTableModel {
    private static String[] columns = new String[]{HCSArb.getString("ATTRIBUTE_DIMENSION_NODE_NAME_LABEL"), HCSArb.getString("ATTRIBUTE_DIMENSION_NODE_DESCRIPTION_LABEL")};
    protected static final Class[] cTypes = new Class[]{TreeTableModel.class, String.class, String.class};
    private AttributeDimensionNode rootNode;
    private Map<String, List<AttributeDimension>> dimensionsMap;
    private DBObjectProvider prov;
    private HCSSchema schema;

    public AttributeDimensionTreeTableModel(DBObjectProvider dBObjectProvider, List<AttributeDimension> list, HCSSchema hCSSchema) {
        this.prov = dBObjectProvider;
        this.schema = hCSSchema;
        this.rootNode = new AttributeDimensionNode(dBObjectProvider, null, "");
        this.rootNode.setIsRoot(true);
        this.dimensionsMap = new HashMap<String, List<AttributeDimension>>();
        this.addDimensions(list);
        this.populate();
    }

    private void addDimensions(List<AttributeDimension> list) {
        this.dimensionsMap.clear();
        for (AttributeDimension attributeDimension : list) {
            String string = attributeDimension.getName();
            if (!this.isDimensionUsedInHierarchies(string)) continue;
            String string2 = attributeDimension.getSchema().getName();
            if (this.dimensionsMap.containsKey(string2)) {
                this.dimensionsMap.get(string2).add(attributeDimension);
                continue;
            }
            ArrayList<AttributeDimension> arrayList = new ArrayList<AttributeDimension>();
            arrayList.add(attributeDimension);
            this.dimensionsMap.put(string2, arrayList);
        }
    }

    private boolean isDimensionUsedInHierarchies(String string) {
        for (Hierarchy hierarchy : this.schema.getHierarchies()) {
            String string2;
            AttributeDimension attributeDimension = hierarchy.getDimension();
            if (attributeDimension == null || !string.equals(string2 = attributeDimension.getName())) continue;
            return true;
        }
        return false;
    }

    public int getColumnCount() {
        return columns.length;
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    public Object getValueAt(Object object, int n) {
        AttributeDimensionNode attributeDimensionNode = (AttributeDimensionNode)object;
        switch (n) {
            case 0: {
                if (attributeDimensionNode.getName() != null && !attributeDimensionNode.getName().equalsIgnoreCase("")) {
                    return attributeDimensionNode.getName();
                }
                if (attributeDimensionNode.getSchemaName() != null && !attributeDimensionNode.getSchemaName().equalsIgnoreCase("")) {
                    return HCSArb.format("ATTRIBUTE_DIMENSION_NODE_SCHEMA_LABEL", attributeDimensionNode.getSchemaName());
                }
            }
            case 1: {
                return attributeDimensionNode.getDescription();
            }
        }
        return "";
    }

    public boolean isCellEditable(Object object, int n) {
        return false;
    }

    public void setValueAt(Object object, Object object2, int n) {
    }

    public Object getRoot() {
        return this.rootNode;
    }

    protected Object[] getChildren(Object object) {
        AttributeDimensionNode attributeDimensionNode = (AttributeDimensionNode)object;
        return attributeDimensionNode.getChildren();
    }

    public Object getChild(Object object, int n) {
        return this.getChildren(object)[n];
    }

    public int getChildCount(Object object) {
        AttributeDimensionNode attributeDimensionNode = (AttributeDimensionNode)object;
        return attributeDimensionNode.getChildren().length;
    }

    public boolean isLeaf(Object object) {
        AttributeDimensionNode attributeDimensionNode = (AttributeDimensionNode)object;
        return attributeDimensionNode.getChildren().length == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        return 0;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    public void populate() {
        for (String string : this.dimensionsMap.keySet()) {
            AttributeDimensionNode attributeDimensionNode = this.rootNode.addHierarchyDimensionNode(string);
            for (AttributeDimension attributeDimension : this.dimensionsMap.get(string)) {
                attributeDimensionNode.addHierarchyDimensionNode(attributeDimension);
            }
        }
    }

    public void populate(String string, String string2) {
        for (String string3 : this.dimensionsMap.keySet()) {
            AttributeDimensionNode attributeDimensionNode = this.rootNode.addHierarchyDimensionNode(string3);
            for (AttributeDimension attributeDimension : this.dimensionsMap.get(string3)) {
                if (string != null && string.length() > 0) {
                    boolean bl = false;
                    if (string2 != null && string2.length() > 0) {
                        if (string2.equalsIgnoreCase(HCSArb.getString("ATTRIBUTE_DIMENSION_NODE_NAME_LABEL"))) {
                            bl = attributeDimension.getName().contains(string.toUpperCase());
                        } else if (string2.equalsIgnoreCase(HCSArb.getString("ATTRIBUTE_DIMENSION_NODE_DESCRIPTION_LABEL"))) {
                            bl = attributeDimension.getDescription().toUpperCase().contains(string.toUpperCase());
                        }
                    }
                    if (!bl) continue;
                }
                attributeDimensionNode.addHierarchyDimensionNode(attributeDimension);
            }
        }
    }

    public void setDimensions(List<AttributeDimension> list) {
        this.clear();
        this.addDimensions(list);
    }

    public void clear() {
        this.rootNode.clearChildren();
    }
}

