/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.av.AVPanelLibrary;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.panels.AVHierarchiesTreeRenderer;
import oracle.hcs.av.panels.HierarchyAliasCellEditor;
import oracle.hcs.av.panels.HierarchyNode;
import oracle.hcs.av.panels.HierarchyTreeTableModel;
import oracle.hcs.av.panels.IsDefaultHierarchyCellEditor;
import oracle.hcs.av.panels.IsDefaultHierarchyCellRenderer;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.treetable.JFastTreeTable;

public class AVHierarchiesPanel
extends BaseEditorPanel<AnalyticView> {
    private HierarchyTreeTableModel treeModel;
    private JFastTreeTable treeTable;
    private DBObjectProvider prov;
    private static final int DIMENSION_NAME_COLUMN = 0;
    protected static final int HIERARCHY_ALIAS_COLUMN = 1;
    private static final int HIERARCHY_INCLUDE_COLUMN = 2;
    private static final int HIERARCHY_DEFAULT_COLUMN = 3;
    private boolean initialized;
    private HCSSchema schema;
    private Map<AVHierarchy, AVDimensionality> avHiersToSync;
    private static final Logger LOG = Logger.getLogger(AVHierarchiesPanel.class.getName());

    protected void initialisePanel() {
        this.initAVHierarchies();
        this.prov = this.getProvider();
        if (!this.initialized) {
            this.initialized = true;
            this.avHiersToSync = new HashMap<AVHierarchy, AVDimensionality>();
            this.layoutComponents();
        }
        JTree jTree = this.treeTable.getTree();
        if (this.isEditing()) {
            this.syncRenamedOrDeletedAVHierarchies(this.avHiersToSync);
        }
        this.treeModel.clear();
        this.treeModel.populate(this.prov, ((AnalyticView)this.getUpdatedObject()).getDimensions());
        TableColumn tableColumn = this.treeTable.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(new IsDefaultHierarchyCellEditor());
        tableColumn.setCellRenderer(new IsDefaultHierarchyCellRenderer(jTree));
        tableColumn = this.treeTable.getColumnModel().getColumn(3);
        tableColumn.setCellEditor(new IsDefaultHierarchyCellEditor());
        tableColumn.setCellRenderer(new IsDefaultHierarchyCellRenderer(jTree));
        TableColumn tableColumn2 = this.treeTable.getColumnModel().getColumn(1);
        tableColumn2.setCellEditor(new HierarchyAliasCellEditor(this.prov));
        jTree.setRowHeight(this.treeTable.getRowHeight());
        jTree.expandRow(0);
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        this.treeTable.updateUI();
        for (int i = 0; i < this.treeTable.getRowCount(); ++i) {
            jTree.expandRow(i);
        }
    }

    private void initAVHierarchies() {
        AnalyticView analyticView = (AnalyticView)this.getUpdatedObject();
        List list = new ArrayList();
        list = (List)this.getDataContext().get("hierarchies");
        for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
            String string = aVDimensionality.getName();
            for (Hierarchy hierarchy : list) {
                AVHierarchy aVHierarchy;
                String string2 = hierarchy.getName();
                String string3 = hierarchy.getDimensionName();
                if (!string3.equals(string) || string2.endsWith("_") || (aVHierarchy = aVDimensionality.findHierarchy(string2)) != null) continue;
                aVHierarchy = this.findCachedAVHierarchy(string2, aVDimensionality);
                if (aVHierarchy == null) {
                    AttributeDimension attributeDimension = hierarchy.getDimension();
                    AttributeDimension attributeDimension2 = aVDimensionality.getDimension();
                    if (attributeDimension == null && attributeDimension2 != null) {
                        hierarchy.setDimension(attributeDimension2);
                    }
                    aVHierarchy = new AVHierarchy(hierarchy);
                }
                aVDimensionality.addHierarchy(aVHierarchy);
            }
        }
    }

    private void syncRenamedOrDeletedAVHierarchies(Map<AVHierarchy, AVDimensionality> map) {
        for (AVHierarchy aVHierarchy : map.keySet()) {
            String string = aVHierarchy.getName();
            AVDimensionality aVDimensionality = map.get(aVHierarchy);
            AVHierarchy aVHierarchy2 = aVDimensionality.findHierarchy(string);
            Hierarchy hierarchy = this.schema.findHierarchy(string);
            if (aVHierarchy2 != null || hierarchy != null) continue;
            aVDimensionality.addHierarchy(aVHierarchy);
        }
        map.clear();
    }

    private AVHierarchy findCachedAVHierarchy(String string, AVDimensionality aVDimensionality) {
        if (this.avHiersToSync != null) {
            for (AVHierarchy aVHierarchy : this.avHiersToSync.keySet()) {
                String string2 = aVHierarchy.getName();
                AVDimensionality aVDimensionality2 = this.avHiersToSync.get(aVHierarchy);
                if (!string2.equals(string) || aVDimensionality2 != aVDimensionality) continue;
                return aVHierarchy;
            }
        }
        return null;
    }

    protected void commitPanel() throws TraversalException {
        AnalyticView analyticView = (AnalyticView)this.getUpdatedObject();
        AnalyticView analyticView2 = (AnalyticView)this.getOriginalObject();
        this.stopCellEditing();
        for (AVDimensionality aVDimensionality : ((AnalyticView)this.getUpdatedObject()).getDimensions()) {
            aVDimensionality.removeAllHierarchies();
        }
        HierarchyNode hierarchyNode = (HierarchyNode)this.treeModel.getRoot();
        for (Object object : hierarchyNode.getChildren()) {
            HierarchyNode hierarchyNode2 = (HierarchyNode)object;
            String string = hierarchyNode2.getDimensionAlias();
            string = UIStringUtils.stripDoubleQuotes(string);
            AVDimensionality aVDimensionality = analyticView.findDimensionalityForAlias(string);
            if (hierarchyNode2.getChildren().length <= 0) continue;
            for (Object object2 : hierarchyNode2.getChildren()) {
                HierarchyNode hierarchyNode3 = (HierarchyNode)object2;
                AVHierarchy aVHierarchy = hierarchyNode3.getHierarchy();
                if (aVHierarchy.isHierarchyIncluded()) {
                    aVDimensionality.addHierarchy(aVHierarchy);
                    continue;
                }
                if (!this.avHiersToSync.containsKey(aVHierarchy)) {
                    this.avHiersToSync.put(aVHierarchy, aVDimensionality);
                }
                aVDimensionality.removeHierarchy(aVHierarchy);
                analyticView.manageCacheMeasureGroupHierarchyIncludeChanged(this.prov, aVHierarchy, true, false);
            }
        }
        if (this.isEditing()) {
            Object object;
            Database database = (Database)this.getProvider();
            Namespace namespace = this.getDataContext();
            PanelLibrary panelLibrary = (PanelLibrary)namespace.find(PanelLibrary.class);
            object = (AVPanelLibrary)panelLibrary;
            ((AVPanelLibrary)object).reconcileDependencies(database, (SystemObject)analyticView2, (SystemObject)analyticView);
        }
    }

    private void stopCellEditing() {
        TableCellEditor tableCellEditor = this.treeTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    private HCSSchema getSchema() {
        Connection connection = ((Database)this.getProvider()).getConnection();
        String string = Connections.getInstance().getConnectionName(connection);
        HCSSchema hCSSchema = null;
        try {
            String string2 = ((AnalyticView)this.getUpdatedObject()).getSchema().getName();
            hCSSchema = HCSMetadataCache.getUpdatedSchema(string, string2);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Reading cache", exception);
        }
        return hCSSchema;
    }

    private void layoutComponents() {
        Serializable serializable;
        int n3;
        this.setName(((Object)((Object)this)).getClass().getName());
        this.setLayout(new GridBagLayout());
        this.treeModel = new HierarchyTreeTableModel();
        this.treeTable = new JFastTreeTable(this.treeModel){

            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                int n = this.rowAtPoint(mouseEvent.getPoint());
                JTree jTree = AVHierarchiesPanel.this.treeTable.getTree();
                TreePath treePath = jTree.getPathForRow(n);
                if (treePath != null) {
                    Hierarchy hierarchy;
                    HierarchyNode hierarchyNode = (HierarchyNode)treePath.getLastPathComponent();
                    String string2 = hierarchyNode.getHierarchyName();
                    AVHierarchy aVHierarchy = hierarchyNode.getHierarchy();
                    boolean bl = false;
                    if (aVHierarchy != null && (hierarchy = aVHierarchy.getHierarchy()) != null) {
                        bl = hierarchy.isValid();
                    }
                    if (!bl && hierarchyNode.getNodeContentType().equals((Object)HierarchyNode.NodeContentType.HIERARCHY_NODE)) {
                        string = HCSArb.format("AV_HIERARCHIES_PANEL_TOOLTIP", string2);
                    }
                }
                return string;
            }
        };
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.registerComponent((Component)this.treeTable, "dimensions");
        int[] nArray = new int[]{350, 175, 65, 65};
        int[] nArray2 = new int[]{150, 100, 50, 50};
        int n2 = 0;
        for (int n3 : nArray) {
            serializable = this.treeTable.getColumnModel().getColumn(n2++);
            ((TableColumn)serializable).setMinWidth(nArray2[n2 - 1]);
            ((TableColumn)serializable).setPreferredWidth(n3);
        }
        this.treeTable.setCellSelectionEnabled(true);
        this.treeTable.setRowSelectionAllowed(false);
        this.treeTable.setColumnSelectionAllowed(false);
        Object object = this.treeTable.getTree();
        AVHierarchiesTreeRenderer aVHierarchiesTreeRenderer = new AVHierarchiesTreeRenderer();
        this.schema = this.getSchema();
        aVHierarchiesTreeRenderer.setSchema(this.schema);
        ((JTree)object).setCellRenderer((TreeCellRenderer)((Object)aVHierarchiesTreeRenderer));
        this.treeTable.setShowGrid(true);
        this.treeTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                int n = AVHierarchiesPanel.this.treeTable.getSelectedColumn();
                TableColumn tableColumn = AVHierarchiesPanel.this.treeTable.getColumnModel().getColumn(n);
                int n2 = tableColumn.getModelIndex();
                switch (n2) {
                    case 2: 
                    case 3: {
                        if (keyEvent.getKeyChar() != ' ') break;
                        AVHierarchiesPanel.this.includeAndDefaultColumnLogic();
                        break;
                    }
                    case 0: {
                        if (keyEvent.getKeyChar() != ' ') break;
                        AVHierarchiesPanel.this.expandOrCollapsePath();
                    }
                }
            }
        });
        this.treeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = AVHierarchiesPanel.this.treeTable.getSelectedColumn();
                TableColumn tableColumn = AVHierarchiesPanel.this.treeTable.getColumnModel().getColumn(n);
                int n2 = tableColumn.getModelIndex();
                switch (n2) {
                    case 2: 
                    case 3: {
                        AVHierarchiesPanel.this.treeTable.forwardEventToTree(mouseEvent);
                        break;
                    }
                    case 0: {
                        AVHierarchiesPanel.this.expandOrCollapsePath();
                    }
                }
            }
        });
        ((Component)object).addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                AVHierarchiesPanel.this.includeAndDefaultColumnLogic();
            }
        });
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        n3 = 0;
        serializable = new JScrollPane();
        ((JScrollPane)serializable).getViewport().add((Component)this.treeTable);
        componentWithTitlebar.setComponent((JComponent)serializable);
        componentWithTitlebar.setLabel(new JLabel(HCSArb.get("HIERARCHIES_TITLE")));
        this.add((Component)componentWithTitlebar, new GridBagConstraints(0, ++n3, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 12), 0, 0));
    }

    private void includeAndDefaultColumnLogic() {
        JTree jTree = this.treeTable.getTree();
        int n = this.treeTable.getSelectedRow();
        int n2 = this.treeTable.getSelectedColumn();
        TableColumn tableColumn = this.treeTable.getColumnModel().getColumn(n2);
        int n3 = tableColumn.getModelIndex();
        HierarchyNode hierarchyNode = (HierarchyNode)jTree.getPathForRow(n).getLastPathComponent();
        HierarchyNode hierarchyNode2 = (HierarchyNode)jTree.getPathForRow(n).getParentPath().getLastPathComponent();
        if (hierarchyNode.getNodeContentType().equals((Object)HierarchyNode.NodeContentType.HIERARCHY_NODE)) {
            block0 : switch (n3) {
                case 2: {
                    if (!hierarchyNode2.getNodeContentType().equals((Object)HierarchyNode.NodeContentType.DIMENSION_NODE) || hierarchyNode2.getChildren().length <= 1) break;
                    hierarchyNode.setIncludeHierarchy(!hierarchyNode.isHierarchyIncluded());
                    if (!hierarchyNode.isHierarchyIncluded()) {
                        if (!hierarchyNode.isHierarchyDefault()) break;
                        hierarchyNode.setIsDefaultHierarchy(false);
                        for (Object object : hierarchyNode2.getChildren()) {
                            HierarchyNode hierarchyNode3 = (HierarchyNode)object;
                            if (hierarchyNode3.getHierarchyName().equalsIgnoreCase(hierarchyNode.getHierarchyName()) || !hierarchyNode3.isHierarchyIncluded()) continue;
                            hierarchyNode3.setIsDefaultHierarchy(true);
                            break block0;
                        }
                        break;
                    }
                    if (hierarchyNode2.getChildren().length == 1) {
                        hierarchyNode.setIsDefaultHierarchy(true);
                        break;
                    }
                    boolean bl = false;
                    for (Object object : hierarchyNode2.getChildren()) {
                        HierarchyNode hierarchyNode4 = (HierarchyNode)object;
                        if (hierarchyNode4.getHierarchyName().equalsIgnoreCase(hierarchyNode.getHierarchyName()) || !hierarchyNode4.isHierarchyIncluded() || !hierarchyNode4.isHierarchyDefault()) continue;
                        bl = true;
                        break;
                    }
                    if (bl) break;
                    hierarchyNode.setIsDefaultHierarchy(true);
                    break;
                }
                case 3: {
                    if (hierarchyNode.isHierarchyDefault() || !hierarchyNode.isHierarchyIncluded()) break;
                    hierarchyNode.setIsDefaultHierarchy(true);
                    for (Object object : hierarchyNode2.getChildren()) {
                        HierarchyNode hierarchyNode5 = (HierarchyNode)object;
                        if (hierarchyNode5.getHierarchyName().equalsIgnoreCase(hierarchyNode.getHierarchyName())) continue;
                        hierarchyNode5.setIsDefaultHierarchy(false);
                    }
                    break;
                }
            }
            this.treeTable.updateUI();
        }
    }

    private void expandOrCollapsePath() {
        int n;
        JTree jTree = this.treeTable.getTree();
        TreePath treePath = jTree.getPathForRow(n = this.treeTable.getSelectedRow());
        HierarchyNode hierarchyNode = (HierarchyNode)treePath.getLastPathComponent();
        if (hierarchyNode.isParent()) {
            if (jTree.isCollapsed(treePath)) {
                jTree.expandPath(treePath);
            } else {
                jTree.collapsePath(treePath);
            }
        }
    }
}

