/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.av.AVInitializer;
import oracle.hcs.av.AVPanelLibrary;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AVCacheLevelGroup;
import oracle.hcs.av.model.cache.AVCacheLevelGroupDimHierLevel;
import oracle.hcs.av.model.cache.AVCacheMeasureGroup;
import oracle.hcs.av.model.cache.AVCacheMeasureProviderContext;
import oracle.hcs.av.panels.AVDimensionalityTablePanel;
import oracle.hcs.db.DBStringUtils;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.db.panels.GeneralBaseSourceEditorPanel;
import oracle.hcs.db.source.Column;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.db.source.DatabaseSource;
import oracle.hcs.db.source.Table;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchy.model.HierarchyLevel;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AVGeneralPanel
extends GeneralBaseSourceEditorPanel<AnalyticView> {
    private static final Logger LOG = Logger.getLogger(AVGeneralPanel.class.getName());
    private List<AttributeDimension> allDimensions;
    private List<Hierarchy> allHierarchies;
    private boolean m_initialized;
    private AVDimensionalityTablePanel dimensionsPanel;
    public static final String ALL_DIMENSIONS = "dimensions";
    public static final String ALL_HIERARCHIES = "hierarchies";
    private HCSSchema schema;
    private String schemaName;
    private List<DatabaseSource> dbSources;

    public AVGeneralPanel() {
        this.layoutComponents();
        this.setDbObjectInitializer(new AVInitializer());
    }

    @Override
    protected void afterSourceChanged() {
        String string;
        String string2 = "";
        String string3 = "";
        List<DatabaseSource> list = null;
        if (this.getSource() != null) {
            string2 = this.getSource().getName();
        } else {
            string = this.getSourceTextFieldText();
            if (string != null && !string.isEmpty()) {
                if (list == null || list.size() == 0) {
                    list = this.createNonExistingSource(string);
                }
                string3 = list.get(0).getSchemaName();
                string2 = list.get(0).getName();
            }
        }
        string = ((AnalyticView)this.getUpdatedObject()).getavSourceTable();
        String string4 = ((AnalyticView)this.getUpdatedObject()).getavSourceTableOwner();
        if (string != null && !string2.equals(string) || string4 != null && !string3.equals(string4)) {
            ((AnalyticView)this.getUpdatedObject()).removeAllMeasures();
        }
        this.dimensionsPanel.setSource(this.getSource());
        this.dimensionsPanel.deriveDimensionality(this.sourceMessageLabel);
        this.dimensionsPanel.autoMap();
    }

    private String getSourceQualifiedName(String string, String string2, String string3) {
        if (!string.equals(string2)) {
            return String.format("%s.%s", DBStringUtils.externalizeName(string2), DBStringUtils.externalizeName(string3));
        }
        return string3;
    }

    @Override
    protected void sourcesCleared() {
        super.sourcesCleared();
        this.dimensionsPanel.clearMapping();
    }

    @Override
    protected DatabaseSource[] getDBObjectSources() {
        List<DatabaseSource> list;
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        String string = ((AnalyticView)this.getUpdatedObject()).getavSourceTable();
        String string2 = ((AnalyticView)this.getUpdatedObject()).getavSourceTableOwner();
        String string3 = oracleDatabaseImpl.getExternalName(string);
        String string4 = oracleDatabaseImpl.getExternalName(string2);
        Schema schema = new Schema(string4);
        if (string != null && !(list = this.getSourcesWithColumns(oracleDatabaseImpl, schema, string3)).isEmpty()) {
            DatabaseSource databaseSource = list.get(0);
            DatabaseSource[] databaseSourceArray = new DatabaseSource[]{databaseSource};
            return databaseSourceArray;
        }
        return null;
    }

    @Override
    protected void setUnknownTableSource() {
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        String string = ((AnalyticView)this.getUpdatedObject()).getavSourceTable();
        String string2 = ((AnalyticView)this.getUpdatedObject()).getavSourceTableOwner();
        String string3 = oracleDatabaseImpl.getExternalName(string);
        if (this.schemaName != null && !this.schemaName.equals(string2)) {
            string3 = String.format("%s.%s", oracleDatabaseImpl.getExternalName(string2), oracleDatabaseImpl.getExternalName(string));
        }
        this.setSourceTextField(string3);
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.dimensionsPanel.setUpdatedObject((AnalyticView)this.getUpdatedObject());
        OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getProvider();
        if (!this.m_initialized) {
            this.m_initialized = true;
            AVCacheMeasureProviderContext aVCacheMeasureProviderContext = AVCacheMeasureProviderContext.getInstance();
            aVCacheMeasureProviderContext.setProvider(this.getProvider());
            AVPanelLibrary aVPanelLibrary = this.getAVPanelLibraryInstance();
            aVPanelLibrary.initReconcileDependencies();
            Connection connection = ((Database)this.getProvider()).getConnection();
            String string = Connections.getInstance().getConnectionName(connection);
            try {
                this.schemaName = ((AnalyticView)this.getUpdatedObject()).getSchema().getName();
                this.schema = HCSMetadataCache.getUpdatedSchema(string, this.schemaName);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Reading cache", exception);
            }
            this.allDimensions = this.schema.getDimensions();
            this.allHierarchies = this.schema.getHierarchies();
            this.getDataContext().put(ALL_DIMENSIONS, this.allDimensions);
            this.getDataContext().put(ALL_HIERARCHIES, this.allHierarchies);
            this.updateCacheLevelGroupNames(this.schema);
            this.dimensionsPanel.setHierarchyDimensions(this.allDimensions);
            this.dimensionsPanel.setAllHierarchies(this.allHierarchies);
            this.dimensionsPanel.setSource(this.getSource());
            this.dimensionsPanel.setProvider((DBObjectProvider)oracleDatabaseImpl);
            this.dimensionsPanel.setSchema(this.schema);
            this.dimensionsPanel.loadTableData();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void commitPanel() throws TraversalException {
        Object object;
        Object object2;
        int n2;
        Object object4;
        String[] stringArray;
        Object object5;
        Object object6;
        String string;
        Column[] columnArray;
        AnalyticView analyticView = (AnalyticView)this.getOriginalObject();
        AnalyticView analyticView2 = (AnalyticView)this.getUpdatedObject();
        Database database = (Database)this.getProvider();
        super.commitPanel();
        this.dimensionsPanel.commitCellEdit();
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.dimensionsPanel.getDimensionsCount(); ++i) {
            boolean bl;
            columnArray = this.dimensionsPanel.getDimension(i);
            columnArray = UIStringUtils.stripDoubleQuotes((String)columnArray);
            string = this.dimensionsPanel.getDimensionAlias(i);
            string = UIStringUtils.stripDoubleQuotes(string);
            object6 = this.dimensionsPanel.getDimensionality(i);
            boolean bl2 = bl = object6.getParent() == null;
            if (bl) {
                hashMap.put(string, true);
            }
            ((AVDimensionality)object6).setPhysicalOrder(i);
            object5 = this.dimensionsPanel.getDimensionKey(i);
            stringArray = ((String)object5).split("\\s*,\\s*");
            object4 = new String[stringArray.length];
            n2 = 0;
            for (String string2 : stringArray) {
                String string3 = database.getInternalName(string2);
                object4[n2] = string3;
                ++n2;
            }
            ((AVDimensionality)object6).setMapExpressions((String[])object4);
            String string3 = this.dimensionsPanel.getDimensionAttribute(i);
            String[] abstractChildDBObject2 = string3.split("\\s*,\\s*");
            object2 = new String[abstractChildDBObject2.length];
            n2 = 0;
            for (String string4 : abstractChildDBObject2) {
                String string5;
                object2[n2] = string5 = database.getInternalName(string4);
                ++n2;
            }
            ((AVDimensionality)object6).setMappedDimensions((String[])object2);
            ((AVDimensionality)object6).setDimensionAlias(string);
            arrayList.add(object6);
        }
        AVDimensionality[] aVDimensionalityArray = arrayList.toArray(new AVDimensionality[arrayList.size()]);
        analyticView2.setDimensions(aVDimensionalityArray);
        columnArray = new Column[]{};
        string = analyticView2.getavSourceTable();
        object6 = analyticView2.getavSourceTableOwner();
        DatabaseSource databaseSource = this.getSource();
        if (databaseSource != null) {
            columnArray = databaseSource.getColumns();
            object5 = databaseSource.getName();
            stringArray = databaseSource.getSchemaName();
            if (string != null && !((String)object5).equals(string) || object6 != null && !stringArray.equals(object6)) {
                analyticView2.removeAllMeasures();
            }
            analyticView2.setavSourceTable((String)object5);
            analyticView2.setavSourceTableOwner((String)stringArray);
        }
        object5 = this.dimensionsPanel.getSourceColumns();
        analyticView2.setSourceColumns((List<ColumnIdentifier>)object5);
        boolean bl = true;
        if (analyticView2.getMeasures().length == 0 && analyticView2.getDimensions().length > 0) {
            bl = false;
            object4 = columnArray;
            n2 = ((AbstractChildDBObject[])object4).length;
            for (int i = 0; i < n2; ++i) {
                AbstractChildDBObject abstractChildDBObject = object4[i];
                object2 = abstractChildDBObject.getName();
                if (this.columnMapsDimensionality((String)object2, analyticView2.getDimensions()) || !abstractChildDBObject.isNumeric()) continue;
                AVMeasure aVMeasure = analyticView2.findMeasure((String)object2);
                if (aVMeasure != null) {
                    if (!aVMeasure.isDefaultMeasure()) continue;
                    bl = true;
                    continue;
                }
                AVMeasure[] aVMeasureArray = analyticView2.getMeasures();
                int n = 0;
                for (AVMeasure aVMeasure2 : aVMeasureArray) {
                    object = aVMeasure2.getMapExpression();
                    if (object == null || !((String)object).equals(object2)) continue;
                    n = 1;
                    if (!aVMeasure2.isDefaultMeasure()) continue;
                    bl = true;
                }
                if (n != 0) continue;
                AVMeasure aVMeasure3 = new AVMeasure();
                aVMeasure3.setName((String)object2);
                aVMeasure3.setCaption((String)object2);
                aVMeasure3.setDescription((String)object2);
                aVMeasure3.setMapExpression((String)object2);
                aVMeasure3.setMeasureFormat(null);
                analyticView2.addMeasure(aVMeasure3);
            }
        }
        if (!bl && (object4 = analyticView2.getMeasures()) != null && ((AbstractChildDBObject[])object4).length > 0) {
            object4[0].setDefaultMeasure(true);
            analyticView2.setDefaultMeasure(object4[0].getName());
        }
        for (AbstractChildDBObject abstractChildDBObject : analyticView2.getDimensions()) {
            void var21_53;
            Object object3;
            boolean bl3;
            object2 = UIStringUtils.stripDoubleQuotes(abstractChildDBObject.getName());
            boolean bl4 = false;
            if (abstractChildDBObject.getDimension() == null) {
                for (AttributeDimension attributeDimension : this.allDimensions) {
                    String string6 = attributeDimension.getName();
                    if (!object2.equals(string6)) continue;
                    abstractChildDBObject.setDimension(attributeDimension);
                    bl3 = true;
                }
            }
            if (!bl3 && abstractChildDBObject.getDimension() == null) {
                object3 = new AttributeDimension();
                object3.setName((String)object2);
                object3.setSchema((Schema)this.schema);
                abstractChildDBObject.setDimension((AttributeDimension)object3);
            }
            object3 = abstractChildDBObject.getHierarchies();
            int n = ((AVHierarchy[])object3).length;
            boolean bl5 = false;
            while (var21_53 < n) {
                AVHierarchy aVHierarchy = object3[var21_53];
                String string7 = abstractChildDBObject.getName();
                String string8 = aVHierarchy.getName();
                if (aVHierarchy.getHierarchy() == null) {
                    AttributeDimension attributeDimension;
                    object = this.findHierarchy(string8);
                    if (object == null) {
                        Hierarchy hierarchy = new Hierarchy(this.schema, string8, string7);
                        attributeDimension = abstractChildDBObject.getDimension();
                        hierarchy.setDimension(attributeDimension);
                        aVHierarchy.setHierarchy(hierarchy);
                    } else {
                        AttributeDimension attributeDimension2 = ((Hierarchy)object).getDimension();
                        attributeDimension = abstractChildDBObject.getDimension();
                        if (attributeDimension2 == null && attributeDimension != null) {
                            ((Hierarchy)object).setDimension(attributeDimension);
                        }
                        aVHierarchy.setHierarchy((Hierarchy)object);
                    }
                }
                ++var21_53;
            }
            for (Hierarchy hierarchy : this.allHierarchies) {
                String string9 = hierarchy.getName();
                String string10 = hierarchy.getDimensionName();
                if (!string10.equals(object2) || string9.endsWith("_")) continue;
                AVHierarchy aVHierarchy = abstractChildDBObject.findHierarchy(string9);
                if (hashMap.get(abstractChildDBObject.getDimensionAlias()) != null && ((Boolean)hashMap.get(abstractChildDBObject.getDimensionAlias())).booleanValue()) {
                    if (aVHierarchy != null) continue;
                    aVHierarchy = new AVHierarchy(hierarchy);
                    abstractChildDBObject.addHierarchy(aVHierarchy);
                    continue;
                }
                if (aVHierarchy == null || aVHierarchy.getHierarchy() != null) continue;
                aVHierarchy.setHierarchy(hierarchy);
            }
            if (hashMap.get(abstractChildDBObject.getDimensionAlias()) == null || !((Boolean)hashMap.get(abstractChildDBObject.getDimensionAlias())).equals(Boolean.TRUE)) continue;
            object3 = null;
            int n3 = 0;
            for (AVHierarchy aVHierarchy : abstractChildDBObject.getHierarchies()) {
                aVHierarchy.setHierarchyIncluded(Boolean.TRUE);
                aVHierarchy.setHierarchyDefault(Boolean.FALSE);
                for (Hierarchy hierarchy : this.allHierarchies) {
                    int n4;
                    if (!aVHierarchy.getName().equals(hierarchy.getName()) || (n4 = hierarchy.getHierarchyLevels().length) <= n3) continue;
                    n3 = n4;
                    object3 = aVHierarchy;
                }
            }
            if (object3 == null) continue;
            ((AVHierarchy)object3).setHierarchyDefault(Boolean.TRUE);
        }
        if (this.isEditing()) {
            object4 = this.getAVPanelLibraryInstance();
            ((AVPanelLibrary)object4).reconcileDependencies(database, (SystemObject)analyticView, (SystemObject)analyticView2);
        }
    }

    private List<DatabaseSource> createNonExistingSource(String string) {
        String[] stringArray = string.split(",");
        this.dbSources = new ArrayList<DatabaseSource>();
        for (String string2 : stringArray) {
            Table table = new Table(((AnalyticView)this.getUpdatedObject()).getSchema().getName(), string2);
            ArrayList<Column> arrayList = new ArrayList<Column>();
            Column column = new Column("COLUMN1", "N", "NUMBER");
            Column column2 = new Column("COLUMN2", "N", "NUMBER");
            arrayList.add(column);
            arrayList.add(column2);
            table.setColumns(arrayList.toArray(new Column[arrayList.size()]));
            this.dbSources.add(table);
        }
        this.setSources(this.dbSources);
        return this.dbSources;
    }

    private boolean columnMapsDimensionality(String string, AVDimensionality[] aVDimensionalityArray) {
        for (AVDimensionality aVDimensionality : aVDimensionalityArray) {
            if (aVDimensionality.getMapExpressions().length != 1 || !aVDimensionality.getMapExpressions()[0].equals(string)) continue;
            return true;
        }
        return false;
    }

    private Hierarchy findHierarchy(String string) {
        for (Hierarchy hierarchy : this.allHierarchies) {
            String string2 = hierarchy.getName();
            if (!string2.equals(string)) continue;
            return hierarchy;
        }
        return null;
    }

    private AVPanelLibrary getAVPanelLibraryInstance() {
        Namespace namespace = this.getDataContext();
        PanelLibrary panelLibrary = (PanelLibrary)namespace.find(PanelLibrary.class);
        return (AVPanelLibrary)panelLibrary;
    }

    @Override
    protected void layoutComponents() {
        super.layoutComponents();
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.registerComponent((Component)this.getSourceTextField(), "avSourceTable");
        this.registerDescriptionFields();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setName("AVGeneralPanel.PNL_CONTEXT");
        int n = this.layoutDescriptionFields(jPanel);
        n = this.layoutSource(jPanel, n);
        JPanel jPanel2 = new JPanel();
        jPanel2.setName("AVGeneralPanel.PNL_DETAILS");
        jPanel2.setLayout(new GridBagLayout());
        this.dimensionsPanel = new AVDimensionalityTablePanel();
        jPanel2.add((Component)this.dimensionsPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 0, 5), 0, 0));
        componentFactory.registerComponent((Component)this.dimensionsPanel, ALL_DIMENSIONS);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setName("pnlCenter");
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.setLayout(new BorderLayout());
        this.add(jPanel3, "Center");
    }

    private String generateHierarchyAlias(String string, String string2, int n) {
        String string3 = string2;
        if (string2.startsWith(string + "_") && string2.endsWith("_HIER")) {
            string3 = string2.substring(0, string2.length() - 5);
            if (string3.length() > string.length() + 1) {
                string3 = string3.substring(string.length() + 1, string3.length());
            }
        } else {
            string3 = string2 + Integer.toString(n);
        }
        return string3;
    }

    private void updateCacheLevelGroupNames(HCSSchema hCSSchema) {
        AVCacheMeasureGroup[] aVCacheMeasureGroupArray;
        AnalyticView analyticView = (AnalyticView)this.getUpdatedObject();
        for (AVCacheMeasureGroup aVCacheMeasureGroup : aVCacheMeasureGroupArray = analyticView.getCacheMeasureGroups()) {
            AVCacheLevelGroup[] aVCacheLevelGroupArray;
            for (AVCacheLevelGroup aVCacheLevelGroup : aVCacheLevelGroupArray = aVCacheMeasureGroup.getCacheLevelGroups()) {
                AVCacheLevelGroupDimHierLevel[] aVCacheLevelGroupDimHierLevelArray;
                for (AVCacheLevelGroupDimHierLevel aVCacheLevelGroupDimHierLevel : aVCacheLevelGroupDimHierLevelArray = aVCacheLevelGroup.getCacheLevelGroupHierLevels()) {
                    String string;
                    Object object;
                    String string2;
                    if (aVCacheLevelGroupDimHierLevel.getCacheLevelGroupDimHierLevelState() == 3) {
                        string2 = aVCacheLevelGroupDimHierLevel.getName();
                        object = this.findDimensionAndHierarchyAliasFromLevelName(hCSSchema, analyticView, string2);
                        string = (String)object[0] + "." + (String)object[1] + "." + string2;
                        aVCacheLevelGroupDimHierLevel.setName(string);
                        continue;
                    }
                    if (aVCacheLevelGroupDimHierLevel.getCacheLevelGroupDimHierLevelState() != 2) continue;
                    string2 = aVCacheLevelGroupDimHierLevel.getName();
                    object = new IdentifierElement(string2);
                    string = ((IdentifierElement)object).getFirst();
                    String string3 = ((IdentifierElement)object).getSecond();
                    String string4 = this.findDimensionAliasFromHierarchyAliasAndLevelName(hCSSchema, analyticView, string, string3);
                    String string5 = string4 + "." + string + "." + string3;
                    aVCacheLevelGroupDimHierLevel.setName(string5);
                }
            }
        }
    }

    private String[] findDimensionAndHierarchyAliasFromLevelName(HCSSchema hCSSchema, AnalyticView analyticView, String string) {
        AVDimensionality[] aVDimensionalityArray;
        String[] stringArray = new String[2];
        for (AVDimensionality aVDimensionality : aVDimensionalityArray = analyticView.getDimensions()) {
            AVHierarchy[] aVHierarchyArray;
            String string2 = aVDimensionality.getDimensionAlias();
            for (AVHierarchy aVHierarchy : aVHierarchyArray = aVDimensionality.getHierarchies()) {
                String string3 = aVHierarchy.getHierarchyAlias();
                String string4 = aVHierarchy.getHierarchyName();
                Hierarchy hierarchy = hCSSchema.findHierarchy(string4);
                if (hierarchy == null) continue;
                for (HierarchyLevel hierarchyLevel : hierarchy.getHierarchyLevels()) {
                    if (!hierarchyLevel.getLevelName().equals(string)) continue;
                    stringArray[0] = string2;
                    stringArray[1] = string3;
                    return stringArray;
                }
            }
        }
        return stringArray;
    }

    private String findDimensionAliasFromHierarchyAliasAndLevelName(HCSSchema hCSSchema, AnalyticView analyticView, String string, String string2) {
        AVDimensionality[] aVDimensionalityArray;
        String string3 = null;
        for (AVDimensionality aVDimensionality : aVDimensionalityArray = analyticView.getDimensions()) {
            AVHierarchy[] aVHierarchyArray;
            String string4 = aVDimensionality.getDimensionAlias();
            for (AVHierarchy aVHierarchy : aVHierarchyArray = aVDimensionality.getHierarchies()) {
                Hierarchy hierarchy;
                String string5 = aVHierarchy.getHierarchyAlias();
                String string6 = aVHierarchy.getHierarchyName();
                if (!string5.equals(string) || (hierarchy = hCSSchema.findHierarchy(string6)) == null) continue;
                for (HierarchyLevel hierarchyLevel : hierarchy.getHierarchyLevels()) {
                    if (!hierarchyLevel.getLevelName().equals(string2)) continue;
                    return string4;
                }
            }
        }
        return string3;
    }
}

