/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AVDimensionality;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.db.model.LanguageDescriptionsHelper;
import oracle.hcs.db.model.StatefulDescriptions;
import oracle.hcs.db.view.DescriptionPanel;
import oracle.hcs.hierarchy.model.Hierarchy;

public class AVDescriptionPanel
extends DescriptionPanel<AnalyticView> {
    @Override
    protected String getDescriptionXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HierarchyCube>\n");
        stringBuffer.append("     " + this.getDescXML("HierarchyCubeObject", ((AnalyticView)this.getUpdatedObject()).getName(), (Descriptions)this.getUpdatedObject()));
        if (((AnalyticView)this.getUpdatedObject()).getMeasures().length > 0) {
            stringBuffer.append("  <Measures type=\"\">\n");
            for (AVBaseMeasure aVBaseMeasure : ((AnalyticView)this.getUpdatedObject()).getMeasures()) {
                stringBuffer.append("     " + this.getDescXML("Measure", aVBaseMeasure));
            }
            stringBuffer.append("  </Measures>\n");
        }
        if (((AnalyticView)this.getUpdatedObject()).getCalculatedMeasures().length > 0) {
            stringBuffer.append("  <CalculatedMeasures type=\"\">\n");
            for (AVBaseMeasure aVBaseMeasure : ((AnalyticView)this.getUpdatedObject()).getCalculatedMeasures()) {
                stringBuffer.append("     " + this.getDescXML("CalculatedMeasure", aVBaseMeasure));
            }
            stringBuffer.append("  </CalculatedMeasures>\n");
        }
        stringBuffer.append("</HierarchyCube>\n");
        return stringBuffer.toString();
    }

    @Override
    protected String getDescriptionEditorXML() {
        return "/oracle/hcs/av/panels/avdesceditor.xml";
    }

    @Override
    protected String[] getObjectXPaths() {
        return new String[]{"/HierarchyCube/HierarchyCubeObject", "/HierarchyCube/Measures/*", "/HierarchyCube/CalculatedMeasures/*"};
    }

    @Override
    protected StatefulDescriptions findDBObjectWithDesc(String string, String string2) {
        if (string.equals("HierarchyCubeObject")) {
            return (StatefulDescriptions)this.getUpdatedObject();
        }
        if (string.equals("Measure")) {
            AVMeasure aVMeasure = ((AnalyticView)this.getUpdatedObject()).findMeasure(string2);
            return aVMeasure;
        }
        if (string.equals("CalculatedMeasure")) {
            AVCalculatedMeasure aVCalculatedMeasure = ((AnalyticView)this.getUpdatedObject()).findCalculatedMeasure(string2);
            return aVCalculatedMeasure;
        }
        return null;
    }

    @Override
    protected LanguageDescriptionsHelper getLanguageDescriptionsHelper(String string, String string2) {
        return (LanguageDescriptionsHelper)((Object)this.findDBObjectWithDesc(string, string2));
    }

    @Override
    protected Set<String> getAvailableLanguages() {
        AnalyticView analyticView = (AnalyticView)this.getUpdatedObject();
        HashSet<String> hashSet = new HashSet<String>();
        try {
            for (AVDimensionality aVDimensionality : analyticView.getDimensions()) {
                Set<String> set = this.availableLanguagesSetForObject(aVDimensionality.getDimension());
                for (String string : set) {
                    if (hashSet.contains(string)) continue;
                    hashSet.add(string);
                }
                for (AVHierarchy aVHierarchy : aVDimensionality.getHierarchies()) {
                    Hierarchy hierarchy = aVHierarchy.getHierarchy();
                    Set<String> set2 = this.availableLanguagesSetForObject(hierarchy);
                    for (String string : set2) {
                        if (hashSet.contains(string)) continue;
                        hashSet.add(string);
                    }
                }
            }
        }
        catch (Exception exception) {
            Logger logger = Logger.getLogger(AVDescriptionPanel.class.getName());
            logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
        return hashSet;
    }
}

