/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.model.cache;

import java.util.ArrayList;
import java.util.List;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.cache.AbstractAVNavigatorCacheModelNode;

public class AVCacheMeasureGroupNode
extends AbstractAVNavigatorCacheModelNode {
    public static final String ALL_MEASURES_SELECTED = "ALL";
    private AnalyticView analyticView;
    private List<AVBaseMeasure> measures;
    private List<AVBaseMeasure> allMeasureAsList;

    public AVCacheMeasureGroupNode(AnalyticView analyticView, Object object) {
        super("MeasureGroupNodeType", object);
        this.analyticView = analyticView;
        ArrayList<AVBaseMeasure> arrayList = new ArrayList<AVBaseMeasure>();
        for (AVMeasure aVMeasure : analyticView.getMeasures()) {
            arrayList.add(aVMeasure);
        }
        this.setMeasures(arrayList);
        this.setALLMeasure();
    }

    public String getAVName() {
        return this.analyticView.getName();
    }

    public void setMeasures(List<AVBaseMeasure> list) {
        this.measures = list;
    }

    public void setALLMeasure() {
        this.allMeasureAsList = new ArrayList<AVBaseMeasure>();
        this.allMeasureAsList.clear();
        AVMeasure aVMeasure = new AVMeasure(ALL_MEASURES_SELECTED);
        aVMeasure.setALLMeasure(true);
        this.allMeasureAsList.add(aVMeasure);
    }

    public List<AVBaseMeasure> getMeasures() {
        if (!this.areAllMeasuresSelected()) {
            return this.measures;
        }
        return this.allMeasureAsList;
    }

    public List<AVBaseMeasure> getMeasuresForSelectionPanel() {
        return this.measures;
    }

    public void addMeasure(AVBaseMeasure aVBaseMeasure) {
        if (aVBaseMeasure != null) {
            this.measures.add(aVBaseMeasure);
        }
    }

    public void addMeasureByName(String string) {
        for (AVMeasure aVMeasure : this.analyticView.getMeasures()) {
            if (!aVMeasure.getName().equalsIgnoreCase(string) || this.measures.contains(aVMeasure)) continue;
            this.measures.add(aVMeasure);
            break;
        }
    }

    public void addAllMeasures() {
        for (AVMeasure aVMeasure : this.analyticView.getMeasures()) {
            if (this.measures.contains(aVMeasure)) continue;
            this.measures.add(aVMeasure);
        }
    }

    public void removeMeasure(AVBaseMeasure aVBaseMeasure) {
        if (aVBaseMeasure != null) {
            this.measures.remove(aVBaseMeasure);
        }
    }

    public void removeMeasureByName(String string) {
        for (AVMeasure aVMeasure : this.analyticView.getMeasures()) {
            if (!aVMeasure.getName().equalsIgnoreCase(string) || !this.measures.contains(aVMeasure)) continue;
            this.measures.remove(aVMeasure);
            break;
        }
    }

    public void removeAllMeasures() {
        this.measures.clear();
    }

    public boolean areAllMeasuresSelected() {
        boolean bl = false;
        if (this.analyticView.getMeasures().length == this.measures.size()) {
            bl = true;
        }
        return bl;
    }
}

