/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.calcfactory;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.EventObject;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import oracle.hcs.HCSArb;
import oracle.hcs.av.calcfactory.CalcFactoryDialog;
import oracle.hcs.av.calcfactory.NamingRuleEditorDialog;
import oracle.hcs.templates.stringexpr.NameSyntaxParseException;
import oracle.hcs.templates.templatelist.Template;
import oracle.hcs.templates.templatelist.TemplateList;
import oracle.hcs.templates.templatelist.TemplateNameFormat;
import oracle.hcs.tree.loader.TreeLoaderXML;
import oracle.hcs.tree.model.DefaultNode;
import oracle.hcs.tree.model.NodeXMLData;
import oracle.hcs.tree.model.TreeTable;
import oracle.hcs.tree.view.JTreeTable;
import oracle.hcs.tree.view.JTreeTableToolTipManager;
import oracle.hcs.tree.view.TreeTableModelAdapter;
import oracle.hcs.util.JavaXMLBind;

public class NamingPanel
extends JPanel
implements JTreeTableToolTipManager {
    private TemplateList defaultCalcList;
    private TemplateList templateList;
    private TemplateList nameTemplateList;
    private TreeLoaderXML treeLoaderXML;
    private JTreeTable namingTreeTable;
    private CalcFactoryDialog calcFactoryDialog;
    private List<String> selectedCalcs;
    private static final String cpackage = "oracle.hcs.templates.templatelist";
    private static final Logger LOG = Logger.getLogger(NamingPanel.class.getName());

    public NamingPanel(CalcFactoryDialog calcFactoryDialog) throws Exception {
        this.setName("NamingPanel");
        this.calcFactoryDialog = calcFactoryDialog;
        this.namingTreeTable = new JTreeTable();
        this.namingTreeTable.setToolTipManager(this);
        this.addUI();
    }

    public void useDefaultNameTemplate() {
        try {
            this.setTemplateList(this.defaultCalcList);
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, exception.getMessage(), exception);
        }
    }

    public void setDefaultCalcList(TemplateList templateList) throws Exception {
        this.defaultCalcList = templateList;
        this.setTemplateList(templateList);
    }

    public void setSelectedCalcs(List<String> list) throws Exception {
        this.selectedCalcs = list.size() != 0 ? list : null;
        this.setupNamingTreeTable();
    }

    public void setTemplateList(TemplateList templateList) throws Exception {
        this.templateList = templateList;
        this.setupNamingTreeTable();
    }

    private void setupNamingTreeTable() throws Exception {
        String string2;
        TemplateList templateList = new TemplateList();
        for (Template template : this.templateList.getTemplatesOnly()) {
            if (this.selectedCalcs != null) {
                for (String string2 : this.selectedCalcs) {
                    if (!template.getName().equalsIgnoreCase(string2)) continue;
                    templateList.addTemplate(template);
                }
                continue;
            }
            templateList.addTemplate(template);
        }
        boolean bl = true;
        boolean bl2 = false;
        String string3 = templateList.toXML(bl, bl2);
        string2 = "/oracle/hcs/av/calcfactory/calcnameedit.xml";
        this.treeLoaderXML = new TreeLoaderXML(string3, NamingPanel.class, string2);
        String string4 = this.calcFactoryDialog.getResourceString("CALCFACTORY.NAMING.COL.PREVIEW");
        this.treeLoaderXML.addColumn(string4);
        TreeTable treeTable = (TreeTable)this.treeLoaderXML.getTree();
        this.namingTreeTable.setModel(treeTable);
        this.namingTreeTable.expandAll(true);
        int n = this.namingTreeTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.setGeneratedName(i);
        }
        this.namingTreeTable.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.namingTreeTable.getColumnModel().getColumn(0).setHeaderValue(HCSArb.getString("DESCRIPTION_PANEL_NAME_TITLE"));
        this.namingTreeTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.namingTreeTable.getColumnModel().getColumn(1).setHeaderValue(HCSArb.getString("DESCRIPTION_PANEL_VALUE_TITLE"));
        this.namingTreeTable.getColumnModel().getColumn(2).setPreferredWidth(125);
        this.namingTreeTable.getColumnModel().getColumn(2).setHeaderValue(HCSArb.getString("CALCFACTORY.NAMING.COL.PREVIEW"));
        this.namingTreeTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                if (tableModelEvent.getColumn() == 1 && tableModelEvent.getType() == 0) {
                    int n = tableModelEvent.getFirstRow();
                    NamingPanel.this.setGeneratedName(n);
                }
            }
        });
    }

    private void setGeneratedName(int n) {
        DefaultNode defaultNode;
        TreeTableModelAdapter treeTableModelAdapter;
        Object object;
        String string = this.getGeneratedName(n);
        if (this.namingTreeTable.getModel() instanceof TreeTableModelAdapter && (object = (treeTableModelAdapter = (TreeTableModelAdapter)this.namingTreeTable.getModel()).nodeForRow(n)) instanceof DefaultNode && (defaultNode = (DefaultNode)object).getUserObject() instanceof NodeXMLData) {
            NodeXMLData nodeXMLData = (NodeXMLData)defaultNode.getUserObject();
            nodeXMLData.setData(2, string);
            treeTableModelAdapter.fireTableCellUpdated(n, 2);
        }
    }

    Template getCalc(int n) {
        TreeTableModelAdapter treeTableModelAdapter;
        Object object;
        Object object2 = this.namingTreeTable.getModel().getValueAt(n, 1);
        if (object2 == null) {
            return null;
        }
        String string = object2.toString();
        if (this.namingTreeTable.getModel() instanceof TreeTableModelAdapter && (object = (treeTableModelAdapter = (TreeTableModelAdapter)this.namingTreeTable.getModel()).nodeForRow(n)) instanceof DefaultNode) {
            DefaultNode defaultNode = (DefaultNode)object;
            List<String> list = this.treeLoaderXML.getNodePath(defaultNode);
            try {
                Template template = null;
                String string2 = list.get(0);
                Object object3 = JavaXMLBind.PathToObject(this.templateList, string2);
                if (object3 instanceof Template) {
                    template = (Template)object3;
                    return template;
                }
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, exception.getMessage(), exception);
            }
        }
        return null;
    }

    String getCalcRuleName(int n) {
        TreeTableModelAdapter treeTableModelAdapter;
        Object object;
        Object object2 = this.namingTreeTable.getModel().getValueAt(n, 1);
        Object object3 = this.namingTreeTable.getModel().getValueAt(n, 0);
        if (object3 != null) {
            return (String)object3;
        }
        if (object2 == null) {
            return null;
        }
        String string = object2.toString();
        if (this.namingTreeTable.getModel() instanceof TreeTableModelAdapter && (object = (treeTableModelAdapter = (TreeTableModelAdapter)this.namingTreeTable.getModel()).nodeForRow(n)) instanceof DefaultNode) {
            DefaultNode defaultNode = (DefaultNode)object;
            List<String> list = this.treeLoaderXML.getNodePath(defaultNode);
            try {
                Template template = null;
                String string2 = list.get(0);
                Object object4 = JavaXMLBind.PathToObject(this.templateList, string2);
                if (object4 instanceof Template) {
                    template = (Template)object4;
                    string2 = list.get(1);
                    String[] stringArray = string2.split("=");
                    String[] stringArray2 = stringArray[0].split("/");
                    String string3 = "";
                    if (stringArray2.length > 0) {
                        string3 = stringArray2[stringArray2.length - 1];
                        return string3;
                    }
                }
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, exception.getMessage(), exception);
            }
        }
        return null;
    }

    private String getGeneratedName(int n) {
        TreeTableModelAdapter treeTableModelAdapter;
        Object object;
        Object object2 = this.namingTreeTable.getModel().getValueAt(n, 1);
        if (object2 == null) {
            return "";
        }
        String string = object2.toString();
        if (this.namingTreeTable.getModel() instanceof TreeTableModelAdapter && (object = (treeTableModelAdapter = (TreeTableModelAdapter)this.namingTreeTable.getModel()).nodeForRow(n)) instanceof DefaultNode) {
            DefaultNode defaultNode = (DefaultNode)object;
            List<String> list = this.treeLoaderXML.getNodePath(defaultNode);
            try {
                Template template = null;
                String string2 = list.get(0);
                Object object3 = JavaXMLBind.PathToObject(this.templateList, string2);
                if (object3 instanceof Template) {
                    template = (Template)object3;
                }
                string2 = list.get(1);
                String[] stringArray = string2.split("=");
                String[] stringArray2 = stringArray[0].split("/");
                String string3 = "";
                if (stringArray2.length > 0) {
                    string3 = stringArray2[stringArray2.length - 1];
                }
                if (string3.length() > 0) {
                    this.calcFactoryDialog.setNamingRule(template, string3, string);
                    return this.calcFactoryDialog.getGeneratedName(template, string3);
                }
            }
            catch (NameSyntaxParseException nameSyntaxParseException) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                nameSyntaxParseException.printStackTrace(printWriter);
                String string4 = stringWriter.toString();
                return this.calcFactoryDialog.getResourceString("CALCFACTORY.INVALID.SYNTAX") + "\n" + string4;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public void addTemplateList(TemplateList templateList) {
        this.nameTemplateList = templateList;
    }

    public boolean save(String string) {
        Object object;
        Object object2;
        if (!this.save()) {
            return false;
        }
        String string2 = this.treeLoaderXML.generateXML();
        try {
            object2 = this.nameTemplateList;
            JavaXMLBind.BindToJavaStr(string2, CalcFactoryDialog.NAME_PACKAGE_NAME, this);
            object = this.nameTemplateList;
            this.calcFactoryDialog.setComments((TemplateList)object);
            string2 = ((TemplateList)object).toXML();
            this.nameTemplateList = object2;
        }
        catch (Exception exception) {
            LOG.log(Level.FINE, exception.getMessage(), exception);
        }
        if (string != null) {
            try {
                if (string.toUpperCase().equals(string.toUpperCase()) && !string.toUpperCase().endsWith(".XML")) {
                    string = string + ".XML";
                }
                if (string.toLowerCase().equals(string.toLowerCase()) && !string.toLowerCase().endsWith(".xml")) {
                    string = string + ".xml";
                }
                object2 = new FileOutputStream(string);
                object = new OutputStreamWriter((OutputStream)object2, "UTF-8");
                BufferedWriter bufferedWriter = new BufferedWriter((Writer)object);
                bufferedWriter.write("<?xml version=\"1.0\" encoding=\"windows-1252\" ?>\n");
                bufferedWriter.write(string2);
                bufferedWriter.close();
                ((OutputStreamWriter)object).close();
                ((FileOutputStream)object2).close();
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, iOException.getMessage(), iOException);
                object = this.calcFactoryDialog.getResourceString("CALCFACTORY.NAMING.UNABLE.TO.SAVE.FILE.MSG", string, iOException.getMessage());
                String string3 = this.calcFactoryDialog.getResourceString("CALCFACTORY.TEMPLATE.FILEDLG.TITLE");
                JOptionPane.showMessageDialog(this, object, string3, 0);
                return false;
            }
        }
        return true;
    }

    public boolean save() {
        TableCellEditor tableCellEditor = this.namingTreeTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        String string = this.treeLoaderXML.generateXML();
        try {
            JavaXMLBind.BindToJavaStr(string, cpackage, this);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, exception.getMessage(), exception);
            return false;
        }
        for (Template template : this.nameTemplateList.getTemplatesOnly()) {
            String string2 = template.getName();
            TemplateNameFormat templateNameFormat = template.getTemplateNameFormat();
            String string3 = templateNameFormat.getName();
            String string4 = templateNameFormat.getDescription();
            String string5 = templateNameFormat.getCaption();
            for (Template template2 : this.templateList.getTemplatesOnly()) {
                if (!template2.getName().equals(string2)) continue;
                templateNameFormat = template2.getTemplateNameFormat();
                templateNameFormat.setName(string3);
                templateNameFormat.setDescription(string4);
                templateNameFormat.setCaption(string5);
            }
        }
        return true;
    }

    private void addUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 3;
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.namingTreeTable, 30, 20);
        this.add((Component)jScrollPane, gridBagConstraints);
        this.namingTreeTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                String string;
                Object object2;
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 1 && (object2 = jTable.getModel().getValueAt(n, 0)) instanceof String && (string = (String)object2).toLowerCase().endsWith("calc/name")) {
                    Font font = component.getFont();
                    component.setFont(font.deriveFont(1));
                }
                return component;
            }
        });
        this.namingTreeTable.setDefaultEditor(Object.class, new MyTableCellEditor(this.calcFactoryDialog));
    }

    @Override
    public String getCellToolTipValue(JTreeTable jTreeTable, int n, int n2) {
        if (n > 0) {
            String string = jTreeTable.getValueAt(n2, n).toString();
            String[] stringArray = string.split("\n");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html>");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim().toLowerCase();
                if (string2.startsWith("at java")) continue;
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("<br>");
            }
            stringBuffer.append("</html>");
            return stringBuffer.toString();
        }
        return null;
    }

    class MyTableCellEditorComponent
    extends JPanel {
        private int row;
        private JTextField textField;
        private JButton editorButton;
        private String origValue;
        private CalcFactoryDialog parentDialog;

        public MyTableCellEditorComponent(CalcFactoryDialog calcFactoryDialog) {
            this.parentDialog = calcFactoryDialog;
            this.textField = new JTextField();
            this.editorButton = new JButton("...");
            this.jbInit();
        }

        public void setRow(int n) {
            this.row = n;
        }

        public String getText() {
            return this.textField.getText();
        }

        public void setText(String string) {
            this.origValue = string;
            this.textField.setText(string);
        }

        private void jbInit() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = -1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.textField, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)this.editorButton, gridBagConstraints);
            this.editorButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = true;
                    Template template = NamingPanel.this.getCalc(MyTableCellEditorComponent.this.row);
                    String string = NamingPanel.this.getCalcRuleName(MyTableCellEditorComponent.this.row);
                    String string2 = MyTableCellEditorComponent.this.origValue;
                    String string3 = NamingPanel.this.calcFactoryDialog.getResourceString("CALC_FACTORY.DLG.NAMING.EDIT.TITLE");
                    NamingRuleEditorDialog namingRuleEditorDialog = new NamingRuleEditorDialog(MyTableCellEditorComponent.this.parentDialog, template, string, string3, bl, string2);
                    namingRuleEditorDialog.setVisible(true);
                    if (!namingRuleEditorDialog.isCancel()) {
                        MyTableCellEditorComponent.this.textField.setText(namingRuleEditorDialog.getText());
                    }
                }
            });
        }
    }

    class MyTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private MyTableCellEditorComponent component;

        public MyTableCellEditor(CalcFactoryDialog calcFactoryDialog) {
            this.component = new MyTableCellEditorComponent(calcFactoryDialog);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.component.setText((String)object);
            this.component.setRow(n);
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return this.component.getText();
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= 2;
            }
            return true;
        }
    }
}

