/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.actions.XMLQueryBasedActionHelper;
import oracle.javatools.db.Database;

public abstract class XMLMultipleObjectsQueryBasedActionHelper
extends XMLQueryBasedActionHelper {
    private List<DBObject> dbObjectList;
    private Connection conn;
    private List<String> sqlStatements;
    private StringBuilder sql;
    private Database db;
    private String objectType;

    public XMLMultipleObjectsQueryBasedActionHelper(List<DBObject> list, Connection connection, Database database) {
        this(list, connection, database, "");
    }

    public XMLMultipleObjectsQueryBasedActionHelper(List<DBObject> list, Connection connection, Database database, String string) {
        this.dbObjectList = list;
        this.conn = connection;
        this.db = database;
        this.objectType = string;
        this.sqlStatements = this.initSQLStatements();
    }

    @Override
    public String getSQL() {
        if (this.sql != null) {
            return this.sql.toString();
        }
        this.sql = new StringBuilder();
        for (String string : this.sqlStatements) {
            this.sql.append(String.format("%s%s", string, "; \n"));
        }
        return this.sql.toString();
    }

    protected abstract List<String> initSQLStatements();

    @Override
    public void commitChanges() throws Exception {
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.conn);
        for (String string : this.sqlStatements) {
            dBUtil.execute(string);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException == null) continue;
            throw sQLException;
        }
    }

    protected List<DBObject> getDBObjectsList() {
        return this.dbObjectList;
    }

    protected Database getDatabase() {
        return this.db;
    }

    protected String getObjectType() {
        return this.objectType;
    }
}

