/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.AbstractModifyHCSObjectAction;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.actions.ConfirmRenameMeasurePanel;
import oracle.hcs.actions.RenameMeasuresHelper;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.navigator.CalculatedMeasureNode;
import oracle.ide.model.Node;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;

public class RenameMeasuresAction
extends AbstractModifyHCSObjectAction {
    private String analyticViewName;
    private static final String ANALYTIC_VIEW_TYPE = "ANALYTIC VIEW";
    public static final String ANALYTIC_VIEW_NAME = "ANALYTIC_VIEW_NAME";
    private HCSSchema schema;
    private DBObjectProvider prov;
    private List<DBObject> selection;
    private AnalyticView analyticView;
    private AnalyticView updatedAnalyticView;
    private List<AVBaseMeasure> measures;
    private static final String HELP_ID = "av_rename_measures";
    private Database db;
    private static final Logger LOG = Logger.getLogger(RenameMeasuresAction.class.getName());

    @Override
    protected AlterHCSObjectHelper getHelper() {
        this.initMeasureSelection();
        DBObject dBObject = this.selection.get(0);
        this.db = dBObject.getDatabase();
        this.prov = this.db;
        this.actionHelper = this.measures != null ? this.createRenameHelper() : null;
        return this.actionHelper;
    }

    protected AlterHCSObjectHelper createRenameHelper() {
        return new RenameMeasuresHelper(this.schema, this.analyticView, this.measures, this.db);
    }

    protected AnalyticView getAnalyticView() {
        return this.analyticView;
    }

    protected AnalyticView getUpdatedAnalyticView() {
        return this.updatedAnalyticView;
    }

    protected List<AVBaseMeasure> getMeasures() {
        return this.measures;
    }

    protected Database getDatabase() {
        return this.db;
    }

    protected DBObjectProvider getProvider() {
        return this.prov;
    }

    private void initMeasureSelection() {
        this.measures = new ArrayList<AVBaseMeasure>();
        for (DBObject dBObject : this.selection) {
            this.analyticViewName = this.getAVName();
            try {
                this.schema = this.getSchema();
                this.analyticView = this.schema.findAV(this.analyticViewName);
                this.updatedAnalyticView = (AnalyticView)DBUtil.makeTemporaryCopy((oracle.javatools.db.DBObject)this.analyticView);
                String string = this.getMeasureName(dBObject);
                AVBaseMeasure aVBaseMeasure = this.updatedAnalyticView.findBaseMeasure(string);
                if (aVBaseMeasure == null) continue;
                this.measures.add(aVBaseMeasure);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                this.measures = null;
                break;
            }
        }
    }

    private String getAVName() {
        String string = null;
        DBObject dBObject = this.selection.get(0);
        string = this.getAVName(dBObject);
        return string;
    }

    private String getAVName(DBObject dBObject) {
        String string = null;
        Node node = dBObject.getNode();
        if (node instanceof CalculatedMeasureNode) {
            CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)node;
            string = (String)calculatedMeasureNode.getProperty(ANALYTIC_VIEW_NAME);
        } else if (node instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)node;
            string = (String)objectNode.getProperty(ANALYTIC_VIEW_NAME);
        }
        return string;
    }

    private String getMeasureName() {
        String string = null;
        DBObject dBObject = this.selection.get(0);
        string = this.getMeasureName(dBObject);
        return string;
    }

    private String getMeasureName(DBObject dBObject) {
        String string = null;
        Node node = dBObject.getNode();
        if (!(node instanceof CalculatedMeasureNode)) {
            string = String.valueOf(node.getData());
            return string;
        }
        CalculatedMeasureNode calculatedMeasureNode = (CalculatedMeasureNode)node;
        string = (String)calculatedMeasureNode.getProperty("MEASURE_NAME");
        return string;
    }

    public void setSelection(List<DBObject> list) {
        this.selection = list;
    }

    @Override
    protected String getParentObjectName() {
        return this.getAVName();
    }

    @Override
    protected String getParentObjectType() {
        return ANALYTIC_VIEW_TYPE;
    }

    @Override
    protected String getObjectName() {
        return this.getMeasureName();
    }

    @Override
    protected String getTitle(String string) {
        return HCSArb.format("RENAME_MEASURES_TITLE", string);
    }

    @Override
    protected String getProgressMessage() {
        return HCSArb.getString("RENAME_MEASURE_ACTION_PROGRESSBAR_TITLE");
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    protected ActionConfirmPanel getConfirmationPanel() {
        ConfirmRenameMeasurePanel confirmRenameMeasurePanel = null;
        if (this.measures != null && this.actionHelper != null) {
            confirmRenameMeasurePanel = new ConfirmRenameMeasurePanel(this.prov, this.analyticView, this.measures);
        }
        return confirmRenameMeasurePanel;
    }

    @Override
    protected void actionPostProcess() {
        this.refreshNavigator(this.selection.get(0), this.analyticViewName);
    }

    @Override
    protected String getHelpID() {
        return HELP_ID;
    }

    @Override
    protected boolean isVisibleForceCreateCheckBox() {
        return true;
    }
}

