/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.awt.Window;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.av.calcs.NewCalculatedMeasureDialog;
import oracle.hcs.db.HCSExceptionHandler;
import oracle.hcs.db.HCSMetadataCache;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.navigator.CalculatedMeasureNode;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ideimpl.db.ceditor.PlSqlFeatures;
import oracle.javatools.db.DBObjectProvider;

public class NewCalculatedMeasureAction
extends AbstractMenuAction {
    private static final Logger LOG = Logger.getLogger(NewCalculatedMeasureAction.class.getName());

    public void launch() {
        ObjectFolder objectFolder;
        Context context = this.getContext();
        if (context.getElement() instanceof ObjectFolder && "HCSCALCMEASURE".equals((objectFolder = (ObjectFolder)context.getElement()).getObjectType())) {
            String string = (String)objectFolder.getProperty("ANALYTIC_VIEW_NAME");
            String string2 = (String)context.getProperty("ObjectAction.CONN_NAME");
            String string3 = objectFolder.getSchemaName();
            HCSSchema hCSSchema = null;
            try {
                hCSSchema = HCSMetadataCache.getUpdatedSchema(string2, string3);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, String.format("Error fetching schema to generate calc measure name for key [%s,%s]", string2, string3), exception);
                HCSExceptionHandler.handleException((Window)Ide.getMainWindow(), exception);
                return;
            }
            NewCalculatedMeasureDialog newCalculatedMeasureDialog = new NewCalculatedMeasureDialog(hCSSchema.findAV(string), (DBObjectProvider)this.getDBObject().getDatabase());
            newCalculatedMeasureDialog.setLocationRelativeTo((Component)Ide.getMainWindow());
            newCalculatedMeasureDialog.setVisible(true);
            if (newCalculatedMeasureDialog.isOKSelected() && context.getElement() instanceof ObjectFolder) {
                String string4 = newCalculatedMeasureDialog.getMeasureName();
                URL uRL = objectFolder.getURL();
                uRL = DBURLFormatHelper.getURL((URL)uRL, (String)String.format("%s.%s", string, string4));
                final CalculatedMeasureNode calculatedMeasureNode = new CalculatedMeasureNode();
                calculatedMeasureNode.setURL(uRL);
                calculatedMeasureNode.setFolderNode(objectFolder);
                calculatedMeasureNode.setDescriptions(newCalculatedMeasureDialog.getDescription(), newCalculatedMeasureDialog.getCaption(), newCalculatedMeasureDialog.getMeasureFormat());
                Context context2 = Context.newIdeContext((Node)calculatedMeasureNode);
                EditorManager editorManager = EditorManager.getEditorManager();
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context2);
                boolean bl = PlSqlFeatures.isSupportedBreadcrumbs();
                boolean bl2 = PlSqlFeatures.isSupportedGutterNavigation();
                if (bl) {
                    PlSqlFeatures.setSupportedBreadcrumbs((boolean)false);
                }
                if (bl2) {
                    PlSqlFeatures.setSupportedGutterNavigation((boolean)false);
                }
                editorManager.openEditor(openEditorOptions);
                PlSqlFeatures.setSupportedBreadcrumbs((boolean)bl);
                PlSqlFeatures.setSupportedGutterNavigation((boolean)bl2);
                calculatedMeasureNode.markDirty(true);
                calculatedMeasureNode.addNodeListener(new NodeListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void nodeSaved(NodeEvent nodeEvent) {
                        try {
                            DBObject dBObject = NewCalculatedMeasureAction.this.getDBObject();
                            ObjectAction objectAction = new ObjectAction();
                            objectAction.setReload(true);
                            ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)dBObject);
                            objectActionPostProcess.run();
                        }
                        catch (Exception exception) {
                            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        }
                        finally {
                            calculatedMeasureNode.removeNodeListener(this);
                        }
                    }

                    public void nodeClosed(NodeEvent nodeEvent) {
                        calculatedMeasureNode.removeNodeListener(this);
                    }
                });
            }
        }
    }
}

