/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.DescriptionsNode;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.db.model.Classification;
import oracle.hcs.db.model.Descriptions;
import oracle.hcs.db.model.NamedObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.ui.treetable.TreeTableModel;

public class ModifyObjectsPropertiesTreeTableModel
implements TreeTableModel {
    private DescriptionsNode rootNode;
    private DBObjectProvider prov;
    private static String[] columns = new String[]{HCSArb.getString("MODIFY_OBJECTS_PROPS_CLASSIFICATION_TYPE_COLUMN"), HCSArb.getString("MODIFY_OBJECTS_PROPS_VALUE_COLUMN")};
    protected static final Class[] cTypes = new Class[]{TreeTableModel.class, String.class};
    private final int CLASSIFICATION_TYPE_COLUMN = 0;
    private final int CLASS_VALUE_COLUMN = 1;
    private Map<String, List<Descriptions>> parentDescObjects;
    private Map<String, Set<String>> objectsWithNewClassifications;
    private String viewFilter;
    private String modelName;
    private final String FORMAT_STRING = "FORMAT_STRING";

    public ModifyObjectsPropertiesTreeTableModel(DBObjectProvider dBObjectProvider, Map<String, List<Descriptions>> map, String string) {
        this.prov = dBObjectProvider;
        this.parentDescObjects = map;
        this.rootNode = new DescriptionsNode(dBObjectProvider, null, null);
        this.rootNode.setIsRoot(true);
        this.objectsWithNewClassifications = new HashMap<String, Set<String>>();
        this.viewFilter = "";
        this.modelName = string;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void populateParentDescObjects() {
        for (String string : this.parentDescObjects.keySet()) {
            List<Descriptions> list = this.parentDescObjects.get(string);
            for (Descriptions descriptions : list) {
                DescriptionsNode descriptionsNode = this.rootNode.addDescriptionsNode(descriptions, true);
                this.populateObject(descriptions, descriptionsNode);
            }
        }
    }

    public void populateChildrenDescObjects(Map<String, List<Descriptions>> map) {
        for (String string : map.keySet()) {
            Descriptions descriptions = this.findParentDescriptionObject(string);
            DescriptionsNode descriptionsNode = this.rootNode.addDescriptionsNode(descriptions, true);
            List<Descriptions> list = map.get(string);
            for (Descriptions descriptions2 : list) {
                DescriptionsNode descriptionsNode2 = descriptionsNode.addDescriptionsNode(descriptions2, false);
                this.populateObject(descriptions2, descriptionsNode2);
            }
        }
    }

    private void populateObject(Descriptions descriptions, DescriptionsNode descriptionsNode) {
        NamedObject namedObject = (NamedObject)((Object)descriptions);
        String string = namedObject.getName();
        if (descriptions.getCaption() != null) {
            this.addSpecialClassification(descriptions, descriptionsNode, HCSArb.get("MODIFY_OBJECTS_PROPS_CAPTION_LABEL"), descriptions.getCaption());
        }
        if (descriptions.getDescription() != null) {
            this.addSpecialClassification(descriptions, descriptionsNode, HCSArb.get("MODIFY_OBJECTS_PROPS_DESCRIPTION_LABEL"), descriptions.getDescription());
        }
        for (Classification classification : descriptions.getClassifications()) {
            String string2 = classification.getClassificationType();
            descriptionsNode.addDescriptionsNode(classification, descriptions, this.isObjectNew(string, string2));
        }
    }

    private void addSpecialClassification(Descriptions descriptions, DescriptionsNode descriptionsNode, String string, String string2) {
        Classification classification = new Classification(string, string2, null);
        descriptionsNode.addDescriptionsNode(classification, descriptions, false);
    }

    public void filterModel(String string, String string2, Map<String, List<Descriptions>> map, boolean bl) {
        block11: {
            block10: {
                this.viewFilter = string.toUpperCase().trim();
                if (this.viewFilter.equals("")) {
                    if (bl) {
                        this.populateParentDescObjects();
                    } else {
                        this.populateChildrenDescObjects(map);
                    }
                    return;
                }
                if (!string2.equals(HCSArb.getString("MODIFY_OBJECTS_PROPS_NAME_COLUMN"))) break block10;
                for (String string3 : map.keySet()) {
                    List<Descriptions> list = map.get(string3);
                    for (Descriptions descriptions : list) {
                        NamedObject namedObject = (NamedObject)((Object)descriptions);
                        String string4 = namedObject.getName();
                        if (!string4.contains(this.viewFilter) && !string3.contains(this.viewFilter)) continue;
                        DescriptionsNode descriptionsNode = this.getClassParentDescNode(bl, string3, descriptions);
                        this.populateObject(descriptions, descriptionsNode);
                    }
                }
                break block11;
            }
            if (!string2.equals(HCSArb.getString("MODIFY_OBJECTS_PROPS_CLASSIFICATION_TYPE_COLUMN"))) break block11;
            for (String string5 : map.keySet()) {
                List<Descriptions> list = map.get(string5);
                for (Descriptions descriptions : list) {
                    NamedObject namedObject = (NamedObject)((Object)descriptions);
                    String string6 = namedObject.getName();
                    if (HCSArb.get("MODIFY_OBJECTS_PROPS_CAPTION_LABEL").contains(this.viewFilter) && descriptions.getCaption() != null) {
                        DescriptionsNode descriptionsNode = this.getClassParentDescNode(bl, string5, descriptions);
                        this.addSpecialClassification(descriptions, descriptionsNode, HCSArb.get("MODIFY_OBJECTS_PROPS_CAPTION_LABEL"), descriptions.getCaption());
                    }
                    if (HCSArb.get("MODIFY_OBJECTS_PROPS_DESCRIPTION_LABEL").contains(this.viewFilter) && descriptions.getDescription() != null) {
                        DescriptionsNode descriptionsNode = this.getClassParentDescNode(bl, string5, descriptions);
                        this.addSpecialClassification(descriptions, descriptionsNode, HCSArb.get("MODIFY_OBJECTS_PROPS_DESCRIPTION_LABEL"), descriptions.getDescription());
                    }
                    for (Classification classification : descriptions.getClassifications()) {
                        String string3 = classification.getClassificationType();
                        if (!string3.contains(this.viewFilter)) continue;
                        DescriptionsNode descriptionsNode = this.getClassParentDescNode(bl, string5, descriptions);
                        descriptionsNode.addDescriptionsNode(classification, descriptions, this.isObjectNew(string6, string3));
                    }
                }
            }
        }
    }

    public String getViewFilter() {
        return this.viewFilter;
    }

    private DescriptionsNode getClassParentDescNode(boolean bl, String string, Descriptions descriptions) {
        Object object;
        boolean bl2;
        DescriptionsNode descriptionsNode = null;
        DescriptionsNode descriptionsNode2 = null;
        if (!bl) {
            bl2 = false;
            object = this.findParentDescriptionObject(string);
            descriptionsNode = this.findParentNodeInTree(this.rootNode, string, bl2);
            if (descriptionsNode == null) {
                descriptionsNode = this.rootNode.addDescriptionsNode((Descriptions)object, true);
            }
        } else {
            descriptionsNode = this.rootNode;
            bl2 = true;
        }
        object = (NamedObject)((Object)descriptions);
        String string2 = object.getName();
        descriptionsNode2 = this.findParentNodeInTree(descriptionsNode, string2, bl2);
        if (descriptionsNode2 == null) {
            descriptionsNode2 = descriptionsNode.addDescriptionsNode(descriptions, bl2);
        }
        return descriptionsNode2;
    }

    private Descriptions findParentDescriptionObject(String string) {
        List<Descriptions> list = this.parentDescObjects.get(string);
        for (Descriptions descriptions : list) {
            NamedObject namedObject = (NamedObject)((Object)descriptions);
            String string2 = namedObject.getName();
            if (!string2.equals(string)) continue;
            return descriptions;
        }
        return null;
    }

    private DescriptionsNode findParentNodeInTree(DescriptionsNode descriptionsNode, String string, boolean bl) {
        if (descriptionsNode.getParentObjName() != null && descriptionsNode.getParentObjName().equals(string) && bl == descriptionsNode.isTopObject()) {
            return descriptionsNode;
        }
        for (Object object : descriptionsNode.getChildren()) {
            DescriptionsNode descriptionsNode2 = (DescriptionsNode)object;
            DescriptionsNode descriptionsNode3 = this.findParentNodeInTree(descriptionsNode2, string, descriptionsNode2.isTopObject());
            if (descriptionsNode3 == null) continue;
            return descriptionsNode3;
        }
        return null;
    }

    private boolean isObjectNew(String string, String string2) {
        return this.objectsWithNewClassifications.containsKey(string) && this.objectsWithNewClassifications.get(string).contains(string2);
    }

    public void storeNewDescObjectsWithNewClassifications(DescriptionsNode descriptionsNode) {
        if (descriptionsNode.getChildren().size() == 0) {
            return;
        }
        for (Object object : descriptionsNode.getChildren()) {
            DescriptionsNode descriptionsNode2 = (DescriptionsNode)object;
            String string = descriptionsNode2.getParentObjName();
            HashSet<String> hashSet = new HashSet<String>();
            DescriptionsNode descriptionsNode3 = (DescriptionsNode)object;
            if (descriptionsNode3.isObjectNew()) {
                Classification classification = descriptionsNode3.getClassification();
                String string2 = classification.getClassificationType();
                hashSet.add(string2);
            }
            if (hashSet.size() > 0) {
                if (this.objectsWithNewClassifications.containsKey(string)) {
                    this.objectsWithNewClassifications.get(string).addAll(hashSet);
                } else {
                    this.objectsWithNewClassifications.put(string, hashSet);
                }
            }
            this.storeNewDescObjectsWithNewClassifications((DescriptionsNode)object);
        }
    }

    public Object getRoot() {
        return this.rootNode;
    }

    public int getColumnCount() {
        return columns.length;
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    public Object getValueAt(Object object, int n) {
        DescriptionsNode descriptionsNode = (DescriptionsNode)object;
        String string = "";
        switch (n) {
            case 0: {
                if (!descriptionsNode.isParent()) {
                    string = descriptionsNode.getClassificationType();
                    break;
                }
                string = descriptionsNode.getParentObjName();
                break;
            }
            case 1: {
                string = descriptionsNode.getClassificationValue();
                break;
            }
        }
        return string;
    }

    public boolean isCellEditable(Object object, int n) {
        DescriptionsNode descriptionsNode = (DescriptionsNode)object;
        Classification classification = descriptionsNode.getClassification();
        String string = null;
        String string2 = null;
        boolean bl = false;
        if (classification != null) {
            string = classification.getClassificationType();
            string2 = classification.getValue();
            bl = descriptionsNode.isObjectNew();
        }
        return n == 1 && !descriptionsNode.isParent() || bl;
    }

    public void setValueAt(Object object, Object object2, int n) {
        DescriptionsNode descriptionsNode = (DescriptionsNode)object2;
        Descriptions descriptions = descriptionsNode.getParentDescriptionObject();
        Classification classification = descriptionsNode.getClassification();
        if (classification == null) {
            return;
        }
        switch (n) {
            case 0: {
                classification.setClassificationType((String)object);
                break;
            }
            case 1: {
                String string = classification.getClassificationType();
                String string2 = (String)object;
                if (this.isBaseMeasureFormatStringClassification(string, descriptions)) {
                    string2 = string2.trim();
                    this.handleFormatStringClassification(string, string2, descriptions, classification);
                }
                if (string.equals(HCSArb.get("MODIFY_OBJECTS_PROPS_CAPTION_LABEL"))) {
                    descriptions.setCaption((String)object);
                } else if (string.equals(HCSArb.get("MODIFY_OBJECTS_PROPS_DESCRIPTION_LABEL"))) {
                    descriptions.setDescription((String)object);
                }
                classification.setValue(string2);
            }
        }
    }

    private void handleFormatStringClassification(String string, String string2, Descriptions descriptions, Classification classification) {
        if (!string2.equalsIgnoreCase(HCSArb.get("NONE"))) {
            this.addClassificationInParent(descriptions, classification);
        } else {
            this.removeClassificationFromParent(descriptions, string);
        }
    }

    private boolean isBaseMeasureFormatStringClassification(String string, Descriptions descriptions) {
        return string.equals("FORMAT_STRING") && descriptions instanceof AVBaseMeasure;
    }

    private void addClassificationInParent(Descriptions descriptions, Classification classification) {
        String string = classification.getClassificationType();
        Classification classification2 = descriptions.findClassification(string);
        if (classification2 == null) {
            descriptions.addClassification(classification);
        }
    }

    private void removeClassificationFromParent(Descriptions descriptions, String string) {
        Classification classification = descriptions.findClassification(string);
        if (classification != null) {
            descriptions.removeClassifications(classification);
        }
    }

    protected List<Object> getChildren(Object object) {
        DescriptionsNode descriptionsNode = (DescriptionsNode)object;
        return descriptionsNode.getChildren();
    }

    public Object getChild(Object object, int n) {
        return this.getChildren(object).get(n);
    }

    public int getChildCount(Object object) {
        DescriptionsNode descriptionsNode = (DescriptionsNode)object;
        return descriptionsNode.getChildren().size();
    }

    public boolean isLeaf(Object object) {
        DescriptionsNode descriptionsNode = (DescriptionsNode)object;
        return descriptionsNode.getChildren().size() == 0;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public int getIndexOfChild(Object object, Object object2) {
        return 0;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    public void clear() {
        this.rootNode.clearChildren();
    }
}

