/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.DropConfirmPanel;
import oracle.hcs.db.model.NamedObjectWithDesc;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.table.GenericTable;

public class DropMultipleObjectsConfirmPanel
extends DropConfirmPanel {
    private List<NamedObjectWithDesc> namedObjects;
    private DefaultTableModel dropModel;
    private GenericTable dropMultipleObjectsTable;
    private String confirmDropTableTitle;

    public DropMultipleObjectsConfirmPanel(List<NamedObjectWithDesc> list, String string, String string2, String string3) {
        super(string, string2);
        this.namedObjects = list;
        this.confirmDropTableTitle = string3;
        this.initComponents();
        this.layoutDropMultipleObjectsPanel();
    }

    private void initComponents() {
        this.showNameField(false);
        this.setLabelConfirmMssg(HCSArb.get("DROP_MULTIPLE_OBJECTS_CONFIRM_MSSG"));
        this.dropModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.dropModel.addColumn(HCSArb.get("MULTIPLE_OBJECTS_NAME_COLUMN"));
        this.dropModel.addColumn(HCSArb.get("MULTIPLE_OBJECTS_CAPTION_COLUMN"));
        this.dropModel.addColumn(HCSArb.get("MULTIPLE_OBJECTS_DESCRIPTION_COLUMN"));
        this.dropMultipleObjectsTable = new GenericTable((TableModel)this.dropModel);
        this.populateTable();
    }

    private void layoutDropMultipleObjectsPanel() {
        JScrollPane jScrollPane = new JScrollPane((Component)this.dropMultipleObjectsTable);
        ComponentWithTitlebar componentWithTitlebar = new ComponentWithTitlebar();
        componentWithTitlebar.setLabel(new JLabel(this.confirmDropTableTitle));
        componentWithTitlebar.setEnabled(false);
        componentWithTitlebar.setComponent((JComponent)jScrollPane);
        this.c.gridx = 0;
        ++this.c.gridy;
        this.c.gridwidth = 0;
        this.c.gridheight = 2;
        this.c.weightx = 0.5;
        this.c.weighty = 2.0;
        this.add((Component)componentWithTitlebar, this.c);
    }

    private void populateTable() {
        Object[] objectArray = null;
        for (NamedObjectWithDesc namedObjectWithDesc : this.namedObjects) {
            objectArray = new Object[]{namedObjectWithDesc.getName(), namedObjectWithDesc.getCaption(), namedObjectWithDesc.getDescription()};
            this.dropModel.addRow(objectArray);
        }
    }
}

