/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.util.List;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.actions.AbstractDropMeasureAction;
import oracle.hcs.actions.DDLBasedBaseMeasureActionsHelper;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVCalculatedMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.model.CalcReferences;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.util.NameProvider;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;

public class DropMeasuresHelper
extends DDLBasedBaseMeasureActionsHelper {
    protected List<AVBaseMeasure> dependencies;
    private AbstractDropMeasureAction dropMeasureActionReference;
    private String measureName;
    protected String analyticViewName;
    private DBObject dbObject;
    private boolean doRemoveDependencies;

    public DropMeasuresHelper(Database database, HCSSchema hCSSchema) {
        super(database, hCSSchema);
    }

    public DropMeasuresHelper(AnalyticView analyticView, HCSSchema hCSSchema, String string, String string2, DBObject dBObject) {
        super(dBObject.getDatabase(), hCSSchema);
        this.measureName = string;
        this.analyticViewName = string2;
        this.dbObject = dBObject;
        this.initParser(string2);
        this.setOriginalAv(analyticView);
        this.setUpdatedAv((AnalyticView)DBUtil.makeTemporaryCopy((oracle.javatools.db.DBObject)analyticView));
        this.doRemoveDependencies = true;
    }

    @Override
    public String getTitle() {
        if (this.dropMeasureActionReference != null) {
            return this.dropMeasureActionReference.getTitle(this.measureName);
        }
        return "";
    }

    private void changeDefaultMeasure(String string) {
        for (AVBaseMeasure aVBaseMeasure : this.getUpdatedAv().getStoredAndCalculatedMeasures()) {
            if (aVBaseMeasure.getName().equals(string)) continue;
            this.getUpdatedAv().setDefaultMeasure(aVBaseMeasure.getName());
            this.setDefaultMeasureChanged(true);
            break;
        }
    }

    protected void removeDependencies() {
        for (AVBaseMeasure aVBaseMeasure : this.dependencies) {
            AVCalculatedMeasure aVCalculatedMeasure;
            if (aVBaseMeasure.isDerived() && (aVCalculatedMeasure = this.getUpdatedAv().findCalculatedMeasure(aVBaseMeasure.getName())) != null) {
                this.getUpdatedAv().removeCalculatedMeasure(aVCalculatedMeasure);
            }
            this.addChangedMeasure(aVBaseMeasure.getName());
        }
    }

    protected void setDependencies(List<AVBaseMeasure> list) {
        this.dependencies = list;
    }

    @Override
    public Object getDependencies() {
        if (this.dependencies == null || this.dependencies.isEmpty()) {
            NameProvider nameProvider = NameProvider.getInstance();
            nameProvider.setProvider((DBObjectProvider)this.getDatabase());
            this.dependencies = CalcReferences.getDependencies(this.getSchema(), this.analyticViewName, this.measureName, this.getParser());
        }
        return this.dependencies;
    }

    protected void doRemoveMeasures() {
        AVBaseMeasure aVBaseMeasure = this.getUpdatedAv().findBaseMeasure(this.measureName);
        this.processObjectChanges(aVBaseMeasure);
        this.getUpdatedAv().removeBaseMeasure(aVBaseMeasure);
        if (this.doRemoveDependencies) {
            this.removeDependencies();
        }
    }

    protected void processObjectChanges(AVBaseMeasure aVBaseMeasure) {
        if (aVBaseMeasure != null) {
            this.addChangedMeasure(aVBaseMeasure.getName());
            if (this.getUpdatedAv().getDefaultMeasure().equalsIgnoreCase(aVBaseMeasure.getName())) {
                this.changeDefaultMeasure(aVBaseMeasure.getName());
            }
        }
    }

    public void setDropMeasureActionReference(AbstractDropMeasureAction abstractDropMeasureAction) {
        this.dropMeasureActionReference = abstractDropMeasureAction;
    }

    @Override
    public void setForceCreate(boolean bl) {
        this.getUpdatedAv().setForceCreate(bl);
    }

    @Override
    public void refreshMetadataObjects(boolean bl) {
        this.doRemoveDependencies = bl;
        if (!this.doRemoveDependencies) {
            boolean bl2 = this.getUpdatedAv().isForceCreate();
            String string = this.getUpdatedAv().getDefaultMeasure();
            this.setUpdatedAv((AnalyticView)DBUtil.makeTemporaryCopy((oracle.javatools.db.DBObject)this.getOrigAv()));
            this.getUpdatedAv().setForceCreate(bl2);
            this.getUpdatedAv().setDefaultMeasure(string);
        }
    }

    @Override
    protected void modifyObjects() {
        this.doRemoveMeasures();
    }
}

