/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.awt.Frame;
import java.sql.Connection;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskUtils;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.av.calcfactory.CalcFactoryDialog;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.AVCalcPersistSQL;
import oracle.hcs.db.DatabaseImpl;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.preferences.HCSPreferenceSettings;
import oracle.hcs.util.HCSResources;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.dialogs.MessageDialog;

public class CalcFactoryAction
extends AbstractMenuAction {
    private CalcFactoryDialog dlg;
    private Preferences prefs;
    private static final String AV_NAME = "ANALYTIC_VIEW_NAME";

    public void launch() {
        DBObject dBObject = this.getDBObject();
        final Database database = dBObject.getDatabase();
        Connection connection = dBObject.getConnection();
        DatabaseImpl databaseImpl = new DatabaseImpl();
        databaseImpl.setConnection(connection);
        String string = this.getAVName();
        String string2 = dBObject.getSchemaName();
        final DatabaseImpl databaseImpl2 = databaseImpl;
        String string3 = HCSArb.get("CALCFACTORY_ACTION_PROGRESSBAR_TITLE");
        RaptorTask raptorTask = new RaptorTask(string3, true, IRaptorTaskRunMode.MODAL){

            protected Object doWork() throws TaskException {
                Boolean bl = Boolean.TRUE;
                try {
                    this.setMessage(HCSArb.get("CALCFACTORY_ACTION_PROGRESSBAR_READ_AV_METADATA_MSG"));
                    AnalyticView analyticView = CalcFactoryAction.this.getModelAV();
                    AVCalcPersistSQL aVCalcPersistSQL = new AVCalcPersistSQL(databaseImpl2, analyticView);
                    aVCalcPersistSQL.setProvider(database);
                    HCSResources hCSResources = new HCSResources("/oracle/hcs/calcfactory/calcs.xml");
                    CalcFactoryAction.this.prefs = Preferences.getPreferences();
                    final HCSPreferenceSettings hCSPreferenceSettings = HCSPreferenceSettings.getInstance((PropertyStorage)CalcFactoryAction.this.prefs);
                    oracle.hcs.preferences.Preferences preferences = new oracle.hcs.preferences.Preferences(){

                        @Override
                        public String get(String string) {
                            if ("TEMPLATE_DIRECTORY".equals(string)) {
                                return hCSPreferenceSettings.getTemplateDirectory();
                            }
                            if ("TEMPLATE_FILE".equals(string)) {
                                return hCSPreferenceSettings.getTemplateFile();
                            }
                            if ("TEMPLATE_NAME_FILE".equals(string)) {
                                return hCSPreferenceSettings.getTemplateNameFile();
                            }
                            return null;
                        }

                        @Override
                        public void set(String string, String string2) {
                            if ("TEMPLATE_DIRECTORY".equals(string)) {
                                hCSPreferenceSettings.setTemplateDirectory(string2);
                            } else if ("TEMPLATE_FILE".equals(string)) {
                                hCSPreferenceSettings.setTemplateFile(string2);
                            } else if ("TEMPLATE_NAME_FILE".equals(string)) {
                                hCSPreferenceSettings.setTemplateNameFile(string2);
                            }
                        }
                    };
                    this.setMessage(HCSArb.get("CALCFACTORY_ACTION_PROGRESSBAR_INIT_DISPLAY_MSG"));
                    CalcFactoryAction.this.dlg = new CalcFactoryDialog((Frame)Ide.getMainWindow(), hCSResources, preferences, aVCalcPersistSQL, analyticView, (OracleDatabaseImpl)CalcFactoryAction.this.getDBObject().getDatabase(), CalcFactoryAction.this.getDBObject().getSchemaName());
                    CalcFactoryAction.this.prefs.save();
                }
                catch (Throwable throwable) {
                    bl = Boolean.FALSE;
                    throw new TaskException(throwable);
                }
                return bl;
            }
        };
        raptorTask.setCancellable(false);
        raptorTask.setPausable(false);
        raptorTask.setMessage(string3);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(final RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Throwable throwable = raptorTaskEvent.getThrowable();
                        String string = RaptorTaskUtils.getErrorMessage((Throwable)throwable);
                        CalcFactoryAction.this.warn(throwable);
                        CalcFactoryAction.this.showErrorDialog(string);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        CalcFactoryAction.this.dlg.setModal(true);
                        CalcFactoryAction.this.dlg.setVisible(true);
                        if (CalcFactoryAction.this.dlg.isCreated()) {
                            ObjectAction objectAction = new ObjectAction();
                            objectAction.setReload(true);
                            ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)objectAction, (DBObject)CalcFactoryAction.this.getDBObject());
                            objectActionPostProcess.run();
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        });
        RaptorTaskManager raptorTaskManager = RaptorTaskManager.getInstance();
        raptorTaskManager.addTask(raptorTask);
    }

    private String getAVName() {
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getObjectName();
        if (string == null && this.getContext().getElement() instanceof ObjectFolder) {
            ObjectFolder objectFolder = (ObjectFolder)this.getContext().getElement();
            string = String.valueOf(objectFolder.getProperty(AV_NAME));
        }
        return string;
    }

    private AnalyticView getModelAV() {
        DBObject dBObject = this.getDBObject();
        AnalyticView analyticView = new AnalyticView();
        String string = this.getAVName();
        String string2 = dBObject.getSchemaName();
        analyticView.setName(string);
        analyticView.setSchema(new HCSSchema(string2));
        return analyticView;
    }

    protected void showErrorDialog(String string) {
        String string2 = HCSArb.getString("CALCFACTORY_ACTION.CALCULATION_GENERATION_ERROR");
        String string3 = null;
        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)string2, string3);
    }
}

