/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.AbstractModifyHCSObjectAction;
import oracle.hcs.actions.ActionConfirmPanel;
import oracle.hcs.actions.AlterHCSObjectHelper;
import oracle.hcs.actions.CompilationResultsDialog;
import oracle.hcs.actions.CompilationResultsPanel;
import oracle.hcs.table.Queries;
import oracle.hcs.util.JavaXMLBind;
import oracle.hcs.validation.AVValidationHelper;
import oracle.hcs.validation.HCSValidationDialog;
import oracle.hcs.validation.HCSValidationPanel;
import oracle.hcs.validation.HCSValidationQuery;
import oracle.ide.Ide;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabaseImpl;

public class AVValidationAction
extends AbstractModifyHCSObjectAction {
    public static final String VALIDATION_LOG_TABLE = "AV_VALIDATION_LOG";
    private static Queries queries;
    private static final String XMLFILE = "/oracle/hcs/actions/actionsQueries.xml";
    private static final String QUERIES_PACKAGE = "oracle.hcs.table";
    private static final String AV_STATE_QUERY = "analyticViewState";
    private static final String COMPILE_OBJECT_SQL = "compileObject";
    private static final String OWNER = "OWNER";
    private static final String AV_NAME = "ANALYTIC_VIEW_NAME";
    private static final String INVALID = "INVALID";
    private boolean showCompileErrors;
    private AVValidationHelper avValidationHelper;
    private static final Logger LOG;
    private static final String HELP_ID = "obj_validation";

    private String getQuery(String string) {
        if (queries == null) {
            try {
                String string2 = QUERIES_PACKAGE;
                String string3 = JavaXMLBind.LoadDocument(((Object)((Object)this)).getClass(), XMLFILE);
                JavaXMLBind.BindToJavaStr(string3, string2, (Object)this);
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, exception.getLocalizedMessage(), exception);
            }
        }
        return queries.getSQL(string);
    }

    public void addQueries(Queries queries) {
        AVValidationAction.queries = queries;
    }

    @Override
    protected AlterHCSObjectHelper getHelper() throws Exception {
        DBUtil dBUtil;
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getSchemaName();
        Connection connection = dBObject.getConnection();
        String string2 = dBObject.getObjectName();
        String string3 = this.isAVValid(string2, string, dBUtil = DBUtil.getInstance((Connection)connection));
        if (string3 == null || string3.equalsIgnoreCase(INVALID)) {
            String string4 = dBObject.getObjectType();
            String string5 = String.format(this.getQuery(COMPILE_OBJECT_SQL), string4, string, string2);
            dBUtil.execute(string5);
            string3 = this.isAVValid(string2, string, dBUtil);
            if (string3 == null || string3.equalsIgnoreCase(INVALID)) {
                this.showCompileErrors = true;
            }
        }
        this.avValidationHelper = new AVValidationHelper(dBObject);
        return this.avValidationHelper;
    }

    public String isAVValid(String string, String string2, DBUtil dBUtil) {
        String string3 = "";
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(OWNER, string2);
            hashMap.put(AV_NAME, string);
            String string4 = this.getQuery(AV_STATE_QUERY);
            string3 = dBUtil.executeReturnOneCol(string4, hashMap);
            SQLException sQLException = dBUtil.getLastException();
            if (sQLException != null) {
                throw sQLException;
            }
        }
        catch (SQLException sQLException) {
            LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
        }
        return string3;
    }

    @Override
    protected String getParentObjectName() {
        return this.getObjectName();
    }

    @Override
    protected String getParentObjectType() {
        return this.getType();
    }

    @Override
    protected String getObjectName() {
        String string = this.getDBObject().getObjectName();
        return string;
    }

    @Override
    public String getType() {
        String string = this.getDBObject().getObjectType();
        return string;
    }

    @Override
    protected String getTitle(String string) {
        String string2 = HCSArb.getString("AV_VALIDATION_ACTION_RAPTOR_TASK_TITLE");
        return string2;
    }

    @Override
    protected String getProgressMessage() {
        String string = HCSArb.getString("AV_VALIDATION_ACTION_RAPTOR_TASK_RUNNING_MSG");
        return string;
    }

    @Override
    protected ActionConfirmPanel getConfirmationPanel() {
        Database database = this.getDBObject().getDatabase();
        String string = this.getObjectName();
        string = database.getExternalName(string);
        String string2 = HCSArb.format("AV_VALIDATION_NOTIFICATION", string);
        JLabel jLabel = new JLabel(string2);
        ActionConfirmPanel actionConfirmPanel = new ActionConfirmPanel(){};
        actionConfirmPanel.add(jLabel);
        return actionConfirmPanel;
    }

    @Override
    protected String getHelpID() {
        return HELP_ID;
    }

    @Override
    protected void actionPostProcess() {
        final DBObject dBObject = this.getDBObject();
        final ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        arrayList.add(dBObject);
        final String string = dBObject.getSchemaName();
        final OracleDatabaseImpl oracleDatabaseImpl = (OracleDatabaseImpl)this.getDBObject().getDatabase();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Database database = dBObject.getDatabase();
                String string2 = database.getExternalName(dBObject.getObjectName());
                if (!AVValidationAction.this.showCompileErrors) {
                    HCSValidationQuery hCSValidationQuery = new HCSValidationQuery(dBObject);
                    Long l = hCSValidationQuery.getMaxLogNumberFromValidationTable(string, AVValidationAction.VALIDATION_LOG_TABLE);
                    boolean bl = hCSValidationQuery.isValidationSuccessful(string, AVValidationAction.VALIDATION_LOG_TABLE, l);
                    if (!bl) {
                        HCSValidationPanel hCSValidationPanel = new HCSValidationPanel(oracleDatabaseImpl, string, dBObject, AVValidationAction.VALIDATION_LOG_TABLE, l, HCSArb.getString("AV_VALIDATION_RESULTS_LABEL"));
                        HCSValidationDialog hCSValidationDialog = new HCSValidationDialog(HCSArb.format("AV_VALIDATION_DIALOG_TITLE", string + "." + string2), hCSValidationPanel, string, dBObject);
                        hCSValidationDialog.setVisible(true);
                    } else {
                        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), HCSArb.format("AV_VALIDATION_SUCCESS_MSG", string, string2), AVValidationAction.this.getTitle(string2), 1);
                    }
                } else {
                    CompilationResultsPanel compilationResultsPanel = new CompilationResultsPanel(string, arrayList, HCSArb.getString("AV_VALIDATION_RESULTS_LABEL"));
                    CompilationResultsDialog compilationResultsDialog = new CompilationResultsDialog(HCSArb.format("AV_VALIDATION_DIALOG_TITLE", string + "." + string2), compilationResultsPanel, string, arrayList);
                    compilationResultsDialog.setVisible(true);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
        this.refreshNavigator(dBObject, this.getParentObjectName());
    }

    static {
        LOG = Logger.getLogger(AVValidationAction.class.getName());
    }
}

